/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.Assert;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.Collection;

public abstract class EOGenericCockpitDatabaseData
extends EOEncodableObject
implements ICockpitProjectData {
    private static final String XML_ATTR_UID = "uID";
    private static final String XML_ATTR_PROJECT_UID = "projectUID";
    private static final String XML_ATTR_DATATYPE_ID = "dataTypeID";
    private static final String XML_ATTR_MODCOUNT = "modCount";
    private static final String XML_ATTR_COMMIT_COUNT = "commitCount";
    private static final String XML_ATTR_ISHISTORICITEM = "isHistoricItem";
    public static final String ROLE_INLINKLOGS = "inLinkLogs";
    public static final String ROLE_OUTLINKLOGS = "outLinkLogs";
    private String uID;
    private String projectUID;
    private String dataTypeID;
    private int modCount;
    private int commitCount;
    private boolean isHistoricItem;
    private EOList<EOLinkLog> inLinkLogs = new EOList("inLinkLogs");
    private EOList<EOLinkLog> outLinkLogs = new EOList("outLinkLogs");

    public EOGenericCockpitDatabaseData(String xmlName) {
        super(xmlName);
    }

    public EOGenericCockpitDatabaseData(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    public EOGenericCockpitDatabaseData(String xmlName, EOGenericCockpitDatabaseData template) {
        super(xmlName);
        this.uID = template.uID;
        this.projectUID = template.projectUID;
        this.dataTypeID = template.dataTypeID;
        this.modCount = template.modCount;
        this.commitCount = template.commitCount;
        this.isHistoricItem = template.isHistoricItem;
    }

    public String getUID() {
        return this.uID;
    }

    public void setUID(String uid) {
        assert (Assert.checkArgumentBeeingNotNull((Object)uid));
        this.uID = uid;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public void setProjectUID(String projectUID) {
        assert (Assert.checkArgumentBeeingNotNull((Object)projectUID));
        this.projectUID = projectUID;
    }

    public String getTypeID() {
        return this.dataTypeID;
    }

    public void setTypeID(String dataTypeID) {
        assert (Assert.checkArgumentBeeingNotNull((Object)dataTypeID));
        assert (dataTypeID.length() < 129);
        this.dataTypeID = dataTypeID;
    }

    public int getModCount() {
        return this.modCount;
    }

    public void setModCount(int modCount) {
        this.modCount = modCount;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public boolean isHistoricItem() {
        return this.isHistoricItem;
    }

    public void setIsHistoricItem(boolean isHistoricItem) {
        this.isHistoricItem = isHistoricItem;
    }

    public void setInLinkLogs(Collection<EOLinkLog> links) {
        assert (links != null) : "links must be a non-null list of EOLinkLog objects";
        this.inLinkLogs.clear();
        this.inLinkLogs.addAll(links);
    }

    public void addInLinkLogs(Collection<EOLinkLog> links) {
        assert (links != null) : "links must be a non-null list of EOLinkLog objects";
        this.inLinkLogs.addAll(links);
    }

    public void addInLinkLog(EOLinkLog link) {
        assert (link != null) : "link must not be null";
        this.inLinkLogs.add((EncodableObjectBase)link);
    }

    public Collection<EOLinkLog> getInLinkLogs() {
        return new ArrayList<EOLinkLog>((Collection<EOLinkLog>)this.inLinkLogs);
    }

    public void setOutLinkLogs(Collection<EOLinkLog> links) {
        assert (links != null) : "links must be a non-null list of EOLinkLog objects";
        this.outLinkLogs.clear();
        this.outLinkLogs.addAll(links);
    }

    public void addOutLinkLogs(Collection<EOLinkLog> links) {
        assert (links != null) : "links must be a non-null list of EOLinkLog objects";
        this.outLinkLogs.addAll(links);
    }

    public void addOutLinkLog(EOLinkLog link) {
        assert (link != null) : "link must not be null";
        this.outLinkLogs.add((EncodableObjectBase)link);
    }

    public Collection<EOLinkLog> getOutLinkLogs() {
        return new ArrayList<EOLinkLog>((Collection<EOLinkLog>)this.outLinkLogs);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(XML_ATTR_UID)) {
            this.uID = value;
            return true;
        }
        if (name.equals(XML_ATTR_PROJECT_UID)) {
            this.projectUID = value;
            return true;
        }
        if (name.equals(XML_ATTR_DATATYPE_ID)) {
            this.dataTypeID = value;
            return true;
        }
        if (name.equals(XML_ATTR_MODCOUNT)) {
            this.modCount = this.toInt(value);
            return true;
        }
        if (name.equals(XML_ATTR_COMMIT_COUNT)) {
            this.commitCount = this.toInt(value);
            return true;
        }
        if (name.equals(XML_ATTR_ISHISTORICITEM)) {
            this.isHistoricItem = this.toBoolean(value);
            return true;
        }
        return false;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, XML_ATTR_UID, this.uID);
        this.appendAttrToXML(writeContext, XML_ATTR_PROJECT_UID, this.projectUID);
        this.appendAttrToXML(writeContext, XML_ATTR_DATATYPE_ID, this.dataTypeID);
        this.appendAttrToXML(writeContext, XML_ATTR_MODCOUNT, this.modCount);
        this.appendAttrToXML(writeContext, XML_ATTR_COMMIT_COUNT, this.commitCount);
        this.appendAttrToXML(writeContext, XML_ATTR_ISHISTORICITEM, this.isHistoricItem);
    }

    protected boolean hasChildren() {
        return this.isHistoricItem && (!this.inLinkLogs.isEmpty() || !this.outLinkLogs.isEmpty());
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.isHistoricItem) {
            if (!this.inLinkLogs.isEmpty()) {
                this.inLinkLogs.writeXMLBody(writeContext, depth);
            }
            if (!this.outLinkLogs.isEmpty()) {
                this.outLinkLogs.writeXMLBody(writeContext, depth);
            }
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild instanceof EOList) {
            EOList list = (EOList)newChild;
            String role = list.getRole();
            if (role.equals(ROLE_INLINKLOGS)) {
                this.inLinkLogs = list;
                return true;
            }
            if (role.equals(ROLE_OUTLINKLOGS)) {
                this.outLinkLogs = list;
                return true;
            }
        }
        return false;
    }
}

