/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EOFileMetaInformation
extends EOEncodableObject {
    public static String XML_NAME = "frame.metainformation";
    private static final String ATTR_TAG_UID = "uid";
    private static final String ATTR_TAG_PROJECT_UID = "projectUID";
    private static final String ATTR_TAG_COMMIT_COUNT = "commitCount";
    private static final String ATTR_TAG_ORIGINAL_FILENAME = "originalFilename";
    private static final String ATTR_TAG_CREATION_DATE = "creationDate";
    private String fileUID;
    private String projectUID;
    private int commitCount;
    private String originalFileName;
    private long creationDate;

    public EOFileMetaInformation(String fileUID, String projectUID, int commitCount, String originalFilename, long creationDate) {
        super(XML_NAME);
        assert (fileUID != null) : "uid can't be null";
        assert (projectUID != null) : "projectUID can't be null";
        assert (commitCount == 0 || commitCount >= 1) : "commit count invalid";
        this.fileUID = fileUID;
        this.projectUID = projectUID;
        this.commitCount = commitCount;
        this.originalFileName = originalFilename;
        this.creationDate = creationDate;
    }

    public EOFileMetaInformation() {
        super(XML_NAME);
    }

    public EOFileMetaInformation(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_UID, this.fileUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UID, this.projectUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_COMMIT_COUNT, this.commitCount);
        if (this.originalFileName != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ORIGINAL_FILENAME, this.originalFileName);
        }
        this.appendAttrToXML(writeContext, ATTR_TAG_CREATION_DATE, this.creationDate);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_UID)) {
            this.fileUID = value;
        } else if (name.equals(ATTR_TAG_PROJECT_UID)) {
            this.projectUID = value;
        } else if (name.equals(ATTR_TAG_COMMIT_COUNT)) {
            this.commitCount = this.toInt(value);
        } else if (name.equals(ATTR_TAG_ORIGINAL_FILENAME)) {
            this.originalFileName = value;
        } else if (name.equals(ATTR_TAG_CREATION_DATE)) {
            this.creationDate = this.toLong(value);
        } else {
            success = false;
        }
        return success;
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return true;
    }

    public String getFileUID() {
        return this.fileUID;
    }

    public void setFileUID(String uid) {
        assert (uid != null) : "uid can't be null";
        this.fileUID = uid;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public void setProjectUID(String projectUID) {
        assert (projectUID != null) : "projectUID can't be null";
        this.projectUID = projectUID;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public String getOriginalFileName() {
        if (this.originalFileName == null) {
            this.originalFileName = "";
        }
        return this.originalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }
}

