/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.frame;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameDataConverter;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterModuleManager;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IProperty;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;

public class FrameProperty
implements IProperty {
    private final IRepositoryPropertyTypeID repositoryPropertyTypeID;
    private final IRepositoryData repositoryData;

    public static IAttribute convertRepositoryDataToCockpitAttribute(IRepositoryData sourceRepositoryData, IAttributeType attributeType) {
        IAttributeTypeDataType targetCockpitDataType = attributeType.getDataType();
        IValueRange targetCockpitValueRange = attributeType.getValueRange();
        Object cockpitValue = FrameDataConverter.convertRepositoryDataToCockpitAttribute(sourceRepositoryData, targetCockpitDataType, targetCockpitValueRange);
        Attribute cockpitAttribute = new Attribute(attributeType.getAttributeTypeID(), cockpitValue);
        return cockpitAttribute;
    }

    public FrameProperty(IFrameProjectAgent projectAgent, IAttributeOwner frameData, IAttributeTypeID attributeTypeID, IPropertyType propertyType) {
        this.repositoryPropertyTypeID = propertyType.getPropertyTypeID();
        IRepositoryTypeManagerRO typeManager = projectAgent.getRepositoryInterface().getTypeManager();
        IRepositoryDataType dataType = typeManager.getDataType(propertyType.getDataTypeID());
        PlatformAdapterModuleManager platformAdapterModuleManager = projectAgent.getCockpitController().getPlatformAdapterModuleManager();
        IDataManagerAdapter dataManagerAdapter = platformAdapterModuleManager.getDataManagerAdapter((ICockpitProjectData)frameData);
        IRepositoryObjectTypeID repositoryObjectTypeID = dataManagerAdapter.getRepositoryObjectTypeID();
        IRepositoryObjectType repositoryObjectType = typeManager.getObjectType(repositoryObjectTypeID);
        IRepositoryPropertyTypeID propertyTypeID = propertyType.getPropertyTypeID();
        IRepositoryPropertyType repositoryPropertyType = repositoryObjectType.getAttributeSetType(propertyTypeID).getPropertyType(propertyTypeID);
        IAttributeType attributeType = frameData.getAttributeType(attributeTypeID);
        IAttribute attribute = frameData.getAttribute(attributeTypeID);
        IAttributeTypeDataType sourceAttributeTypeDataType = attributeType.getDataType();
        IValueRange sourceValueRange = attributeType.getValueRange();
        Object sourceValue = attribute.getAttributeValue();
        IRepositoryDataType targetDataType = dataType;
        IRepositoryDataTypeParameters targetDataTypeParameters = repositoryPropertyType.getDataTypeParameters();
        this.repositoryData = FrameDataConverter.convertCockpitAttributeToRepositoryData(sourceAttributeTypeDataType, sourceValueRange, sourceValue, targetDataType, targetDataTypeParameters);
    }

    @Override
    public IRepositoryPropertyTypeID getPropertyTypeID() {
        return this.repositoryPropertyTypeID;
    }

    @Override
    public IRepositoryData getValue() {
        return this.repositoryData;
    }
}

