/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planeditors;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.editors.EditorsListSelectionDialog;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PlanEditorLauncher {
    private static final ILogger logger = Logger.getLogger(PlanEditorLauncher.class);
    private final PlanDisplayParameters planDisplayParameters;
    private final int mode;
    private final boolean switchModeIfOpen;

    private static List<IPlan> getSelectedPlans(ISelection selection) {
        ArrayList<IPlan> plans = new ArrayList<IPlan>();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                if (selectedObject instanceof IPlan) {
                    plans.add((IPlan)selectedObject);
                }
                ++n2;
            }
        }
        return plans;
    }

    private static IFrameProjectAgent getProjectAgent(IPlan plan) {
        return ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
    }

    public PlanEditorLauncher(int mode, boolean switchModeIfOpen) {
        this.planDisplayParameters = new PlanDisplayParameters();
        this.mode = mode;
        this.switchModeIfOpen = switchModeIfOpen;
    }

    public PlanEditorLauncher(PlanDisplayParameters planDisplayParameters) {
        this.planDisplayParameters = planDisplayParameters;
        this.mode = 3;
        this.switchModeIfOpen = false;
    }

    PlanEditorLauncher() {
        this.planDisplayParameters = new PlanDisplayParameters();
        this.mode = 3;
        this.switchModeIfOpen = false;
    }

    public int getMode() {
        return this.mode;
    }

    private Collection<IExternalPlanEditorControllerExtension> getPlanEditorControllerExtensions(IWorkbenchPage page, IPlan plan) {
        IFrameProjectAgent projectAgent = PlanEditorLauncher.getProjectAgent(plan);
        return projectAgent.getPlanEditorManager().getPlanEditorControllerExtensions(plan, page, this.planDisplayParameters);
    }

    private Collection<IExternalPlanEditorControllerExtension> getPlanEditorControllerExtensionsInEditMode(IWorkbenchPage page, IPlan plan) {
        IFrameProjectAgent projectAgent = PlanEditorLauncher.getProjectAgent(plan);
        return projectAgent.getPlanEditorManager().getPlanEditorControllerExtensionsInEditMode(plan, page, this.planDisplayParameters);
    }

    public boolean isPlanEditorControllerInEditMode(IWorkbenchPage page, ISelection selection) {
        List<IPlan> plans = PlanEditorLauncher.getSelectedPlans(selection);
        return this.isPlanEditorControllerInEditMode(page, plans);
    }

    public boolean isPlanEditorControllerInEditMode(IWorkbenchPage page, List<IPlan> plans) {
        for (IPlan plan : plans) {
            Collection<IExternalPlanEditorControllerExtension> openEditors = this.getPlanEditorControllerExtensionsInEditMode(page, plan);
            if (!openEditors.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isOpenOrShowPlanEditorsPossible(IWorkbenchPage page, ISelection selection) {
        List<IPlan> plans = PlanEditorLauncher.getSelectedPlans(selection);
        return this.isOpenOrShowPlanEditorsPossible(page, plans);
    }

    public boolean isOpenOrShowPlanEditorsPossible(IWorkbenchPage page, List<IPlan> plans) {
        boolean atLeastOneIsPossible = false;
        boolean atLeastOneIsImpossible = false;
        for (IPlan plan : plans) {
            boolean planIsPossible;
            IFrameProjectAgent projectAgent = PlanEditorLauncher.getProjectAgent(plan);
            boolean planIsWriteAccessedElsewhere = projectAgent.getPlanAgentManager().isPlanWriteAccessed(plan);
            Collection<IExternalPlanEditorControllerExtension> openEditors = this.getPlanEditorControllerExtensions(page, plan);
            if (openEditors.isEmpty()) {
                planIsPossible = this.mode != 1 || !planIsWriteAccessedElsewhere;
            } else {
                Collection<IExternalPlanEditorControllerExtension> editorsInEditMode = this.getPlanEditorControllerExtensionsInEditMode(page, plan);
                boolean planIsWriteAccessedHere = !editorsInEditMode.isEmpty();
                boolean planIsNotPossible = this.mode == 1 && this.switchModeIfOpen && !planIsWriteAccessedHere && planIsWriteAccessedElsewhere;
                planIsPossible = !planIsNotPossible;
            }
            atLeastOneIsPossible = atLeastOneIsPossible || planIsPossible;
            boolean bl = atLeastOneIsImpossible = atLeastOneIsImpossible || !planIsPossible;
        }
        return atLeastOneIsPossible && !atLeastOneIsImpossible;
    }

    public void openOrShowPlanEditors(IWorkbenchPage page, ISelection selection) {
        List<IPlan> plans = PlanEditorLauncher.getSelectedPlans(selection);
        this.openOrShowPlanEditors(page, plans);
    }

    void openOrShowPlanEditor(IWorkbenchPage page, PlanEditorManager planEditorManager, IPlan plan) {
        this.openOrShowPlanEditors(page, planEditorManager, Collections.singletonList(plan));
    }

    public void openOrShowPlanEditors(IWorkbenchPage page, List<IPlan> plans) {
        this.openOrShowPlanEditors(page, null, plans);
    }

    private void openOrShowPlanEditors(IWorkbenchPage page, PlanEditorManager planEditorManagerOrNullIfUnknown, List<IPlan> plans) {
        ArrayList<IEditorPart> editorsToSave = new ArrayList<IEditorPart>();
        if (this.switchModeIfOpen && this.mode != 1) {
            for (IPlan plan : plans) {
                Collection<IExternalPlanEditorControllerExtension> openEditors = this.getPlanEditorControllerExtensions(page, plan);
                for (IExternalPlanEditorControllerExtension openEditor : openEditors) {
                    if (!openEditor.isDirty()) continue;
                    editorsToSave.add(openEditor.getEditorPart());
                }
            }
        }
        boolean cancel = false;
        if (editorsToSave.isEmpty()) {
            cancel = false;
        } else {
            String message = Messages.getString("SwitchModeAction.There_are_changes_associated_with_this_plan._nShould_the_plan_be_saved_before_switching_the_mode__11");
            EditorsListSelectionDialog dialog = new EditorsListSelectionDialog(page.getWorkbenchWindow().getShell(), message, editorsToSave);
            dialog.setInitialSelections(editorsToSave.toArray());
            int returnCode = dialog.open();
            if (returnCode == 0) {
                Object[] result = dialog.getResult();
                if (result != null) {
                    Object[] objectArray = result;
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        IEditorPart part = (IEditorPart)element;
                        part.getSite().getPage().saveEditor(part, false);
                        ++n2;
                    }
                }
                cancel = false;
            } else if (returnCode == 1) {
                cancel = true;
            }
        }
        if (!cancel && !plans.isEmpty()) {
            boolean bl = cancel = this.updatePerspective(page) == 1;
            if (!cancel) {
                ArrayList<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
                for (IPlan plan : plans) {
                    PlanEditorManager planEditorManager = PlanEditorLauncher.determineResponsiblePlanEditorManager(planEditorManagerOrNullIfUnknown, plan);
                    modificationProblems.addAll(this.launchPlan(page, plan, planEditorManager));
                }
                PlanEditorLauncher.showOpenProblems(page, modificationProblems);
            }
        }
    }

    private static PlanEditorManager determineResponsiblePlanEditorManager(PlanEditorManager planEditorManagerOrNullIfUnknown, IPlan plan) {
        IFrameProjectAgent projectAgent;
        PlanEditorManager planEditorManager = planEditorManagerOrNullIfUnknown == null ? ((projectAgent = PlanEditorLauncher.getProjectAgent(plan)) != null ? projectAgent.getPlanEditorManager() : null) : planEditorManagerOrNullIfUnknown;
        return planEditorManager;
    }

    private List<? extends IModificationProblem> launchPlan(IWorkbenchPage page, IPlan plan, PlanEditorManager planEditorManager) {
        List<ModificationProblem> modificationProblemsForThisPlan = planEditorManager != null ? planEditorManager.launchPlan(page, plan, this.mode, this.switchModeIfOpen, this.planDisplayParameters) : Collections.singletonList(new ModificationProblem(Messages.getString("PlanEditorManager.UnknownProject"), Messages.getString("PlanEditorManager.CannotOpenPlan.Message")));
        return modificationProblemsForThisPlan;
    }

    private static void showOpenProblems(IWorkbenchPage page, List<IModificationProblem> modificationProblems) {
        if (!modificationProblems.isEmpty()) {
            String title = Messages.getString("PlanEditorManager.CannotOpenPlan.Title");
            String message = Messages.getString("PlanEditorManager.CannotOpenPlan.Message");
            ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(modificationProblems, title, message, page.getWorkbenchWindow().getShell());
            mpDialog.open();
        }
    }

    private int updatePerspective(IWorkbenchPage workbenchPage) {
        int userSelection;
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPerspective = registry.findPerspectiveWithId(this.getPreferredPerspectiveID());
        if (finalPerspective == null) {
            logger.warn("Unable to find perspective" + FramePlugin.getResourceString(String.valueOf(this.getPreferredPerspectiveID()) + "in CreateNewProjectWizard.updatePerspective()"));
            userSelection = 3;
        } else {
            IPerspectiveDescriptor currentPerspective = workbenchPage.getPerspective();
            if (finalPerspective.getId().equals(currentPerspective.getId())) {
                userSelection = 3;
            } else {
                IWorkbenchWindow workbenchWindow = workbenchPage.getWorkbenchWindow();
                int _switch = this.confirmPerspectiveSwitch(workbenchWindow, finalPerspective);
                if (_switch == 3 || _switch == 1) {
                    userSelection = _switch;
                } else {
                    workbenchPage.setPerspective(finalPerspective);
                    userSelection = 2;
                }
            }
        }
        return userSelection;
    }

    private String getPreferredPerspectiveID() {
        String preferredPerspectiveID = this.mode == 1 ? "com.arcway.cockpit.frame.editperspective" : "com.arcway.cockpit.frame.mainperspective";
        return preferredPerspectiveID;
    }

    private String getSwitchPreferenceKey() {
        String switchPreferenceKey = this.mode == 1 ? "SwitchToEditPerspective" : "SwitchToMainPerspective";
        return switchPreferenceKey;
    }

    private int confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPerspective) {
        IPreferenceStore store = FramePlugin.getDefault().getPreferenceStore();
        String switchPref = store.getString(this.getSwitchPreferenceKey());
        if (switchPref.equals("always")) {
            return 2;
        }
        if (switchPref.equals("never")) {
            return 3;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)window.getShell(), (String)Messages.getString("AbstractOpenPlanAction.SwitchDialogTitle"), (String)(String.valueOf(Messages.getString("AbstractOpenPlanAction.SwitchDialogText_1")) + finalPerspective.getLabel() + Messages.getString("AbstractOpenPlanAction.SwitchDialogText_2")), (String)Messages.getString("AbstractOpenPlanAction.SwitchDialogToggle"), (boolean)false, (IPreferenceStore)store, (String)this.getSwitchPreferenceKey());
        return dialog.getReturnCode();
    }
}

