/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version6;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOProject_V5;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version6.HistoricProjectDumpView_6_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version6.HistoricProjectFileView_6_;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ObjectTypeCategoryListMigrator
implements ICockpitMigrator {
    public static final String KEY = "ObjectTypeCategoryListMigrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 6;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_6_ historicView = (HistoricProjectDumpView_6_)projectDump;
        try {
            for (EOProject_V5 project : historicView.getAllProjects()) {
                File objectTypeCategoriesFile = new File(historicView.getProjectDirectory(project), "objectTypeCategories.xml");
                if (objectTypeCategoriesFile.exists()) continue;
                EOList objectTypeCategories = new EOList();
                objectTypeCategories.writeToFile(objectTypeCategoriesFile);
            }
        }
        catch (IOException ioE) {
            throw new MigrationFailedException(ioE);
        }
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    public void migrateProjectFile(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_6_ historicView = (HistoricProjectFileView_6_)projectFile;
        try {
            EOList<? extends EncodableObjectBase> objectTypeCategoryList = historicView.getDataList("object-type-category");
            if (objectTypeCategoryList == null) {
                historicView.getMainData().add((EncodableObjectBase)new EOList("object-type-category"));
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException(pfaE);
        }
    }
}

