/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version5;

import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOAttributeTypeID_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOAttribute_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOUniqueElement_V5;
import com.arcway.cockpit.frame.client.project.migration.migrators.version5.MigratorHelper_V5;
import com.arcway.cockpit.frame.shared.UniqueElementNormalizer;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class UniqueElementEmptyNameMigratorDataPath {
    private static final ILogger logger = Logger.getLogger(UniqueElementEmptyNameMigratorDataPath.class);
    private static final String ATTR_HUMAN_READABLE_ID_DISPLAY_NAME = "displayName";
    private static final String ATTR_HUMAN_READABLE_ID_ELEMENT_TYPE = "elementType";
    private static final String ATTR_TAG_DISPLAY_NAME = "frame.uniqueElement.displayName";
    private static final String ATTR_TAG_ELEMENT_TYPE = "frame.uniqueElement.elementType";
    private static final String OLD_ATTR_TAG_DISPLAY_NAME = "displayname";
    private static final String OLD_ATTR_TAG_ELEMENT_TYPE = "elementtype";

    public static void migrateUniqueElementList(EOList<EOUniqueElement_V5> uniqueElementList) {
        HashMap<String, ArrayList<EOUniqueElement_V5>> typeID2uesWithEmptyName = new HashMap<String, ArrayList<EOUniqueElement_V5>>(3);
        for (EOUniqueElement_V5 uniqueElement : uniqueElementList) {
            String formerUniqueElementName = UniqueElementEmptyNameMigratorDataPath.getDisplayName(uniqueElement);
            if (formerUniqueElementName != null) {
                String canonicalUniqueElementName = UniqueElementNormalizer.normalizeValue((String)formerUniqueElementName);
                if (canonicalUniqueElementName != null && canonicalUniqueElementName.length() != 0) continue;
                String typeID = UniqueElementEmptyNameMigratorDataPath.getElementTypeID(uniqueElement);
                ArrayList<EOUniqueElement_V5> uesWithEmptyNames = (ArrayList<EOUniqueElement_V5>)typeID2uesWithEmptyName.get(typeID);
                if (uesWithEmptyNames == null) {
                    uesWithEmptyNames = new ArrayList<EOUniqueElement_V5>();
                    typeID2uesWithEmptyName.put(typeID, uesWithEmptyNames);
                }
                uesWithEmptyNames.add(uniqueElement);
                continue;
            }
            logger.error("unique element migrator recognized UE with null name (UE-UID: " + uniqueElement.getUID() + ")");
        }
        for (Collection uesWithEmptyName : typeID2uesWithEmptyName.values()) {
            int iteration = 1;
            for (EOUniqueElement_V5 ueWithEmptyName : uesWithEmptyName) {
                String displayNameWithTypePostfix = UniqueElementEmptyNameMigratorDataPath.getDisplayNameWithTypePostfix(iteration);
                UniqueElementEmptyNameMigratorDataPath.setDisplayName(ueWithEmptyName, displayNameWithTypePostfix);
                ++iteration;
            }
        }
    }

    private static String getDisplayNameWithTypePostfix(int iteration) {
        String displayNameWithTypePostfix = "- no name -";
        if (iteration != 1) {
            displayNameWithTypePostfix = String.valueOf(displayNameWithTypePostfix) + " " + iteration;
        }
        return displayNameWithTypePostfix;
    }

    private static String getDisplayName(EOUniqueElement_V5 eoUniqueElement) {
        String stringValue = MigratorHelper_V5.getStringAttribute(eoUniqueElement, ATTR_TAG_DISPLAY_NAME, OLD_ATTR_TAG_DISPLAY_NAME);
        if (stringValue == null) {
            logger.warn("Cannot read UE attribute (UE-UID: " + eoUniqueElement.getUID() + ", " + ATTR_TAG_DISPLAY_NAME + ")");
        }
        return stringValue;
    }

    private static String getElementTypeID(EOUniqueElement_V5 eoUniqueElement) {
        String stringValue = MigratorHelper_V5.getStringAttribute(eoUniqueElement, ATTR_TAG_ELEMENT_TYPE, OLD_ATTR_TAG_ELEMENT_TYPE);
        if (stringValue == null) {
            logger.warn("Cannot read UE attribute (UE-UID: " + eoUniqueElement.getUID() + ", " + ATTR_TAG_ELEMENT_TYPE + ")");
        }
        return stringValue;
    }

    private static void setDisplayName(EOUniqueElement_V5 eoUniqueElement, String newUnqiueElementName) {
        UniqueElementEmptyNameMigratorDataPath.setStringAttribute(eoUniqueElement, ATTR_TAG_DISPLAY_NAME, ATTR_HUMAN_READABLE_ID_DISPLAY_NAME, OLD_ATTR_TAG_DISPLAY_NAME, newUnqiueElementName);
    }

    private static void setStringAttribute(EOUniqueElement_V5 eoUniqueElement, String attributeTypeIDasString, String humanReadableID, String oldAttributeID, String newValue) {
        EOAttributeTypeID_V5 attributeTypeID = new EOAttributeTypeID_V5(attributeTypeIDasString, humanReadableID);
        EOAttribute_V5 attributeWithNewValue = new EOAttribute_V5();
        attributeWithNewValue.setAttributeTypeID(attributeTypeID);
        attributeWithNewValue.setValueAsEO((EOEncodableObject)new EOString(newValue));
        eoUniqueElement.addAttribute(attributeWithNewValue);
        eoUniqueElement.clearOldAttribute(oldAttributeID);
    }
}

