/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version3;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.Messages;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttributeTypeID_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttribute_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFrameData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

public class ReportTemplateRootFolderMigrator
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(ReportTemplateRootFolderMigrator.class);
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version3.reporttemplaterootfoldermigrator";
    private static final String DATA_TYPE_ID_REPORT_TEMPLATE_CONTAINER = "com.arcway.cockpit.object.data.reporttemplatecontainer";
    private static final String ATTRIBUTE_TYPE_ID_NAME_UID = "com.arcway.cockpit.object.data.reporttemplatecontainer.property.name";
    private static final String ATTRIBUTE_TYPE_ID_NAME_HUMANREADABLE_ID = "name";
    private static final String ATTRIBUTE_TYPE_ID_DESCRIPTION_UID = "com.arcway.cockpit.object.data.reporttemplatecontainer.property.description";
    private static final String ATTRIBUTE_TYPE_ID_DESCRIPTION_HUMANREADABLE_ID = "description";
    private static final String LINK_TYPE_ID = "parent_child_frame.project_com.arcway.cockpit.object.data.reporttemplatecontainer";
    private static final String FRAME_LINK_MANAGER_MODULE_ID = "frame";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
        List<EOProject_V0> projects = historicView.getAllProjects();
        if (projects != null) {
            for (EOProject_V0 currentProject : projects) {
                try {
                    boolean rootReportTemplateContainerFound = false;
                    EncodableObjectBase frameDataBase = historicView.readDataFile(currentProject, "frameData.xml", null, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), PSCPlainMessageDataFactory.getDefault()}));
                    EOList frameDataList = null;
                    if (frameDataBase != null) {
                        if (frameDataBase instanceof EOList) {
                            frameDataList = (EOList)frameDataBase;
                            for (Object o : frameDataList) {
                                if (o instanceof EOFrameData_V0) {
                                    EOFrameData_V0 eoFrameData = (EOFrameData_V0)((Object)o);
                                    if (!eoFrameData.getTypeID().equals(DATA_TYPE_ID_REPORT_TEMPLATE_CONTAINER)) continue;
                                    rootReportTemplateContainerFound = true;
                                    break;
                                }
                                throw new MigrationFailedException("The frame data list contains an element not of type EOFrameData_V0: " + o.getClass().getName());
                            }
                        } else {
                            throw new MigrationFailedException("The frame data list is not of type EOList: " + frameDataBase.getClass().getName());
                        }
                    }
                    if (rootReportTemplateContainerFound) continue;
                    EOList<EOFrameData_V0> targetFrameDataList = this.getFrameDataList(frameDataList);
                    EncodableObjectBase linkData = historicView.readLinks_3(currentProject);
                    EOList linkDataList = null;
                    if (linkData instanceof EOLinkDataContainer_V0) {
                        linkDataList = ((EOLinkDataContainer_V0)linkData).getLinks();
                    } else if (linkData instanceof EOList) {
                        linkDataList = (EOList)linkData;
                    } else {
                        throw new MigrationFailedException("Unexpected format of the link data in the project dump.");
                    }
                    this.createRootFolder(currentProject.getProjectUID(), (EOList<EOLink_V0>)linkDataList, targetFrameDataList);
                    historicView.writeDataFile(currentProject, "frameData.xml", null, (EncodableObjectBase)targetFrameDataList);
                }
                catch (EXDecoderException e) {
                    throw new MigrationFailedException(e);
                }
            }
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    private void migrateACTOrACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        try {
            boolean rootReportTemplateContainerFound = false;
            HistoricProjectFileView_3_ projectFileView_3_ = (HistoricProjectFileView_3_)projectFile;
            EOList<? extends EncodableObjectBase> dataListFrameData = projectFileView_3_.getDataList("frame_data");
            if (dataListFrameData != null) {
                for (Object o : dataListFrameData) {
                    if (o instanceof EOList) {
                        EOList eoSingleFrameDataList = (EOList)o;
                        if (!eoSingleFrameDataList.getRole().equals(DATA_TYPE_ID_REPORT_TEMPLATE_CONTAINER) || eoSingleFrameDataList.size() <= 0) continue;
                        rootReportTemplateContainerFound = true;
                        continue;
                    }
                    throw new MigrationFailedException("The frame data list contains an element not of type EOList: " + o.getClass().getName());
                }
            }
            if (!rootReportTemplateContainerFound) {
                EOList<EOFrameData_V0> repTempContainerList = this.getRepTempContainerList(projectFileView_3_, dataListFrameData);
                String projectUID = projectFileView_3_.getProjectMetaData().getProjectUID();
                this.createRootFolder(projectUID, this.getLinkList(projectFileView_3_), repTempContainerList);
                projectFileView_3_.closeView();
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            logger.error("Can not migrate project file.", (Throwable)pfaE);
            throw new MigrationFailedException(pfaE);
        }
    }

    private void createRootFolder(String projectUID, EOList<EOLink_V0> linkList, EOList<EOFrameData_V0> repTempContainerList) {
        EOFrameData_V0 rootFolder = new EOFrameData_V0();
        String uid = UUIDGenerator.getUniqueID();
        rootFolder.setUID(uid);
        rootFolder.setProjectUID(projectUID);
        rootFolder.setDataTypeID(DATA_TYPE_ID_REPORT_TEMPLATE_CONTAINER);
        rootFolder.setModCount(1);
        rootFolder.setModTime(new Timestamp(System.currentTimeMillis()));
        EOAttribute_V0 name = new EOAttribute_V0();
        EOAttributeTypeID_V0 nameAtribTypeID = new EOAttributeTypeID_V0(ATTRIBUTE_TYPE_ID_NAME_UID, ATTRIBUTE_TYPE_ID_NAME_HUMANREADABLE_ID);
        name.setAttributeTypeID(nameAtribTypeID);
        EOString nameValue = new EOString(Messages.getString("ReportTemplateRootFolderMigrator.RootFolder.Name"));
        name.setValueAsEO((EOEncodableObject)nameValue);
        EOAttribute_V0 desc = new EOAttribute_V0();
        EOAttributeTypeID_V0 descAtribTypeID = new EOAttributeTypeID_V0(ATTRIBUTE_TYPE_ID_DESCRIPTION_UID, ATTRIBUTE_TYPE_ID_DESCRIPTION_HUMANREADABLE_ID);
        desc.setAttributeTypeID(descAtribTypeID);
        EOString descValue = new EOString(Messages.getString("ReportTemplateRootFolderMigrator.RootFolder.Description"));
        desc.setValueAsEO((EOEncodableObject)descValue);
        rootFolder.addAttribute(desc);
        rootFolder.addAttribute(name);
        repTempContainerList.add((EncodableObjectBase)rootFolder);
        linkList.add((EncodableObjectBase)new EOLink_V0(projectUID, projectUID, uid, FRAME_LINK_MANAGER_MODULE_ID, LINK_TYPE_ID));
    }

    private EOList<EOLink_V0> getLinkList(HistoricProjectFileView_3_ projectFileView_3_) throws MigrationFailedException, ProjectFileAccess.ProjectFileAccessException {
        EOList<? extends EncodableObjectBase> dataListLinks = projectFileView_3_.getDataList("links");
        if (dataListLinks != null) {
            EOList<? extends EncodableObjectBase> eoLinkList = dataListLinks;
            return eoLinkList;
        }
        throw new MigrationFailedException("No data list for links found.");
    }

    private EOList<EOFrameData_V0> getRepTempContainerList(HistoricProjectFileView_3_ projectFileView_3_, EOList<? extends EncodableObjectBase> dataListFrameData) throws ProjectFileAccess.ProjectFileAccessException {
        EOList resultFrameDataList;
        if (dataListFrameData == null) {
            resultFrameDataList = new EOList("frame_data");
            projectFileView_3_.getMainData().add((EncodableObjectBase)resultFrameDataList);
        } else {
            resultFrameDataList = dataListFrameData;
        }
        EOList reportTemplateContainerList = new EOList(DATA_TYPE_ID_REPORT_TEMPLATE_CONTAINER);
        resultFrameDataList.add((EncodableObjectBase)reportTemplateContainerList);
        return reportTemplateContainerList;
    }

    private EOList<EOFrameData_V0> getFrameDataList(EOList<?> frameDataList) {
        EOList resultFrameDataList = frameDataList == null ? new EOList() : frameDataList;
        return resultFrameDataList;
    }
}

