/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.configuration;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationItem;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.IConfigurationListener;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class ConfigurationMgr
implements IEncodableObjectFactory {
    private static final ILogger logger = Logger.getLogger(ConfigurationMgr.class);
    private static final String ROOTITEM_NAME = "DOCGEN_CONFIGURATION_ROOT";
    static final String REPORTITEM_NAME = "DOCGEN_CONFIGURATION_REPORT";
    private static final String REPORT_ID_SEPARATOR = "-";
    private static XMLDecoder decoder = new XMLDecoder();
    private static ConfigurationMgr instance = null;
    private static final String configurationFilename = "configuration.xml";
    private DocGenConfigurationItem configuration = null;
    private File configurationFile = null;
    private final ArrayList<IConfigurationListener> configurationListeners = new ArrayList();

    public static ConfigurationMgr getInstance() {
        if (instance == null) {
            instance = new ConfigurationMgr();
        }
        return instance;
    }

    private ConfigurationMgr() {
        String configurationDirectory = FramePlugin.getWorkspacePath("configuration");
        this.configurationFile = new File(configurationDirectory, configurationFilename);
        this.configuration = null;
        if (this.configurationFile.exists()) {
            this.configuration = this.loadConfiguration(this.configurationFile.getAbsolutePath());
        }
        if (this.configuration == null) {
            this.configuration = new DocGenConfigurationItem(ROOTITEM_NAME);
        }
        this.cleanupConfiguration();
    }

    public DocGenConfigurationPerReport getDefaultConfiguration(String reportID, String projectUID) {
        DocGenConfigurationItem configItem = this.configuration.getChild(REPORTITEM_NAME, String.valueOf(projectUID) + REPORT_ID_SEPARATOR + reportID);
        if (configItem != null) {
            this.fireConfigurationChanged(this.configuration);
        }
        this.configuration.removeChild(configItem);
        configItem = new DocGenConfigurationItem(REPORTITEM_NAME);
        configItem.setValue(String.valueOf(projectUID) + REPORT_ID_SEPARATOR + reportID);
        this.configuration.addChild(configItem);
        return new DocGenConfigurationPerReport(configItem);
    }

    public DocGenConfigurationPerReport getConfiguration(String reportID, String projectUID) {
        DocGenConfigurationItem configItem = this.configuration.getChild(REPORTITEM_NAME, String.valueOf(projectUID) + REPORT_ID_SEPARATOR + reportID);
        if (configItem == null) {
            configItem = new DocGenConfigurationItem(REPORTITEM_NAME);
            configItem.setValue(String.valueOf(projectUID) + REPORT_ID_SEPARATOR + reportID);
            this.configuration.addChild(configItem);
        }
        return new DocGenConfigurationPerReport(configItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocGenConfigurationItem loadConfiguration(String filename) {
        assert (filename != null) : "filename is null";
        DocGenConfigurationItem loadedConfiguration = null;
        File configFile = new File(filename);
        if (configFile.exists()) {
            try {
                BufferedInputStream b_in = new BufferedInputStream(new FileInputStream(configFile));
                XMLDecoder xMLDecoder = decoder;
                synchronized (xMLDecoder) {
                    loadedConfiguration = (DocGenConfigurationItem)decoder.decodeXML((InputStream)b_in, (IEncodableObjectFactory)this, true);
                }
            }
            catch (FileNotFoundException e) {
                logger.debug("Can not find file for DocGen configuration", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Exception when decoding DocGen configuration", (Throwable)e);
            }
        } else {
            logger.debug("Can not find file for DocGen configuration " + filename);
        }
        if (loadedConfiguration != null) {
            this.fireConfigurationChanged(loadedConfiguration);
        }
        return loadedConfiguration;
    }

    public boolean saveConfiguration() {
        return this.saveConfiguration(this.configurationFile.getAbsolutePath(), this.configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveConfiguration(String filename, DocGenConfigurationItem configurationToSave) {
        assert (filename != null) : "filename is null";
        boolean success = false;
        File configFile = new File(filename);
        if (configurationToSave != null) {
            try {
                ConfigurationMgr configurationMgr = this;
                synchronized (configurationMgr) {
                    configurationToSave.writeToFile(configFile);
                }
                success = true;
            }
            catch (Exception e) {
                success = false;
            }
        } else {
            assert (false) : "nothing to save";
            success = false;
        }
        return success;
    }

    private void cleanupConfiguration() {
        HashMap map_projectUID_additionalTemplatesUIDs = new HashMap();
        HashMap<String, IFrameDataManager> map_projectUID_reportTemplateDataManager = new HashMap<String, IFrameDataManager>();
        for (DocGenConfigurationItem configPerReport : this.configuration.getChildren(REPORTITEM_NAME)) {
            String idString = configPerReport.getStringValue();
            String projectUID = idString.substring(0, idString.indexOf(REPORT_ID_SEPARATOR));
            String reportID = idString.substring(idString.indexOf(REPORT_ID_SEPARATOR) + 1);
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            if (projectAgent != null) {
                if (!projectAgent.isOpened()) continue;
                HashSet<String> additionalTemplatesUIDs = (HashSet<String>)map_projectUID_additionalTemplatesUIDs.get(projectUID);
                IFrameDataManager reportTemplateDataManager = (IFrameDataManager)map_projectUID_reportTemplateDataManager.get(projectUID);
                if (additionalTemplatesUIDs == null || reportTemplateDataManager == null) {
                    additionalTemplatesUIDs = new HashSet<String>();
                    for (IReportTemplate iReportTemplate : projectAgent.getDocGeneratorManager().getBuiltInReportTemplates(new Locale(projectAgent.getLanguage()))) {
                        additionalTemplatesUIDs.add(iReportTemplate.getUID());
                    }
                    map_projectUID_additionalTemplatesUIDs.put(projectUID, additionalTemplatesUIDs);
                    reportTemplateDataManager = projectAgent.getDataManager(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE);
                    map_projectUID_reportTemplateDataManager.put(projectUID, reportTemplateDataManager);
                }
                if (additionalTemplatesUIDs.contains(reportID) || reportTemplateDataManager.getCockpitProjectData(reportID) != null) continue;
                this.configuration.removeChild(configPerReport);
                continue;
            }
            this.configuration.removeChild(configPerReport);
        }
    }

    public void updateConfiguration() {
        this.fireUpdateConfiguration(this.configuration);
    }

    private void fireUpdateConfiguration(DocGenConfigurationItem configuration_) {
        for (IConfigurationListener listener : this.configurationListeners) {
            listener.updateConfiguration(configuration_);
        }
    }

    private void fireConfigurationChanged(DocGenConfigurationItem configuration_) {
        for (IConfigurationListener listener : this.configurationListeners) {
            listener.configurationChanged(configuration_);
        }
    }

    public void addConfigurationListener(IConfigurationListener configListener) {
        this.configurationListeners.add(configListener);
    }

    public void removeConfigurationListener(IConfigurationListener configListener) {
        this.configurationListeners.remove(configListener);
    }

    public EncodableObjectBase createEncodableObject(String xmlName, XMLContext context) throws EXDecoderException {
        if (xmlName.equals("configItem")) {
            return new DocGenConfigurationItem(context);
        }
        return null;
    }
}

