/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange.wizard;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.io.FileSystemDefaultPaths;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataInterchangeWizard
extends Wizard {
    private static final ILogger logger = Logger.getLogger(DataInterchangeWizard.class);
    private final boolean forExport;
    private final String name;
    private final IFrameProjectAgent projectAgent;
    private InterchangeWizardPage page;

    public DataInterchangeWizard(boolean forExport, String name, ISection section) {
        assert (section != null);
        this.forExport = forExport;
        this.name = name;
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
        this.addPages();
        if (forExport) {
            this.setWindowTitle(Messages.getString("DataInterchangeWizard.0"));
        } else {
            this.setWindowTitle(Messages.getString("DataInterchangeWizard.1"));
        }
    }

    public void addPages() {
        this.page = new InterchangeWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final File file = new File(this.page.getFileName());
        if (this.forExport) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DataInterchangeWizard.this.exportData(file, (IProgressDisplay)new JFaceProgressMonitorToProgressDisplayAdapter(monitor));
                }
            };
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
            pmd.setBlockOnOpen(true);
            pmd.setOpenOnRun(true);
            try {
                pmd.run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                logger.error("could not export data", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error("could not export data", (Throwable)e);
            }
        } else {
            this.importData(file);
        }
        return true;
    }

    private void exportData(File saveFile, IProgressDisplay pDisplay) {
        assert (saveFile != null);
        Throwable exception = null;
        try {
            this.projectAgent.saveAllEditors(this.getShell(), Messages.getString("DataInterchangeWizard.save_plans"), true, true, false);
            this.projectAgent.getFrameExportDataProvider().exportData(saveFile, pDisplay);
        }
        catch (IOException e) {
            exception = e;
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            Throwable throwable = exception = jeriE.getCause() != null ? jeriE.getCause() : jeriE;
        }
        if (exception != null) {
            MessageDialog mDialog = new MessageDialog(this.getShell(), "Error while saving file...", null, "Could not write to file " + saveFile.getAbsolutePath() + "\nReason: " + exception, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            logger.error("could not export data", exception);
        }
    }

    private void importData(File loadFile) {
        assert (loadFile != null);
        Throwable error = null;
        if (error != null) {
            MessageDialog mDialog = new MessageDialog(this.getShell(), Messages.getString("DataInterchangeWizard.5"), null, String.valueOf(Messages.getString("DataInterchangeWizard.6")) + error.getLocalizedMessage(), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
        }
    }

    class InterchangeWizardPage
    extends WizardPage {
        private Text txtFileName;

        public InterchangeWizardPage() {
            super(DataInterchangeWizard.this.name);
        }

        public void createControl(Composite parent) {
            if (DataInterchangeWizard.this.forExport) {
                this.setMessage(Messages.getString("DataInterchangeWizard.8"));
                this.setTitle(Messages.getString("DataInterchangeWizard.9"));
            } else {
                this.setMessage(Messages.getString("DataInterchangeWizard.10"));
                this.setTitle(Messages.getString("DataInterchangeWizard.11"));
            }
            Composite base = new Composite(parent, 0);
            base.setLayoutData((Object)new GridData(1808));
            base.setLayout((Layout)new GridLayout(1, false));
            Label label = new Label(base, 0);
            label.setLayoutData((Object)new GridData(768));
            if (DataInterchangeWizard.this.forExport) {
                label.setText(Messages.getString("DataInterchangeWizard.12"));
            } else {
                label.setText(Messages.getString("DataInterchangeWizard.13"));
            }
            Composite fileNameBase = new Composite(base, 0);
            fileNameBase.setLayoutData((Object)new GridData(768));
            fileNameBase.setLayout((Layout)new GridLayout(8, false));
            this.txtFileName = new Text(fileNameBase, 2052);
            GridData textData = new GridData(768);
            textData.horizontalSpan = 7;
            this.txtFileName.setLayoutData((Object)textData);
            this.txtFileName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InterchangeWizardPage.this.setPageComplete(InterchangeWizardPage.this.isPageComplete());
                }
            });
            Button chooseButton = new Button(fileNameBase, 0);
            GridData buttonData = new GridData();
            buttonData.horizontalSpan = 1;
            chooseButton.setLayoutData((Object)buttonData);
            chooseButton.setText("...");
            chooseButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    InterchangeWizardPage.this.chooseFile();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    InterchangeWizardPage.this.chooseFile();
                }
            });
            this.setControl((Control)base);
        }

        private void chooseFile() {
            String fileExtension = FramePlugin.getFileExtensionForProjectData();
            fileExtension = "*." + fileExtension;
            String[] fileExtensions = new String[]{fileExtension};
            FileChooserDialog dialog = new FileChooserDialog(fileExtensions, DataInterchangeWizard.this.forExport ? FileSystemDefaultPaths.getDefaultUserPathForSaving() : FileSystemDefaultPaths.getDefaultUserPathForLoading(), this.getControl().getShell());
            if (DataInterchangeWizard.this.forExport) {
                File file = dialog.openForSave();
                if (file != null) {
                    this.txtFileName.setText(file.getAbsolutePath());
                }
            } else {
                File file = dialog.openForLoad();
                if (file != null) {
                    this.txtFileName.setText(file.getAbsolutePath());
                }
            }
        }

        public boolean isPageComplete() {
            String fileName = this.txtFileName.getText();
            if (fileName != null) {
                return !fileName.trim().equals("");
            }
            return false;
        }

        String getFileName() {
            String fileName = this.txtFileName.getText();
            if (fileName == null) {
                fileName = "";
            }
            return fileName;
        }
    }
}

