/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.stakeholders;

import com.arcway.cockpit.frame.client.project.core.stakeholders.Stakeholder;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRole;
import com.arcway.cockpit.frame.shared.message.EORoleAndStakeholder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StakeholderCache {
    private Collection<Stakeholder> stakeholders = new ArrayList<Stakeholder>();
    private Collection<StakeholderRole> roles = new ArrayList<StakeholderRole>();
    private Collection<EORoleAndStakeholder> rolesAndStakeholders = new ArrayList<EORoleAndStakeholder>();

    protected void setupCache(Collection<Stakeholder> stakeholders, Collection<StakeholderRole> roles, Collection<EORoleAndStakeholder> rolesAndStakeholders) {
        if (stakeholders != null) {
            this.stakeholders = stakeholders;
        }
        if (roles != null) {
            this.roles = roles;
        }
        if (rolesAndStakeholders != null) {
            this.rolesAndStakeholders = rolesAndStakeholders;
        }
    }

    protected Collection<Stakeholder> getStakeholders() {
        return this.stakeholders;
    }

    protected Collection<StakeholderRole> getRoles() {
        return this.roles;
    }

    protected Collection<EORoleAndStakeholder> getRolesAndStakeholders() {
        return this.rolesAndStakeholders;
    }

    protected void addStakeholders(Collection<Stakeholder> createdStakeholders) {
        this.stakeholders.addAll(createdStakeholders);
    }

    protected void deleteStakeholders(Collection deletedStakeholders) {
        Iterator<Stakeholder> i = this.stakeholders.iterator();
        block0: while (i.hasNext()) {
            Stakeholder oldStakeholder = i.next();
            for (Stakeholder deleted : deletedStakeholders) {
                if (!oldStakeholder.getUID().equals(deleted.getUID())) continue;
                i.remove();
                continue block0;
            }
        }
    }

    protected void addRoles(Collection<StakeholderRole> createdRoles) {
        this.roles.addAll(createdRoles);
    }

    protected void deleteRoles(Collection deletedRoles) {
        for (StakeholderRole role : deletedRoles) {
            this.deleteRole(role);
        }
    }

    protected void deleteRole(StakeholderRole role) {
        Iterator<StakeholderRole> i = this.roles.iterator();
        while (i.hasNext()) {
            StakeholderRole r = i.next();
            if (!r.getUID().equals(role.getUID())) continue;
            i.remove();
            break;
        }
    }

    protected void addRolesAndStakeholders(List<EORoleAndStakeholder> rolesAndtStakeholders) {
        this.rolesAndStakeholders.addAll(rolesAndtStakeholders);
    }

    protected void deleteRolesAndStakeholders(List deletedRolesAndStakeholders) {
        Iterator<EORoleAndStakeholder> i = this.rolesAndStakeholders.iterator();
        block0: while (i.hasNext()) {
            EORoleAndStakeholder old = i.next();
            for (EORoleAndStakeholder deleted : deletedRolesAndStakeholders) {
                if (!old.getRoleUID().equals(deleted.getRoleUID()) || !old.getStakeholderUID().equals(deleted.getStakeholderUID())) continue;
                i.remove();
                continue block0;
            }
        }
    }

    protected boolean containsStakeholders() {
        return !this.stakeholders.isEmpty();
    }

    protected boolean containsRoles() {
        return !this.roles.isEmpty();
    }
}

