/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.stakeholders;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRW;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.message.EOStakeholder;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import java.util.Collection;

public class Stakeholder
extends AbstractFrameData
implements IStakeholderRW {
    private static final String ATTR_TAG_STAKEHOLDER_NAME = "stakeholdername";
    private static final String ATTR_TAG_USERNAME = "username";
    private static final String ATTR_TAG_EMAIL = "email";
    private static final String ATTR_TAG_DESCRIPTION = "description";
    private static final String ATTR_TAG_COMPANY = "company";
    private static final String ATTR_TAG_TELEPHONE = "telephone";
    private static final String ATTR_TAG_FAX = "fax";
    private static final String ATTR_TAG_ADDRESS = "address";

    public Stakeholder(String uID, String name, Collection<IAttribute> attributes, IAttributeModificationManager modManager, IFrameProjectAgent projectAgent) {
        super(uID, projectAgent.getProjectUID(), "com.arcway.cockpit.stakeholder", attributes, modManager, projectAgent);
        Attribute nameAttr = new Attribute(StakeholderAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
        this.simplySetAttribute(nameAttr);
    }

    public Stakeholder(EOStakeholder eoStakeholder, IAttributeModificationManager modManager, IFrameProjectAgent projectAgent) {
        super((EOFrameData)eoStakeholder, "com.arcway.cockpit.stakeholder", modManager, projectAgent);
        String username;
        String name = eoStakeholder.getOldAttributeValue(ATTR_TAG_STAKEHOLDER_NAME);
        if (name != null) {
            Attribute attribute = new Attribute(StakeholderAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
            this.simplySetAttribute(attribute);
        }
        if ((username = eoStakeholder.getOldAttributeValue(ATTR_TAG_USERNAME)) != null) {
            Attribute attribute = new Attribute(StakeholderAttributeTypesProvider.ATTRID_USERNAME, DataTypeString.getInstanceString().getAttributeValueFromString(username, null, null));
            this.simplySetAttribute(attribute);
        }
        String email = eoStakeholder.getOldAttributeValue(ATTR_TAG_EMAIL);
        if (username != null) {
            Attribute attribute = new Attribute(StakeholderAttributeTypesProvider.ATTRID_EMAIL, DataTypeString.getInstanceString().getAttributeValueFromString(email, null, null));
            this.simplySetAttribute(attribute);
        }
        String description = eoStakeholder.getOldAttributeValue(ATTR_TAG_DESCRIPTION);
        if (username != null) {
            Attribute attribute = new Attribute(StakeholderAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null));
            this.simplySetAttribute(attribute);
        }
        String company = eoStakeholder.getOldAttributeValue(ATTR_TAG_COMPANY);
        if (username != null) {
            Attribute attribute = new Attribute(StakeholderAttributeTypesProvider.ATTRID_COMPANY, DataTypeString.getInstanceString().getAttributeValueFromString(company, null, null));
            this.simplySetAttribute(attribute);
        }
        String phone = eoStakeholder.getOldAttributeValue(ATTR_TAG_TELEPHONE);
        if (username != null) {
            Attribute attribute = new Attribute(StakeholderAttributeTypesProvider.ATTRID_PHONE, DataTypeString.getInstanceString().getAttributeValueFromString(phone, null, null));
            this.simplySetAttribute(attribute);
        }
        String fax = eoStakeholder.getOldAttributeValue(ATTR_TAG_FAX);
        if (username != null) {
            Attribute attribute = new Attribute(StakeholderAttributeTypesProvider.ATTRID_FAX, DataTypeString.getInstanceString().getAttributeValueFromString(fax, null, null));
            this.simplySetAttribute(attribute);
        }
        String address = eoStakeholder.getOldAttributeValue(ATTR_TAG_ADDRESS);
        if (username != null) {
            Attribute attribute = new Attribute(StakeholderAttributeTypesProvider.ATTRID_ADDRESS, DataTypeText.getInstanceText().getAttributeValueFromString(address, null, null));
            this.simplySetAttribute(attribute);
        }
    }

    public String getStakeholderName() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderAttributeTypesProvider.ATTRID_NAME);
        return (String)attribute.getAttributeValue();
    }

    public String getStakeholderDescription() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderAttributeTypesProvider.ATTRID_DESCRIPTION);
        return DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
    }

    public String getStakeholderAddress() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderAttributeTypesProvider.ATTRID_ADDRESS);
        return DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
    }

    public String getStakeholderCompany() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderAttributeTypesProvider.ATTRID_COMPANY);
        return (String)attribute.getAttributeValue();
    }

    public String getStakeholderEMail() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderAttributeTypesProvider.ATTRID_EMAIL);
        return (String)attribute.getAttributeValue();
    }

    public String getStakeholderFax() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderAttributeTypesProvider.ATTRID_FAX);
        return (String)attribute.getAttributeValue();
    }

    public String getStakeholderTelephone() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderAttributeTypesProvider.ATTRID_PHONE);
        return (String)attribute.getAttributeValue();
    }

    public String getUsername() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderAttributeTypesProvider.ATTRID_USERNAME);
        return (String)attribute.getAttributeValue();
    }

    @Override
    public EOFrameData createEncodableObject() {
        EOStakeholder eo = new EOStakeholder(super.createEncodableObject());
        return eo;
    }
}

