/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.sectionsandplans;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.AddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.DeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ModifiedItem;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.PlanAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.Plan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.Section;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeModificationManager;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOPlan;
import com.arcway.cockpit.frame.shared.message.EOSection;
import com.arcway.cockpit.frame.shared.message.EOSectionAndPlanModifications;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SectionModificationManager {
    private final Map<String, Section> addedSections = new HashMap<String, Section>();
    private final Map<String, Section> modifiedSections = new HashMap<String, Section>();
    private final Map<String, Section> deletedSections = new HashMap<String, Section>();
    private final Map<String, Plan> addedPlans = new HashMap<String, Plan>();
    private final Map<String, Plan> modifiedPlans = new HashMap<String, Plan>();
    private final Map<String, Plan> deletedPlans = new HashMap<String, Plan>();
    private final IFrameProjectAgent projectAgent;

    protected SectionModificationManager(EOSectionAndPlanModifications modifications, SectionManager sectionManager) {
        Section section;
        Plan plan;
        this.projectAgent = sectionManager.getProjectAgent();
        this.addedPlans.clear();
        for (EOPlan eoPlan : modifications.getPlanModifications().getCreatedData()) {
            plan = this.createPlan((EOFrameData)eoPlan);
            this.addedPlans.put(plan.getUID(), plan);
        }
        this.modifiedPlans.clear();
        for (EOPlan eoPlan : modifications.getPlanModifications().getModifiedData()) {
            plan = this.createPlan((EOFrameData)eoPlan);
            this.modifiedPlans.put(plan.getUID(), plan);
        }
        this.deletedPlans.clear();
        for (EOPlan eoPlan : modifications.getPlanModifications().getDeletedData()) {
            plan = this.createPlan((EOFrameData)eoPlan);
            this.deletedPlans.put(plan.getUID(), plan);
        }
        this.addedSections.clear();
        for (EOSection eoSection : modifications.getAddedSections()) {
            section = this.createSection(eoSection);
            this.addedSections.put(section.getUID(), section);
        }
        this.modifiedSections.clear();
        for (EOSection eoSection : modifications.getModifiedSections()) {
            section = this.createSection(eoSection);
            this.modifiedSections.put(section.getUID(), section);
        }
        this.deletedSections.clear();
        for (EOSection eoSection : modifications.getDeletedSections()) {
            section = this.createSection(eoSection);
            this.deletedSections.put(section.getUID(), section);
        }
    }

    private Plan createPlan(EOFrameData eo) {
        PlanAttributeModificationManager modManager = new PlanAttributeModificationManager(this.projectAgent);
        Plan plan = new Plan(eo, modManager, this.projectAgent);
        modManager.setPlan(plan);
        return plan;
    }

    private Section createSection(EOSection eo) {
        SectionAttributeModificationManager modManager = new SectionAttributeModificationManager(this.projectAgent);
        Section section = new Section(eo, this.projectAgent, (IAttributeModificationManager)modManager);
        modManager.setSection(section);
        return section;
    }

    protected void addAddedSection(Section section) {
        this.addedSections.put(section.getUID(), section);
    }

    protected boolean isAddedSection(String sectionUID) {
        return this.addedSections.containsKey(sectionUID);
    }

    protected Section getAddedSection(String sectionUID) {
        return this.addedSections.get(sectionUID);
    }

    protected Collection<Section> getAddedSections() {
        return this.addedSections.values();
    }

    protected void removeAddedSection(Section section) {
        this.addedSections.remove(section.getUID());
    }

    protected void addModifiedSection(Section section) {
        assert (!this.isModifiedSection(section.getUID()));
        this.modifiedSections.put(section.getUID(), section);
    }

    protected boolean isModifiedSection(String sectionUID) {
        return this.modifiedSections.containsKey(sectionUID);
    }

    protected Section getModifiedSection(String sectionUID) {
        return this.modifiedSections.get(sectionUID);
    }

    protected Collection<Section> getModifiedSections() {
        return this.modifiedSections.values();
    }

    protected void removeModifiedSection(Section section) {
        this.modifiedSections.remove(section.getUID());
    }

    protected boolean isDeletedSection(String sectionUID) {
        return this.deletedSections.containsKey(sectionUID);
    }

    protected Section getDeletedSection(String sectionUID) {
        return this.deletedSections.get(sectionUID);
    }

    protected Collection<Section> getDeletedSections() {
        return this.deletedSections.values();
    }

    protected void addDeletedSection(Section section) {
        this.deletedSections.put(section.getUID(), section);
    }

    protected void removeDeletedSection(Section section) {
        this.deletedSections.remove(section.getUID());
    }

    protected boolean isAddedPlan(String planUID) {
        return this.addedPlans.containsKey(planUID);
    }

    protected void addAddedPlan(Plan plan) {
        this.addedPlans.put(plan.getUID(), plan);
    }

    protected Plan getAddedPlan(String planUID) {
        return this.addedPlans.get(planUID);
    }

    protected void removeAddedPlan(Plan plan) {
        this.addedPlans.remove(plan.getUID());
    }

    protected Collection<Plan> getAddedPlans() {
        return this.addedPlans.values();
    }

    protected IAddedItem[] getAddedItems(String cockpitDataTypeID) {
        ArrayList<AbstractFrameData> added = new ArrayList<AbstractFrameData>();
        if (cockpitDataTypeID.equals("com.arcway.cockpit.plan")) {
            added.addAll(this.getAddedPlans());
        } else {
            added.addAll(this.getAddedSections());
        }
        if (!added.isEmpty()) {
            IAddedItem[] addedItems = new IAddedItem[added.size()];
            int nr = 0;
            for (ICockpitProjectData iCockpitProjectData : added) {
                AddedItem item = new AddedItem((Object)iCockpitProjectData);
                addedItems[nr++] = item;
            }
            return addedItems;
        }
        return null;
    }

    protected IModifiedItem[] getModifiedItems(String cockpitDataTypeID) {
        ArrayList<AbstractFrameData> modifiedItems = new ArrayList<AbstractFrameData>();
        if (cockpitDataTypeID.equals("com.arcway.cockpit.plan")) {
            modifiedItems.addAll(this.getModifiedPlans());
        } else {
            modifiedItems.addAll(this.getModifiedSections());
        }
        if (!modifiedItems.isEmpty()) {
            IModifiedItem[] items = new IModifiedItem[modifiedItems.size()];
            int nr = 0;
            for (ICockpitProjectData iCockpitProjectData : modifiedItems) {
                ModifiedItem item = new ModifiedItem((Object)iCockpitProjectData);
                items[nr++] = item;
            }
            return items;
        }
        return null;
    }

    protected IDeletedItem[] getDeletedItems(String cockpitDataTypeID) {
        ArrayList<AbstractFrameData> deletedItems = new ArrayList<AbstractFrameData>();
        if (cockpitDataTypeID.equals("com.arcway.cockpit.plan")) {
            deletedItems.addAll(this.getDeletedPlans());
        } else {
            deletedItems.addAll(this.getDeletedSections());
        }
        if (!deletedItems.isEmpty()) {
            IDeletedItem[] items = new IDeletedItem[deletedItems.size()];
            int nr = 0;
            for (ICockpitProjectData iCockpitProjectData : deletedItems) {
                DeletedItem item = new DeletedItem((Object)iCockpitProjectData);
                items[nr++] = item;
            }
            return items;
        }
        return null;
    }

    protected boolean isModifiedPlan(String planUID) {
        return this.modifiedPlans.containsKey(planUID);
    }

    protected void addModifiedPlan(Plan plan) {
        this.modifiedPlans.put(plan.getUID(), plan);
    }

    protected Plan getModifiedPlan(String planUID) {
        return this.modifiedPlans.get(planUID);
    }

    protected void removeModifiedPlan(Plan plan) {
        this.modifiedPlans.remove(plan.getUID());
    }

    protected Collection<Plan> getModifiedPlans() {
        return this.modifiedPlans.values();
    }

    protected void addDeletedPlan(Plan plan) {
        this.deletedPlans.put(plan.getUID(), plan);
    }

    protected Collection<Plan> getDeletedPlans() {
        return this.deletedPlans.values();
    }

    protected void removeDeletedPlan(Plan plan) {
        this.deletedPlans.remove(plan.getUID());
    }

    protected boolean isDeletedPlan(String planUID) {
        return this.deletedPlans.containsKey(planUID);
    }

    protected boolean isEmpty() {
        return this.addedPlans.isEmpty() && this.modifiedPlans.isEmpty() && this.deletedPlans.isEmpty() && this.addedSections.isEmpty() && this.modifiedSections.isEmpty() && this.deletedSections.isEmpty();
    }

    protected void clear() {
        this.addedPlans.clear();
        this.modifiedPlans.clear();
        this.deletedPlans.clear();
        this.addedSections.clear();
        this.modifiedSections.clear();
        this.deletedSections.clear();
    }

    protected EOSectionAndPlanModifications getModifications() {
        EOSectionAndPlanModifications mods = new EOSectionAndPlanModifications();
        EOList addedEOSections = new EOList(this.addedSections.size() * 2);
        for (Section section : this.addedSections.values()) {
            addedEOSections.add((EncodableObjectBase)section.createEncodableObject());
        }
        mods.setAddedSections(addedEOSections);
        EOList modifiedEOSections = new EOList(this.modifiedSections.size() * 2);
        for (Section section : this.modifiedSections.values()) {
            modifiedEOSections.add((EncodableObjectBase)section.createEncodableObject());
        }
        mods.setModifiedSections(modifiedEOSections);
        EOList deletedEOSections = new EOList(this.deletedSections.size() * 2);
        for (Section section : this.deletedSections.values()) {
            deletedEOSections.add((EncodableObjectBase)section.createEncodableObject());
        }
        mods.setDeletedSections(deletedEOSections);
        EOList addedEOPlans = new EOList(this.addedPlans.size() * 2);
        for (Plan plan : this.addedPlans.values()) {
            addedEOPlans.add((EncodableObjectBase)plan.createEncodableObject());
        }
        EOList modifiedEoPlans = new EOList(this.modifiedPlans.size() * 2);
        for (Plan plan : this.modifiedPlans.values()) {
            modifiedEoPlans.add((EncodableObjectBase)plan.createEncodableObject());
        }
        EOList deletedEOPlans = new EOList(this.deletedPlans.size() * 2);
        for (Plan plan : this.deletedPlans.values()) {
            deletedEOPlans.add((EncodableObjectBase)plan.createEncodableObject());
        }
        mods.setPlanModifications(new EOFrameDataModification("com.arcway.cockpit.plan", addedEOPlans, modifiedEoPlans, deletedEOPlans));
        return mods;
    }

    protected boolean hasModificationsForSections() {
        return !this.addedSections.isEmpty() || !this.modifiedSections.isEmpty() || !this.deletedSections.isEmpty();
    }

    protected boolean hasModificationsForPlans() {
        return !this.addedPlans.isEmpty() || !this.modifiedPlans.isEmpty() || !this.deletedPlans.isEmpty();
    }
}

