/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.sectionsandplans;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.frame.client.global.gui.validators.RenamePlanValidator;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameSectionValidator;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameLockManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.ISectionAddID;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IDataAddID;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.FrameDataTransactionListener;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.history.HistoryDataManager;
import com.arcway.cockpit.frame.client.project.core.history.IHistoricDataItemConverter;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.locking.LockRequest;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.ExportDataProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.PlanAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionModificationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionServerCache;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanAddID;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.Plan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISectionRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.Section;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.UserDefinedAtributeDataManagementFacade;
import com.arcway.cockpit.frame.client.project.datainterchange.ISectionExportDataProvider;
import com.arcway.cockpit.frame.client.project.modules.IModuleSectionManager;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentSectionManager;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.EOPlan;
import com.arcway.cockpit.frame.shared.message.EOSection;
import com.arcway.cockpit.frame.shared.message.EOSectionAndPlanModifications;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class SectionManager
implements IFrameSectionManager,
IPlanAgentSectionManager,
IModuleSectionManager,
IProjectCloseListener {
    private static final ILogger logger = Logger.getLogger(SectionManager.class);
    private static final String SECTION_LOST_AND_FOUND = "lostAndFound";
    private IFrameProjectAgent projectAgent;
    private ISectionExportDataProvider exportDataProvider;
    private IXMLDataAccessor<EOSectionAndPlanModifications> modificationFileAccessor;
    private SectionModificationManager modificationManager;
    private SectionServerCache sectionCache;
    private Section rootSection;
    private Section lostAndFound;
    private Map<String, Section> lostSections;
    private Map<String, Plan> lostPlans;
    private final Map<IDataAddID, ICockpitProjectData> addPermissionIDs = new HashMap<IDataAddID, ICockpitProjectData>();
    private final Map<ILocksAndPermissionsTransactionController, Collection<FrameDataTransactionListener>> approvedPlanDeletions = new HashMap<ILocksAndPermissionsTransactionController, Collection<FrameDataTransactionListener>>();
    private final Map<ILocksAndPermissionsTransactionController, Collection<FrameDataTransactionListener>> approvedSectionDeletions = new HashMap<ILocksAndPermissionsTransactionController, Collection<FrameDataTransactionListener>>();
    private IDataLabelProvider dataLabelProvider;
    private Map<ILocksAndPermissionsTransactionController, Collection<FrameDataTransactionListener>> grantedMoveRequests;
    private HistoryDataManager<IPlan> historyDataManager;
    private final HierarchyCache hierarchyCache = new HierarchyCache();
    private ILOLinkAccessFacade sectionLinkFacade;
    private ILOLinkAccessFacade planLinkFacade;

    public void construct(IFrameProjectAgent newProjectAgent) {
        this.projectAgent = newProjectAgent;
        this.exportDataProvider = new ExportDataProvider(this);
        this.grantedMoveRequests = new HashMap<ILocksAndPermissionsTransactionController, Collection<FrameDataTransactionListener>>();
        this.modificationFileAccessor = this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.FILEKEY_SECTIONS_AND_PLANS, (IEncodableObjectFactory)MessageDataFactory.getInstance());
        this.historyDataManager = new HistoryDataManager<IPlan>(this.projectAgent, new IHistoricDataItemConverter<IPlan>(){

            @Override
            public IPlan convertFromEO(EOCockpitProjectData historicItemEO) {
                return new Plan((EOFrameData)historicItemEO, new PlanAttributeModificationManager(SectionManager.this.projectAgent), SectionManager.this.projectAgent);
            }
        }, null, "frame.Plan", Collections.singleton("com.arcway.cockpit.plan"));
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            EOSection[] sections = serverDataContainer.getSections();
            EOPlan[] plans = serverDataContainer.getPlans();
            this.sectionCache = new SectionServerCache(this);
            this.sectionCache.setupCache(sections, (EOFrameData[])plans);
            EOSectionAndPlanModifications mods = this.readSectionAndPlanModifications();
            if (mods == null) {
                mods = new EOSectionAndPlanModifications();
            }
            this.modificationManager = new SectionModificationManager(mods, this);
            if (this.getRootSection() == null) {
                SectionAttributeModificationManager modManager = new SectionAttributeModificationManager(this.projectAgent);
                Attribute description = new Attribute(SectionAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(String.valueOf(Messages.getString("ProjectAgent.Root_for_Project___1")) + this.projectAgent.getProjectName(), null, null));
                ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
                attributes.add(description);
                Section newRootSection = new Section(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectName(), "rootSection", attributes, this.projectAgent, (IAttributeModificationManager)modManager);
                modManager.setSection(newRootSection);
                this.modificationManager.addAddedSection(newRootSection);
            }
            this.checkLostAndFound();
            administrator.getFrameProjectAgent().addProjectCloseListener(this);
            this.sectionLinkFacade = this.getProjectAgent().getLinkManager().getLOLinkAccessFacade("com.arcway.cockpit.section");
            this.planLinkFacade = this.getProjectAgent().getLinkManager().getLOLinkAccessFacade("com.arcway.cockpit.plan");
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public void closeProject(IFrameProjectAgent pa) {
        this.planLinkFacade = null;
        this.sectionLinkFacade = null;
    }

    @Override
    public ILOLinkAccessFacade getSectionLinkFacade() {
        return this.sectionLinkFacade;
    }

    @Override
    public ILOLinkAccessFacade getPlanLinkFacade() {
        return this.planLinkFacade;
    }

    private void checkLostAndFound() {
        for (Section section : this.getSections()) {
            ISection parent;
            if (section.isRootSection() || (parent = this.getParentSection(section)) != null) continue;
            logger.warn("parent of section " + section.getSectionName() + " not found.");
            if (this.lostSections == null) {
                this.lostSections = new HashMap<String, Section>();
            }
            this.lostSections.put(section.getUID(), section);
        }
        for (Plan plan : this.getPlans()) {
            ISection parentSection = this.getParentSection(plan);
            if (parentSection != null) continue;
            logger.warn("parent of plan " + plan.getPlanName() + " not found.");
            if (this.lostPlans == null) {
                this.lostPlans = new HashMap<String, Plan>();
            }
            this.lostPlans.put(plan.getUID(), plan);
        }
    }

    private Section getLostAndFoundSection() {
        if (this.lostAndFound == null) {
            this.getRootSection();
            final ModificationProblem modProblem = new ModificationProblem(Messages.getString("SectionManager.folder_not_changeable"), Messages.getString("SectionManager.folder_may_not_be_changed"));
            IAttributeModificationManager modManager = new IAttributeModificationManager(){

                @Override
                public IModificationProblem checkLocks() {
                    return modProblem;
                }

                @Override
                public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
                    ArrayList<IModificationProblem> modProblems = new ArrayList<IModificationProblem>();
                    modProblems.add(modProblem);
                    return modProblems;
                }

                @Override
                public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
                }

                @Override
                public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
                    transactionController.addLockModificationProblem(modProblem);
                }

                @Override
                public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void modifyCategoryID() throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
                }
            };
            this.lostAndFound = new Section(SECTION_LOST_AND_FOUND, Messages.getString("SectionManager.lost_and_found"), this.rootSection.getUID(), (Collection<IAttribute>)Collections.EMPTY_LIST, this.projectAgent, modManager);
        }
        return this.lostAndFound;
    }

    @Override
    public ISection getSection(String sectionUID) {
        return this.getSectionInternal(sectionUID);
    }

    @Override
    public ISectionRW getSectionRW(String sectionUID) {
        return this.getSectionInternal(sectionUID);
    }

    private Section getSectionInternal(String sectionUID) {
        Section section;
        if (sectionUID.equals(SECTION_LOST_AND_FOUND)) {
            section = this.lostAndFound;
        } else {
            section = this.modificationManager.getAddedSection(sectionUID);
            if (section == null) {
                section = this.modificationManager.getModifiedSection(sectionUID);
            }
            if (section == null && !this.modificationManager.isDeletedSection(sectionUID)) {
                section = this.sectionCache.getSection(sectionUID);
            }
        }
        return section;
    }

    private Object getDataToAdd(IDataAddID dataAddID) {
        ICockpitProjectData dataToAdd = this.addPermissionIDs.get(dataAddID);
        if (dataToAdd != null) {
            this.addPermissionIDs.remove(dataAddID);
        }
        return dataToAdd;
    }

    @Override
    public boolean containsChildSection(ISection parentSection, String sectionName) {
        return this.getChildSection(parentSection, sectionName) != null;
    }

    @Override
    public ISection getChildSection(ISection parentSection, String sectionName) {
        for (ISection iSection : this.getChildSections(parentSection)) {
            if (!iSection.getSectionName().equalsIgnoreCase(sectionName)) continue;
            return iSection;
        }
        return null;
    }

    @Override
    public IPlan getChildPlan(ISection parentSection, String planName) {
        for (IPlan iPlan : this.getChildPlans(parentSection)) {
            if (!iPlan.getPlanName().equalsIgnoreCase(planName)) continue;
            return iPlan;
        }
        return null;
    }

    @Override
    public ISection getParentSection(IPlan plan) {
        if (this.lostPlans != null && this.lostPlans.containsKey(plan.getUID())) {
            return this.lostAndFound;
        }
        return this.getSectionInternal(plan.getSectionUID());
    }

    @Override
    public ISection getParentSection(ISection section) {
        if (this.lostSections != null && this.lostSections.containsKey(section.getUID())) {
            return this.lostAndFound;
        }
        return this.getSectionInternal(section.getParentUID());
    }

    @Override
    public IParentOperandTree getOperandTree(final ISection baseSection) {
        return new IParentOperandTree(){

            @Override
            public IPermissionOperand getBaseOperand() {
                return baseSection;
            }

            @Override
            public IPermissionOperand getParent(IPermissionOperand childOperand) {
                return SectionManager.this.getParentSection((ISection)childOperand);
            }
        };
    }

    @Override
    public ISection getRootSection() {
        if (this.rootSection == null) {
            for (Section section : this.getSections()) {
                if (!section.isRootSection()) continue;
                this.rootSection = section;
                break;
            }
        }
        return this.rootSection;
    }

    public Collection<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>(this.modificationManager.getAddedSections());
        sections.addAll(this.modificationManager.getModifiedSections());
        for (Section section : this.sectionCache.getSections()) {
            if (this.modificationManager.isDeletedSection(section.getUID()) || this.modificationManager.isModifiedSection(section.getUID()) || this.modificationManager.isAddedSection(section.getUID())) continue;
            sections.add(section);
        }
        if (this.lostPlans != null || this.lostSections != null) {
            sections.add(this.getLostAndFoundSection());
        }
        return sections;
    }

    public Collection<Plan> getPlans() {
        ArrayList<Plan> plans = new ArrayList<Plan>(this.modificationManager.getAddedPlans().size() + this.sectionCache.getPlans().size());
        plans.addAll(this.modificationManager.getAddedPlans());
        SectionManager.addPlansToCollection(this.modificationManager.getModifiedPlans(), plans);
        for (Plan plan : this.sectionCache.getPlans()) {
            String planUID = plan.getUID();
            if (this.modificationManager.isModifiedPlan(planUID) || this.modificationManager.isDeletedPlan(planUID) || this.modificationManager.isAddedPlan(planUID)) continue;
            plans.add(plan);
        }
        return plans;
    }

    public Collection<IPlan> getPlans(String type) {
        ArrayList<IPlan> plansOfType = new ArrayList<IPlan>();
        for (IPlan iPlan : this.getPlans()) {
            if (!iPlan.getPlantypeUID().equals(type)) continue;
            plansOfType.add(iPlan);
        }
        return plansOfType;
    }

    public Collection<Plan> getPlanRWs() {
        return this.getPlans();
    }

    private static void addPlansToCollection(Collection<Plan> plans, Collection<Plan> collection) {
        for (Plan plan : plans) {
            SectionManager.addPlanToCollection(plan, collection);
        }
    }

    private static void addPlanToCollection(Plan plan, Collection<Plan> collection) {
        for (Plan containedPlan : collection) {
            if (!containedPlan.getUID().equals(plan.getUID())) continue;
            return;
        }
        collection.add(plan);
    }

    @Override
    public Collection<? extends IPlan> getAllPlansUnderSection(ISection section) {
        ArrayList<? extends IPlan> plans = new ArrayList<IPlan>();
        plans.addAll(this.getChildPlans(section));
        for (ISection iSection : this.getChildSections(section)) {
            plans.addAll(this.getAllPlansUnderSection(iSection));
        }
        return plans;
    }

    @Override
    public boolean containsPlan(ISection section, String planName) {
        for (IPlan iPlan : this.getChildPlans(section)) {
            if (!iPlan.getPlanName().equals(planName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Section> getChildSections(ISection section) {
        assert (section != null);
        String sectionUID = section.getUID();
        Collection<Section> children = this.hierarchyCache.getChildSectionsInfo().get(sectionUID);
        if (children == null) {
            children = new ArrayList<Section>();
            this.getChildSections_internal(section, children);
            children = Collections.unmodifiableCollection(children);
            this.hierarchyCache.getChildSectionsInfo().put(sectionUID, children);
        }
        return children;
    }

    private void getChildSections_internal(ISection section, Collection<? super Section> children) {
        assert (section != null);
        if (section == this.lostAndFound) {
            if (this.lostSections != null) {
                children.addAll(this.lostSections.values());
            }
        } else {
            for (Section s : this.getSections()) {
                if (s.isRootSection() || !s.getParentUID().equals(section.getUID())) continue;
                children.add(s);
            }
        }
    }

    @Override
    public Collection<Plan> getChildPlans(ISection section) {
        assert (section != null);
        String sectionUID = section.getUID();
        Collection<Plan> children = this.hierarchyCache.getChildPlansInfo().get(sectionUID);
        if (children == null) {
            children = new ArrayList<Plan>();
            this.getChildPlans_internal(section, children);
            children = Collections.unmodifiableCollection(children);
            this.hierarchyCache.getChildPlansInfo().put(sectionUID, children);
        }
        return children;
    }

    private void getChildPlans_internal(ISection section, Collection<? super Plan> children) {
        if (section == this.lostAndFound) {
            if (this.lostPlans != null) {
                children.addAll(this.lostPlans.values());
            }
        } else {
            for (Plan plan : this.getPlans()) {
                if (!plan.getSectionUID().equals(section.getUID())) continue;
                children.add(plan);
            }
        }
    }

    public Collection<IPlan> getChildPlans(ISection section, String type) {
        ArrayList<IPlan> childPlansOfType = new ArrayList<IPlan>();
        for (IPlan iPlan : this.getChildPlans(section)) {
            if (!iPlan.getPlantypeUID().equals(type)) continue;
            childPlansOfType.add(iPlan);
        }
        return childPlansOfType;
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    @Override
    public void sectionMoved(ISection section, ISection p_oldParentSection) throws EXNoPermission, EXNoLock {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            ISection oldParentSection = p_oldParentSection == null ? this.lostAndFound : p_oldParentSection;
            ISection newParentSection = this.getSection(section.getParentUID());
            if (!this.projectAgent.getFramePermissionChecker().hasPermission("modifyFolders", null, this.getOperandTree(oldParentSection))) {
                throw new EXNoPermission((IPermissionOperand)oldParentSection, "modifyFolders");
            }
            if (!this.projectAgent.getFramePermissionChecker().hasPermission("modifyFolders", null, this.getOperandTree(newParentSection))) {
                throw new EXNoPermission((IPermissionOperand)newParentSection, "modifyFolders");
            }
            if (this.containsChildSectionWithSameName(newParentSection, section)) {
                throw new EXNoPermission((IPermissionOperand)newParentSection, "add section with same name");
            }
            if (this.isAncestor(newParentSection, section) || section.getUID().equals(newParentSection.getUID())) {
                throw new EXNoPermission(Messages.getString("SectionManager.cannot_move_under_ancestor"));
            }
            if (!this.modificationManager.isAddedSection(section.getUID())) {
                if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(section, "move")) {
                    throw new EXNoLock(section, "move");
                }
                if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(section, "modify")) {
                    throw new EXNoLock(section, "modify");
                }
            }
            if (!this.modificationManager.isAddedSection(newParentSection.getUID())) {
                String lockType = "uniqueName_com.arcway.cockpit.section_" + section.getSectionName().toLowerCase();
                if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(newParentSection, lockType)) {
                    throw new EXNoLock(newParentSection, lockType);
                }
                if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(newParentSection, "add")) {
                    throw new EXNoLock(newParentSection, "add");
                }
                if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(newParentSection, "move")) {
                    throw new EXNoLock(newParentSection, "move");
                }
            }
            if (this.lostSections != null && this.lostSections.containsKey(section.getUID())) {
                this.lostSections.remove(section.getUID());
            }
            this.sectionUpdated(section);
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    private boolean containsChildSectionWithSameName(ISection parentSection, ISection section) {
        for (ISection iSection : this.getChildSections(parentSection)) {
            if (!iSection.getSectionName().equals(section.getSectionName()) || iSection.getUID().equals(section.getUID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAncestor(ISection section, ISection ancestor) {
        ISection parentSection = this.getParentSection(section);
        if (parentSection == null) {
            return false;
        }
        if (parentSection.getUID().equals(ancestor.getUID())) {
            return true;
        }
        return this.isAncestor(parentSection, ancestor);
    }

    @Override
    public void sectionNameUpdated(ISection section, String newName) throws EXNoLock, EXNoPermission {
        if (!section.isRootSection()) {
            ISection parentSection = this.getParentSection(section);
            RenameSectionValidator nameValidator = new RenameSectionValidator(this.projectAgent, parentSection, section);
            String exceptionMessage = nameValidator.isValid(newName);
            if (exceptionMessage != null) {
                throw new EXNoPermission(exceptionMessage);
            }
            if (parentSection != null && !this.modificationManager.isAddedSection(parentSection.getUID())) {
                String lockType = "uniqueName_com.arcway.cockpit.section_" + newName.toLowerCase();
                if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(parentSection, lockType)) {
                    throw new EXNoLock(parentSection, lockType);
                }
            }
            this.sectionUpdated(section);
        }
    }

    @Override
    public void sectionUpdated(ISection section) throws EXNoLock, EXNoPermission {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            if (!this.modificationManager.isAddedSection(section.getUID()) && !this.projectAgent.getFrameLockManager().clientAlreadyHasLock(section, "modify")) {
                throw new EXNoLock(section, "modify");
            }
            this.dataModified((IAttributeOwner)section);
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public ISection addSection(ISectionAddID addID) throws EXNoPermission {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            Section section = (Section)this.getDataToAdd(addID);
            if (section == null) {
                throw new EXNoPermission("permission for adding this section was not granted or not requested");
            }
            UserDefinedAtributeDataManagementFacade.attributeOwnerCreated(section);
            SectionAttributeModificationManager modManager = new SectionAttributeModificationManager(this.projectAgent);
            modManager.setSection(section);
            section.setAttributeModificationManager(modManager);
            this.modificationManager.addAddedSection(section);
            PropertyChanges changes = new PropertyChanges((Object)section, null, null);
            this.save((IPropertyChanges)changes, (Class)ISection.class);
            Section section2 = section;
            return section2;
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public void addRootSection(ISection IRootSection) {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            Section root_Section = (Section)IRootSection;
            SectionAttributeModificationManager modManager = new SectionAttributeModificationManager(this.projectAgent);
            modManager.setSection(root_Section);
            root_Section.setAttributeModificationManager(modManager);
            this.modificationManager.addAddedSection(root_Section);
            PropertyChanges changes = new PropertyChanges((Object)root_Section, null, null);
            this.save((IPropertyChanges)changes, (Class)ISection.class);
            this.rootSection = root_Section;
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public String getIDForNewPlan() {
        return UUIDGenerator.getUniqueID();
    }

    @Override
    public IPlan addPlan(IPlanAddID addID, String planTypeUID) throws EXNoPermission {
        Plan plan = (Plan)this.addPermissionIDs.get(addID);
        if (plan == null) {
            throw new EXNoPermission("permission for adding this plan not requested or not granted");
        }
        plan.setPlanTypeUID(planTypeUID);
        return this.addPlan(addID);
    }

    @Override
    public IPlan addPlan(IPlanAddID addID) throws EXNoPermission {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            Plan newPlan = (Plan)this.getDataToAdd(addID);
            if (newPlan == null) {
                throw new EXNoPermission("permission for adding this plan not requested or not granted");
            }
            UserDefinedAtributeDataManagementFacade.attributeOwnerCreated(newPlan);
            PlanAttributeModificationManager modManager = new PlanAttributeModificationManager(this.projectAgent);
            modManager.setPlan(newPlan);
            newPlan.setAttributeModificationManager(modManager);
            this.modificationManager.addAddedPlan(newPlan);
            PropertyChanges changes = new PropertyChanges((Object)newPlan, null, null);
            this.save((IPropertyChanges)changes, (Class)IPlan.class);
            Plan plan = newPlan;
            return plan;
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public void deletePlan(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        Collection<FrameDataTransactionListener> listeners = this.approvedPlanDeletions.get(transactionController);
        if (listeners == null) {
            throw new EXNoPermission("Permission was not granted!");
        }
        listeners = new ArrayList<FrameDataTransactionListener>(listeners);
        ArrayList<Plan> deletedPlans = new ArrayList<Plan>();
        for (FrameDataTransactionListener listener : listeners) {
            IFrameDataRW data = listener.getData();
            if (!(data instanceof Plan)) continue;
            Plan plan = (Plan)data;
            this.deletePlan(plan);
            deletedPlans.add(plan);
            listener.kill();
            this.projectAgent.getLinkManager().objectDeleted((ICockpitProjectData)plan);
        }
        PropertyChanges changes = new PropertyChanges(null, null, deletedPlans);
        this.save((IPropertyChanges)changes, (Class)IPlan.class);
    }

    private void deletePlan(Plan plan) {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            if (this.modificationManager.isAddedPlan(plan.getUID())) {
                this.modificationManager.removeAddedPlan(plan);
            } else {
                this.modificationManager.removeModifiedPlan(plan);
                this.modificationManager.addDeletedPlan(plan);
            }
            this.projectAgent.getFrameUniqueElementMgr().planDeletedOnClient(plan);
            UserDefinedAtributeDataManagementFacade.attributeOwnerDeleted(plan);
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    public Collection<Plan> getDeletedPlans() {
        return this.modificationManager.getDeletedPlans();
    }

    @Override
    public boolean isEmpty(ISection section) {
        return this.getChildSections(section).isEmpty() && this.getChildPlans(section).isEmpty();
    }

    public boolean isModified(IPlan plan) {
        return this.modificationManager.isAddedPlan(plan.getUID()) || this.modificationManager.isModifiedPlan(plan.getUID());
    }

    public boolean isModified(ISection section) {
        return this.modificationManager.isAddedSection(section.getUID()) || this.modificationManager.isModifiedSection(section.getUID());
    }

    private void removeSection(ISection sectionToBeDeleted) throws EXNoPermission {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            if (!this.isEmpty(sectionToBeDeleted)) {
                throw new EXNoPermission("may not delete a non-empty section");
            }
            Section section = this.getSectionInternal(sectionToBeDeleted.getUID());
            if (this.modificationManager.isAddedSection(section.getUID())) {
                this.modificationManager.removeAddedSection(section);
                this.projectAgent.getProjectPermissionModificationModel().permissionOperandRemoved(section);
                try {
                    this.projectAgent.getProjectPermissionModificationModel().commit();
                }
                catch (ServerNotAvailableException e) {
                    logger.error("could not remove permissions", (Throwable)e);
                }
                catch (EXServerException e) {
                    logger.error("could not remove permissions", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.error("could not remove permissions", (Throwable)e);
                }
                catch (LoginCanceledException e) {
                    logger.error("could not remove permissions", (Throwable)e);
                }
            } else if (this.modificationManager.isModifiedSection(section.getUID())) {
                this.modificationManager.removeModifiedSection(section);
                this.modificationManager.addDeletedSection(section);
            } else {
                this.modificationManager.addDeletedSection(section);
            }
            UserDefinedAtributeDataManagementFacade.attributeOwnerDeleted(section);
            this.projectAgent.getLinkManager().objectDeleted((ICockpitProjectData)section);
            PropertyChanges changes = new PropertyChanges(null, null, (Object)sectionToBeDeleted);
            this.save((IPropertyChanges)changes, (Class)ISection.class);
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public boolean hasPermissionForSection(ISection section, String operation) {
        return this.projectAgent.getFramePermissionChecker().hasPermission(operation, null, this.getOperandTree(section));
    }

    @Override
    public IPlan getPlan(String planUID) {
        return this.getPlanInternal(planUID);
    }

    @Override
    public IPlanRW getPlanRW(String planUID) {
        return this.getPlanInternal(planUID);
    }

    private Plan getPlanInternal(String planUID) {
        Plan plan = null;
        if (!this.modificationManager.isDeletedPlan(planUID)) {
            plan = this.modificationManager.getAddedPlan(planUID);
            if (plan == null) {
                plan = this.modificationManager.getModifiedPlan(planUID);
            }
            if (plan == null) {
                plan = this.sectionCache.getPlan(planUID);
            }
        }
        return plan;
    }

    @Override
    public boolean hasLocalModifications() {
        return !this.modificationManager.isEmpty();
    }

    public EOSectionAndPlanModifications getModificationsToCommit() {
        return this.modificationManager.getModifications();
    }

    public void applyAsynchronousModifications(EOSectionAndPlanModifications modifications) {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            Plan plan;
            Section section;
            this.rootSection = null;
            ArrayList<Plan> addedPlans = new ArrayList<Plan>();
            ArrayList<Plan> modifiedPlans = new ArrayList<Plan>();
            ArrayList<Plan> deletedPlans = new ArrayList<Plan>();
            ArrayList<Section> addedSections = new ArrayList<Section>();
            ArrayList<Section> modifiedSections = new ArrayList<Section>();
            ArrayList<Section> deletedSections = new ArrayList<Section>();
            for (EOSection eoSection : modifications.getAddedSections()) {
                section = this.createSectionFromEO(eoSection);
                this.sectionCache.addSection(section);
                addedSections.add(section);
            }
            for (EOSection eoSection : modifications.getModifiedSections()) {
                section = this.createSectionFromEO(eoSection);
                this.sectionCache.addSection(section);
                modifiedSections.add(section);
            }
            for (EOPlan eoPlan : modifications.getPlanModifications().getDeletedData()) {
                plan = this.createPlanFromEO(eoPlan);
                this.sectionCache.removePlan(plan);
                this.projectAgent.getUniqueElementRelationshipManager().planDeletedOnServerAsynchronously(plan.getUID());
                deletedPlans.add(plan);
            }
            for (EOPlan eoPlan : modifications.getPlanModifications().getModifiedData()) {
                plan = this.createPlanFromEO(eoPlan);
                this.sectionCache.addPlan(plan);
                modifiedPlans.add(plan);
            }
            for (EOPlan eoPlan : modifications.getPlanModifications().getCreatedData()) {
                plan = this.createPlanFromEO(eoPlan);
                this.sectionCache.addPlan(plan);
                addedPlans.add(plan);
            }
            for (EOSection eoSection : modifications.getDeletedSections()) {
                section = this.createSectionFromEO(eoSection);
                this.sectionCache.removeSection(section);
                deletedSections.add(section);
            }
            PropertyChanges planChanges = new PropertyChanges(addedPlans, modifiedPlans, deletedPlans, true);
            this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)planChanges, IPlan.class);
            PropertyChanges sectionChanges = new PropertyChanges(addedSections, modifiedSections, deletedSections, true);
            this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)sectionChanges, ISection.class);
            this.saveSectionAndPlanModifications();
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    public void applySynchronousModifications(EOSectionAndPlanModifications modification) {
        block14: {
            this.hierarchyCache.startMasterDataUpdate();
            try {
                Section section;
                Plan plan;
                this.rootSection = null;
                if (modification == null) break block14;
                for (EOPlan eoPlan : modification.getPlanModifications().getCreatedData()) {
                    plan = this.createPlanFromEO(eoPlan);
                    this.sectionCache.addPlan(plan);
                    this.modificationManager.removeAddedPlan(plan);
                }
                for (EOPlan eoPlan : modification.getPlanModifications().getModifiedData()) {
                    plan = this.createPlanFromEO(eoPlan);
                    this.modificationManager.removeModifiedPlan(plan);
                    this.sectionCache.addPlan(plan);
                }
                for (EOPlan eoPlan : modification.getPlanModifications().getDeletedData()) {
                    plan = this.createPlanFromEO(eoPlan);
                    this.modificationManager.removeDeletedPlan(plan);
                    this.sectionCache.removePlan(plan);
                    this.projectAgent.getUniqueElementRelationshipManager().planDeletedOnServerSynchronously(plan.getUID());
                }
                for (EOSection eoSection : modification.getAddedSections()) {
                    section = this.createSectionFromEO(eoSection);
                    this.modificationManager.removeAddedSection(section);
                    this.sectionCache.addSection(section);
                }
                for (EOSection eoSection : modification.getModifiedSections()) {
                    section = this.createSectionFromEO(eoSection);
                    this.modificationManager.removeModifiedSection(section);
                    this.sectionCache.addSection(section);
                }
                for (EOSection eoSection : modification.getDeletedSections()) {
                    section = this.createSectionFromEO(eoSection);
                    this.modificationManager.removeDeletedSection(section);
                    this.sectionCache.removeSection(section);
                    this.projectAgent.getProjectPermissionModificationModel().permissionOperandRemoved(section);
                }
                try {
                    this.projectAgent.getProjectPermissionModificationModel().commit();
                }
                catch (ServerNotAvailableException e) {
                    logger.error("could not remove permissions", (Throwable)e);
                }
                catch (EXServerException e) {
                    logger.error("could not remove permissions", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.error("could not remove permissions", (Throwable)e);
                }
                catch (LoginCanceledException e) {
                    logger.error("could not remove permissions", (Throwable)e);
                }
                this.saveSectionAndPlanModifications();
            }
            finally {
                this.hierarchyCache.finishedMasterDataUpdate();
            }
        }
    }

    private Section createSectionFromEO(EOSection eoSection) {
        SectionAttributeModificationManager modManager = new SectionAttributeModificationManager(this.projectAgent);
        Section section = new Section(eoSection, this.projectAgent, (IAttributeModificationManager)modManager);
        modManager.setSection(section);
        return section;
    }

    private Plan createPlanFromEO(EOPlan eoPlan) {
        PlanAttributeModificationManager modManager = new PlanAttributeModificationManager(this.projectAgent);
        Plan plan = new Plan((EOFrameData)eoPlan, modManager, this.projectAgent);
        modManager.setPlan(plan);
        return plan;
    }

    private <P> void save(IPropertyChanges<? extends P> changes, Class<P> clazz) {
        this.saveSectionAndPlanModifications();
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed(changes, clazz);
    }

    private IModificationProblem requestSectionChildAddPermission(ISection section, String newChildName, String newChildDataType) {
        ModificationProblem modProblem = null;
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("modifyFolders", null, this.getOperandTree(section))) {
            CockpitPermissionTemplate template = new CockpitPermissionTemplate("modifyFolders", section.getPermissionOperandType());
            modProblem = new ModificationProblem(template, NO_EDIT_PERMISSION, this.projectAgent);
        }
        if (modProblem == null && !this.modificationManager.isAddedSection(section.getUID())) {
            IFrameLockManager lockMgr = this.projectAgent.getFrameLockManager();
            EOLock deleteLock = new LockRequest(section, "delete").createEOLock();
            EOLock addLock = new LockRequest(section, "add").createEOLock();
            String lockType = "uniqueName_" + newChildDataType + "_" + newChildName.toLowerCase();
            EOLock uniqueNameLock = new LockRequest(section, lockType).createEOLock();
            ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
            ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
            locksToBeChecked.add(deleteLock);
            locksToBeChecked.add(uniqueNameLock);
            locksToBeSet.add(uniqueNameLock);
            locksToBeSet.add(addLock);
            LockResult lockResult = lockMgr.atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
            Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
            if (!lockResult.wasSuccessful()) {
                if (!conflictingLocks.isEmpty()) {
                    EOLock conflictingLock = conflictingLocks.iterator().next();
                    modProblem = new ModificationProblem(conflictingLock, NLS.bind((String)Messages.getString("SectionManager.cannot_addChildrenCauseOfLock_with_elementName"), (Object)newChildName));
                } else if (lockResult.getPossibleServerException() != null) {
                    modProblem = new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("SectionManager.CannotAddChildren.ServerException"));
                }
            }
        }
        return modProblem;
    }

    private IModificationProblem checkSectionChildAddPermission(ISection parentSection, boolean includingLocks) {
        ModificationProblem modProblem = null;
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("modifyFolders", null, this.getOperandTree(parentSection))) {
            CockpitPermissionTemplate template = new CockpitPermissionTemplate("modifyFolders", parentSection.getPermissionOperandType());
            modProblem = new ModificationProblem(template, NO_EDIT_PERMISSION, this.projectAgent);
        }
        if (modProblem == null && includingLocks && !this.modificationManager.isAddedSection(parentSection.getUID())) {
            Throwable serverException = null;
            try {
                EOLock conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasProjectLock();
                if (conflictingLock == null) {
                    conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasLock(parentSection, "delete");
                }
                if (conflictingLock != null) {
                    modProblem = new ModificationProblem(conflictingLock, Messages.getString("SectionManager.cannot_addChildrenCauseOfLock"));
                }
            }
            catch (ServerNotAvailableException e) {
                serverException = e;
            }
            catch (LoginCanceledException e) {
                serverException = e;
            }
            catch (EXServerException e) {
                serverException = e;
            }
            catch (UnknownServerException e) {
                serverException = e;
            }
            if (serverException != null) {
                modProblem = new ModificationProblem((Exception)serverException, Messages.getString("ProjectAttributeModificationManager.project_cannot_be_modified"));
            }
        }
        return modProblem;
    }

    @Override
    public IModificationProblem checkPlanAdditionPermission(ISection parentSection, boolean includingLocks) {
        return this.checkSectionChildAddPermission(parentSection, includingLocks);
    }

    @Override
    public IModificationProblem checkSectionAdditionPermission(ISection parentSection, boolean includingLocks) {
        return this.checkSectionChildAddPermission(parentSection, includingLocks);
    }

    @Override
    public ISectionAddID requestSectionAdditionPermission(String name, ISection parentSection, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        Section sectionToAdd = new Section(UUIDGenerator.getUniqueID(), name, parentSection.getUID(), attributes, this.projectAgent, IAttributeModificationManager.DUMMY);
        sectionToAdd.setCategoryID(objectTypeCategoryID);
        return this.requestSectionAdditionPermissionInternal(sectionToAdd, parentSection);
    }

    @Override
    public ISectionAddID requestSectionAdditionPermission(String sectionUID, String name, ISection parentSection, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        Section sectionToAdd = new Section(sectionUID, name, parentSection.getUID(), attributes, this.projectAgent, IAttributeModificationManager.DUMMY);
        sectionToAdd.setCategoryID(objectTypeCategoryID);
        return this.requestSectionAdditionPermissionInternal(sectionToAdd, parentSection);
    }

    @Override
    public ISectionAddID requestSectionImportPermission(EOSection eoSection, ISection parentSection) {
        Section sectionToImport = new Section(eoSection, this.projectAgent, IAttributeModificationManager.DUMMY);
        return this.requestSectionAdditionPermissionInternal(sectionToImport, parentSection);
    }

    private ISectionAddID requestSectionAdditionPermissionInternal(ISection sectionToAdd, final ISection parentSection) {
        ModificationProblem modProblem = null;
        RenameSectionValidator validator = new RenameSectionValidator(this.projectAgent, parentSection);
        String msg = validator.isValid(sectionToAdd.getSectionName());
        if (msg != null) {
            modProblem = new ModificationProblem(Messages.getString("SectionManager.name_is_invalid"), msg);
        }
        IParentOperandTree operandTree = new IParentOperandTree(){

            @Override
            public IPermissionOperand getBaseOperand() {
                return parentSection;
            }

            @Override
            public IPermissionOperand getParent(IPermissionOperand childOperand) {
                return SectionManager.this.getParentSection((ISection)childOperand);
            }
        };
        if (modProblem == null) {
            IAttributeTypesProvider attributeTypesProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.section");
            for (IAttribute attribute : sectionToAdd.getAllAttributes()) {
                IAttributeType attributeType = attributeTypesProv.getAttributeType(attribute.getAttributeTypeID());
                if (this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeType, operandTree, true)) continue;
                modProblem = new ModificationProblem(attributeType, operandTree, this.projectAgent);
                break;
            }
        }
        if (modProblem == null) {
            modProblem = this.requestSectionChildAddPermission(parentSection, sectionToAdd.getSectionName(), "com.arcway.cockpit.section");
        }
        final ModificationProblem mp = modProblem;
        ISectionAddID addID = new ISectionAddID(){

            @Override
            public IModificationProblem getModificationProblem() {
                return mp;
            }

            @Override
            public boolean permissionGranted() {
                return mp == null;
            }
        };
        if (mp == null) {
            this.addPermissionIDs.put(addID, (ICockpitProjectData)sectionToAdd);
        }
        return addID;
    }

    @Override
    public void requestPlanEditPermission(IPlan plan, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.modificationManager.isAddedPlan(plan.getUID())) {
            transactionController.addLockToTest(plan, "modify");
            transactionController.addLock(plan, "modify");
            ISection parentSection = this.getSection(plan.getSectionUID());
            transactionController.addPermission("editPlan", null, this.getOperandTree(parentSection));
        }
    }

    @Override
    public boolean isLocallyAdded(ISection section) {
        return this.modificationManager.isAddedSection(section.getUID());
    }

    @Override
    public boolean isLocallyAdded(IPlan plan) {
        return this.modificationManager.isAddedPlan(plan.getUID());
    }

    @Override
    public IPlanAddID requestPlanAdditionPermission(String name, String planTypeUID, ISection section, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        return this.requestPlanAdditionPermissionInternal(UUIDGenerator.getUniqueID(), name, planTypeUID, section, objectTypeCategoryID, attributes);
    }

    @Override
    public IPlanAddID requestPlanAdditionPermission(String planUID, String name, String planTypeUID, ISection section, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        return this.requestPlanAdditionPermissionInternal(planUID, name, planTypeUID, section, objectTypeCategoryID, attributes);
    }

    private IPlanAddID requestPlanAdditionPermissionInternal(final String planUID, String name, String planTypeUID, ISection section, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        ModificationProblem modProblem = null;
        RenamePlanValidator validator = new RenamePlanValidator(this.projectAgent, section.getUID());
        String msg = validator.isValid(name);
        if (msg != null) {
            modProblem = new ModificationProblem(Messages.getString("SectionManager.name_is_invalid"), msg);
        }
        if (modProblem == null) {
            modProblem = this.requestSectionChildAddPermission(section, name, "com.arcway.cockpit.plan");
        }
        final ModificationProblem mp = modProblem;
        IPlanAddID addID = new IPlanAddID(){

            @Override
            public boolean permissionGranted() {
                return mp == null;
            }

            @Override
            public IModificationProblem getModificationProblem() {
                return mp;
            }

            @Override
            public String getPlanUID() {
                return mp == null ? planUID : null;
            }
        };
        if (mp == null) {
            Plan plan = new Plan(name, planUID, planTypeUID, section.getUID(), attributes, IAttributeModificationManager.DUMMY, this.projectAgent);
            plan.setCategoryID(objectTypeCategoryID);
            this.addPermissionIDs.put(addID, (ICockpitProjectData)plan);
        }
        return addID;
    }

    @Override
    public void requestPlanDeletionPermission(IPlan planToDelete, ILocksAndPermissionsTransactionController transactionController) {
        List<ICockpitProjectData> linkedModuleData = this.planLinkFacade.getCrossLinkedModuleData(planToDelete.getUID(), ILinkContentProvider.NO_LINK_TYPE_FILTER);
        if (!linkedModuleData.isEmpty()) {
            transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("SectionManager.plan_is_linked"), Messages.getString("SectionManager.could_not_delete_plan")));
        }
        Plan plan = this.getPlanInternal(planToDelete.getUID());
        ISection parentSection = this.getSection(plan.getSectionUID());
        transactionController.addPermission("deletePlan", null, this.getOperandTree(parentSection));
        if (!this.modificationManager.isAddedPlan(plan.getUID())) {
            transactionController.addLock(plan, "delete");
            transactionController.addLock(plan, "modify");
            transactionController.addLockToTest(plan, "add");
            transactionController.addLockToTest(plan, "delete");
            transactionController.addLockToTest(plan, "modify");
        }
        new FrameDataTransactionListener(plan, this.approvedPlanDeletions, transactionController);
    }

    @Override
    public ISectionExportDataProvider getExportDataProvider() {
        return this.exportDataProvider;
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public String getLocalizedManagerName() {
        return Messages.getString("SectionManager.section_manager");
    }

    @Override
    public void discardLocalModifications() {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            if (!this.modificationManager.getAddedSections().isEmpty()) {
                for (Section addedSection : this.modificationManager.getAddedSections()) {
                    this.projectAgent.getProjectPermissionModificationModel().permissionOperandRemoved(addedSection);
                }
                try {
                    this.projectAgent.getProjectPermissionModificationModel().commit();
                }
                catch (EXServerException e) {
                    logger.error("Unable to remove permission from server.", (Throwable)e);
                }
                catch (ServerNotAvailableException e) {
                    logger.error("Unable to remove permission from server.", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.error("Unable to remove permission from server.", (Throwable)e);
                }
                catch (LoginCanceledException e) {
                    logger.error("Unable to remove permission from server.", (Throwable)e);
                }
            }
            this.modificationManager.clear();
            this.saveSectionAndPlanModifications();
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return cockpitDataTypeID.equals("com.arcway.cockpit.plan") || cockpitDataTypeID.equals("com.arcway.cockpit.section");
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        return this.sectionCache.getSection(cockpitDataUID) != null || this.sectionCache.getPlan(cockpitDataUID) != null;
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        Object data = this.getSection(cockpitDataUID);
        if (data == null) {
            data = this.getPlan(cockpitDataUID);
        }
        return data;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        if (this.dataLabelProvider == null) {
            final ProjectTreeContentProvider lp = new ProjectTreeContentProvider(null);
            this.dataLabelProvider = new IDataLabelProvider(){

                public Image getImageOfType(String dataTypeID) {
                    ICockpitDataType dt = FrameDataTypes.getDataType(dataTypeID);
                    if (dt != null) {
                        return dt.getIcon();
                    }
                    return null;
                }

                public String getTypeDisplayName(String dataTypeID) {
                    ICockpitDataType dt = FrameDataTypes.getDataType(dataTypeID);
                    if (dt != null) {
                        return dt.getDisplayName();
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    return lp.getImage(element);
                }

                public String getText(Object element) {
                    return lp.getText(element);
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
        }
        return this.dataLabelProvider;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        ArrayList<ICockpitDataType> dataTypes = new ArrayList<ICockpitDataType>();
        if (this.modificationManager.hasModificationsForPlans()) {
            dataTypes.add(FrameDataTypes.getDataType("com.arcway.cockpit.plan"));
        }
        if (this.modificationManager.hasModificationsForSections()) {
            dataTypes.add(FrameDataTypes.getDataType("com.arcway.cockpit.section"));
        }
        ILocalModificationContainer[] modItems = new ILocalModificationContainer[dataTypes.size()];
        int i = 0;
        while (i < dataTypes.size()) {
            ILocalModificationContainer item;
            final ICockpitDataType dataType = (ICockpitDataType)dataTypes.get(i);
            modItems[i] = item = new ILocalModificationContainer(){

                public IDataLabelProvider getDataLabelProvider() {
                    return SectionManager.this.getDataLabelProvider();
                }

                public boolean isEmpty() {
                    if (dataType.equals(FrameDataTypes.getDataType("com.arcway.cockpit.plan"))) {
                        return !SectionManager.this.modificationManager.hasModificationsForPlans();
                    }
                    return !SectionManager.this.modificationManager.hasModificationsForSections();
                }

                public IAddedItem[] getAddedItems() {
                    return SectionManager.this.modificationManager.getAddedItems(dataType.getCockpitDataTypeID());
                }

                public IModifiedItem[] getModifiedItems() {
                    return SectionManager.this.modificationManager.getModifiedItems(dataType.getCockpitDataTypeID());
                }

                public IDeletedItem[] getDeletedItems() {
                    return SectionManager.this.modificationManager.getDeletedItems(dataType.getCockpitDataTypeID());
                }

                public Image getGeneralImage() {
                    return dataType.getIcon();
                }

                public String getGeneralDescription() {
                    return dataType.getDisplayName();
                }

                public String getTypeIDOfContainedData() {
                    return dataType.getCockpitDataTypeID();
                }
            };
            ++i;
        }
        return modItems;
    }

    @Override
    public void planMoved(Plan movedPlan, ISection p_oldParentSection) throws EXNoPermission, EXNoLock {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            ISection oldParentSection = p_oldParentSection == null ? this.lostAndFound : p_oldParentSection;
            ISection newParentSection = this.getParentSection(movedPlan);
            if (!this.projectAgent.getFramePermissionChecker().hasPermission("modifyFolders", null, this.getOperandTree(oldParentSection))) {
                throw new EXNoPermission((IPermissionOperand)oldParentSection, "modifyFolders");
            }
            if (!this.projectAgent.getFramePermissionChecker().hasPermission("modifyFolders", null, this.getOperandTree(newParentSection))) {
                throw new EXNoPermission((IPermissionOperand)newParentSection, "modifyFolders");
            }
            if (!this.modificationManager.isAddedSection(newParentSection.getUID())) {
                String uniqueNameLockType = "uniqueName_com.arcway.cockpit.plan_" + movedPlan.getPlanName().toLowerCase();
                if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(newParentSection, uniqueNameLockType)) {
                    throw new EXNoLock(newParentSection, uniqueNameLockType);
                }
                if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(newParentSection, "add")) {
                    throw new EXNoLock(newParentSection, "add");
                }
            }
            if (this.lostPlans != null && this.lostPlans.containsKey(movedPlan.getUID())) {
                this.lostPlans.remove(movedPlan.getUID());
            }
            this.planUpdated(movedPlan);
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public void planNameUpdated(Plan plan) throws EXNoPermission, EXNoLock {
        ISection parentSection = this.getSection(plan.getSectionUID());
        RenamePlanValidator nameValidator = new RenamePlanValidator(plan);
        String newName = plan.getPlanName();
        String exceptionMessage = nameValidator.isValid(newName);
        if (exceptionMessage != null) {
            throw new EXNoPermission(exceptionMessage);
        }
        if (!this.modificationManager.isAddedPlan(plan.getUID())) {
            String lockType = "uniqueName_com.arcway.cockpit.plan_" + newName.toLowerCase();
            if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(parentSection, lockType)) {
                throw new EXNoLock(parentSection, lockType);
            }
        }
        this.planUpdated(plan);
    }

    @Override
    public void planUpdated(Plan plan) throws EXNoPermission, EXNoLock {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            if (!this.modificationManager.isAddedPlan(plan.getUID()) && !this.projectAgent.getFrameLockManager().clientAlreadyHasLock(plan, "modify")) {
                throw new EXNoLock(plan, "modify");
            }
            this.dataModified(plan);
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> clazz) {
        ArrayList<Section> attributeOwners = new ArrayList<Section>(this.getSections());
        attributeOwners.addAll(this.getPlans());
        return this.projectAgent.getAllAttributesOfType(attributeOwners, clazz);
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        IAttributeTypesProvider sectionAttrTypesProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.section");
        IAttributeTypesProvider planAttrTypesProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.section");
        ArrayList<IAttributeType> allTypes = new ArrayList<IAttributeType>(sectionAttrTypesProv.getAttributeTypes());
        allTypes.addAll(planAttrTypesProv.getAttributeTypes());
        Iterator i = allTypes.iterator();
        while (i.hasNext()) {
            IAttributeType type = (IAttributeType)i.next();
            if (dataTypeClass.isAssignableFrom(type.getDataType().getClass())) continue;
            i.remove();
        }
        return allTypes;
    }

    private void deleteEmptySections(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        ArrayList<FrameDataTransactionListener> listeners = new ArrayList<FrameDataTransactionListener>(this.approvedSectionDeletions.get(transactionController));
        for (FrameDataTransactionListener listener : listeners) {
            Section section = (Section)listener.getData();
            this.removeSection(section);
            listener.kill();
        }
    }

    @Override
    public void requestDeleteSectionPermission(String sectionUID, ILocksAndPermissionsTransactionController transactionController) {
        Section section = this.getSectionInternal(sectionUID);
        this.mayDelete(section, transactionController, false);
    }

    @Override
    public void requestDeleteSectionCascadingPermission(String sectionUID, ILocksAndPermissionsTransactionController transactionController) {
        Section section = this.getSectionInternal(sectionUID);
        this.mayDelete(section, transactionController, true);
    }

    private void mayDelete(Section sectionToDelete, ILocksAndPermissionsTransactionController transactionController, boolean cascading) {
        Section parentSection;
        List<ICockpitProjectData> linkedModuleData = this.sectionLinkFacade.getCrossLinkedModuleData(sectionToDelete.getUID(), ILinkContentProvider.NO_LINK_TYPE_FILTER);
        if (!linkedModuleData.isEmpty()) {
            transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("SectionManager.section_is_linked"), Messages.getString("SectionManager.could_not_delete_section")));
        }
        if ((parentSection = this.getSectionInternal(sectionToDelete.getParentUID())) != null) {
            transactionController.addPermission("modifyFolders", null, this.getOperandTree(parentSection));
        }
        if (!this.modificationManager.isAddedSection(sectionToDelete.getUID())) {
            transactionController.addLockToTest(sectionToDelete, "add");
            transactionController.addLockToTest(sectionToDelete, "modify");
            transactionController.addLockToTest(sectionToDelete, "delete");
            transactionController.addLock(sectionToDelete, "delete");
            transactionController.addLock(sectionToDelete, "modify");
        }
        if (cascading) {
            for (Section childSection : this.getChildSections(sectionToDelete)) {
                this.mayDelete(childSection, transactionController, true);
            }
            for (Plan plan : this.getChildPlans(sectionToDelete)) {
                linkedModuleData = this.planLinkFacade.getCrossLinkedModuleData(plan.getUID(), ILinkContentProvider.NO_LINK_TYPE_FILTER);
                if (!linkedModuleData.isEmpty()) {
                    transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("SectionManager.plan_is_linked"), Messages.getString("SectionManager.could_not_delete_plan")));
                }
                transactionController.addPermission("deletePlan", null, this.getOperandTree(sectionToDelete));
                if (!this.modificationManager.isAddedPlan(plan.getUID())) {
                    transactionController.addLockToTest(plan, "add");
                    transactionController.addLockToTest(plan, "delete");
                    transactionController.addLockToTest(plan, "modify");
                    transactionController.addLock(plan, "delete");
                    transactionController.addLock(plan, "modify");
                }
                new FrameDataTransactionListener(plan, this.approvedPlanDeletions, transactionController);
            }
        }
        new FrameDataTransactionListener(sectionToDelete, null, this.approvedSectionDeletions, transactionController);
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        if (data instanceof IPlan) {
            IPlan plan = (IPlan)data;
            this.requestPlanDeletionPermission(plan, transactionController);
        } else if (data instanceof ISection) {
            ISection section = (ISection)data;
            this.requestDeleteSectionCascadingPermission(section.getUID(), transactionController);
        }
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        Collection<FrameDataTransactionListener> planDeletionListeners = this.approvedPlanDeletions.get(transactionController);
        Collection<FrameDataTransactionListener> sectionDeletionListeners = this.approvedSectionDeletions.get(transactionController);
        if (planDeletionListeners == null && sectionDeletionListeners == null) {
            throw new EXNoPermission("No permission to delete section and/or plan");
        }
        if (planDeletionListeners != null) {
            this.deletePlan(transactionController);
        }
        if (sectionDeletionListeners != null) {
            this.deleteEmptySections(transactionController);
        }
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("Functionality is not implemented.", "Can not add data."));
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        if (parent instanceof ISection) {
            ISection section = (ISection)parent;
            String sectionUID = section.getUID();
            Collection<IAttributeOwner> children = this.hierarchyCache.getChildrenInfo().get(sectionUID);
            if (children == null) {
                Collection<Section> childSections = this.getChildSections(section);
                Collection<Plan> childPlans = this.getChildPlans(section);
                children = new ArrayList<IAttributeOwner>(childSections.size() + childPlans.size());
                children.addAll(childSections);
                children.addAll(childPlans);
                children = Collections.unmodifiableCollection(children);
                this.hierarchyCache.getChildrenInfo().put(sectionUID, children);
            }
            return children;
        }
        return Collections.emptyList();
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        IPermissionOperand parent = this.projectAgent.getProjectMetaDataManager().getProject();
        if (child instanceof ISection) {
            ISection section = (ISection)child;
            if (!section.isRootSection()) {
                parent = this.getParentSection(section);
            }
        } else if (child instanceof IPlan) {
            IPlan plan = (IPlan)child;
            parent = this.getParentSection(plan);
        }
        return parent;
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        Collection<Section> sections = this.getSections();
        Collection<Plan> plans = this.getPlans();
        ArrayList<AbstractFrameData> data = new ArrayList<AbstractFrameData>(sections.size() + plans.size());
        data.addAll(sections);
        data.addAll(plans);
        return data;
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
        IAttributeOwnerRW.Visitor.visitAllAttributeOwnerRWs(this.getData(), visitor);
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        return dataTypeID.equals("frame.project") || dataTypeID.equals("com.arcway.cockpit.section");
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        if (dataToMove instanceof IPlanRW) {
            assert (newParent instanceof ISection);
            ISection newParentSection = (ISection)newParent;
            IPlanRW plan = (IPlanRW)dataToMove;
            RenamePlanValidator validator = new RenamePlanValidator(this.projectAgent, newParentSection.getUID());
            String validatorMsg = validator.isValid(plan.getPlanName());
            if (validatorMsg != null) {
                ModificationProblem modProblem = new ModificationProblem(Messages.getString("PlanAttributeModificationManager.new_name_is_invalid"), validatorMsg);
                transactionController.addLockModificationProblem(modProblem);
            }
            IParentOperandTree operandTreeNewSection = this.getOperandTree(newParentSection);
            transactionController.addPermission("modifyFolders", null, operandTreeNewSection);
            for (IAttribute iAttribute : plan.getAllAttributes()) {
                IAttributeType attributeType = plan.getAttributeType(iAttribute.getAttributeTypeID());
                if (!attributeType.restrictedAccessOnCreation() || iAttribute.getAttributeValue().equals(attributeType.getDataType().getDefaultValue())) continue;
                transactionController.addAttributeModificationPermission(attributeType, operandTreeNewSection);
            }
            ISection iSection = this.getParentSection(plan);
            transactionController.addPermission("modifyFolders", null, this.getOperandTree(iSection));
            String uniqueNameLockType = "uniqueName_" + plan.getTypeID() + "_" + plan.getPlanName().toLowerCase();
            transactionController.addLockToTest(newParentSection, "delete");
            transactionController.addLockToTest(newParentSection, uniqueNameLockType);
            transactionController.addLock(newParentSection, uniqueNameLockType);
            transactionController.addLock(newParentSection, "add");
            transactionController.addLockToTest((ILockable)dataToMove, "modify");
            transactionController.addLock((ILockable)dataToMove, "modify");
            HashMap<String, Object> addionalData = new HashMap<String, Object>(2);
            addionalData.put("unspecified", newParent);
            addionalData.put("oldParent", iSection);
            new FrameDataTransactionListener(plan, addionalData, this.grantedMoveRequests, transactionController);
        } else if (dataToMove instanceof ISectionRW) {
            Section section = this.getSectionInternal(dataToMove.getUID());
            ISection newParentSection = (ISection)newParent;
            ISection oldParent = this.projectAgent.getFrameSectionManager().getParentSection(section);
            IParentOperandTree operandTreeOld = this.projectAgent.getFrameSectionManager().getOperandTree(oldParent);
            transactionController.addPermission("modifyFolders", null, operandTreeOld);
            IParentOperandTree operandTreeNew = this.projectAgent.getFrameSectionManager().getOperandTree(newParentSection);
            transactionController.addPermission("modifyFolders", null, operandTreeNew);
            for (IAttribute iAttribute : section.getAllAttributes()) {
                IAttributeType type = section.getAttributeType(iAttribute.getAttributeTypeID());
                if (!type.restrictedAccessOnCreation() || iAttribute.getAttributeValue().equals(type.getDataType().getDefaultValue())) continue;
                transactionController.addAttributeModificationPermission(type, operandTreeNew);
            }
            if (this.projectAgent.getFrameSectionManager().containsChildSection(newParentSection, section.getSectionName())) {
                ModificationProblem modificationProblem = new ModificationProblem(Messages.getString("SectionManager.new_name_is_invalid"), Messages.getString("SectionManager.folder_with_same_name_under_new"));
                transactionController.addLockModificationProblem(modificationProblem);
            }
            if (this.projectAgent.getFrameSectionManager().isAncestor(newParentSection, section) || section.getUID().equals(newParentSection.getUID())) {
                ModificationProblem modificationProblem = new ModificationProblem(Messages.getString("SectionManager.new_parent_folder_not_allowed"), Messages.getString("SectionManager.cannot_move_under_ancestor"));
                transactionController.addLockModificationProblem(modificationProblem);
            }
            if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(newParentSection)) {
                String string = "uniqueName_" + section.getTypeID() + "_" + section.getSectionName().toLowerCase();
                transactionController.addLockToTest(newParentSection, "delete");
                transactionController.addLockToTest(newParentSection, "move");
                transactionController.addLockToTest(newParentSection, string);
                transactionController.addLock(newParentSection, string);
                transactionController.addLock(newParentSection, "add");
                transactionController.addLock(newParentSection, "move");
            }
            if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(section)) {
                transactionController.addLockToTest(section, "add");
                transactionController.addLockToTest(section, "delete");
                transactionController.addLockToTest(section, "modify");
                transactionController.addLockToTest(section, "move");
                transactionController.addLock(section, "move");
                transactionController.addLock(section, "modify");
                for (ISection iSection : this.getChildSections(section)) {
                    transactionController.addLockToTest(iSection, "move");
                }
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
            hashMap.put("unspecified", newParent);
            hashMap.put("oldParent", oldParent);
            new FrameDataTransactionListener(section, hashMap, this.grantedMoveRequests, transactionController);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission, EXNoLock {
        Collection<FrameDataTransactionListener> listeners = this.grantedMoveRequests.get(transactionController);
        if (listeners == null) {
            throw new EXNoPermission("Permission was not requested to move this plan or section.");
        }
        listeners = new ArrayList<FrameDataTransactionListener>(listeners);
        for (FrameDataTransactionListener listener : listeners) {
            ISection oldParentSection;
            ISection newParentSection;
            if (listener.getData() instanceof IPlanRW) {
                IPlanRW plan = (IPlanRW)listener.getData();
                newParentSection = (ISection)listener.getAdditionalData("unspecified");
                oldParentSection = (ISection)listener.getAdditionalData("oldParent");
                plan.setSectionUID(newParentSection.getUID());
                listener.kill();
                this.projectAgent.getSequencerManager().objectMoved((ICockpitProjectData)plan, (ICockpitProjectData)oldParentSection, (ICockpitProjectData)newParentSection);
                continue;
            }
            if (!(listener.getData() instanceof ISectionRW)) continue;
            ISectionRW sectionToMove = (ISectionRW)listener.getData();
            newParentSection = (ISection)listener.getAdditionalData("unspecified");
            oldParentSection = (ISection)listener.getAdditionalData("oldParent");
            sectionToMove.setParentUID(newParentSection.getUID());
            listener.kill();
            this.projectAgent.getSequencerManager().objectMoved((ICockpitProjectData)sectionToMove, (ICockpitProjectData)oldParentSection, (ICockpitProjectData)newParentSection);
        }
    }

    @Override
    public void dataModified(IAttributeOwner attributeOwner) {
        this.hierarchyCache.startMasterDataUpdate();
        try {
            if (attributeOwner instanceof Section) {
                Section section = (Section)attributeOwner;
                if (!this.modificationManager.isAddedSection(section.getUID()) && !this.modificationManager.isModifiedSection(section.getUID())) {
                    this.modificationManager.addModifiedSection(this.getSectionInternal(section.getUID()));
                }
                PropertyChanges changes = new PropertyChanges(null, (Object)section, null);
                this.save((IPropertyChanges)changes, (Class)ISection.class);
            } else if (attributeOwner instanceof Plan) {
                Plan plan = (Plan)attributeOwner;
                if (!this.modificationManager.isAddedPlan(plan.getUID()) && !this.modificationManager.isModifiedPlan(plan.getUID())) {
                    this.modificationManager.addModifiedPlan(plan);
                }
                PropertyChanges changes = new PropertyChanges(null, (Object)plan, null);
                this.save((IPropertyChanges)changes, (Class)IPlan.class);
            } else assert (false);
        }
        finally {
            this.hierarchyCache.finishedMasterDataUpdate();
        }
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        return null;
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        return this.modificationManager.isModifiedPlan(dataUID) || this.modificationManager.isModifiedSection(dataUID);
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        return this.modificationManager.isAddedPlan(dataUID) || this.modificationManager.isAddedSection(dataUID);
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        return null;
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        return null;
    }

    @Override
    public IPlan getHistoricPlanVersion(String uid, int modificationCount) {
        return this.historyDataManager.getHistoricItem(uid, "com.arcway.cockpit.plan", modificationCount);
    }

    @Override
    public List<? extends IPlan> getHistoricPlanVersions(IPlan currentPlan) {
        return this.historyDataManager.getHistoricVersionsOfItem(currentPlan);
    }

    private void saveSectionAndPlanModifications() {
        this.modificationFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOSectionAndPlanModifications>(){

            public EOSectionAndPlanModifications getFileContent() {
                EOSectionAndPlanModifications modifications;
                if (!SectionManager.this.hasLocalModifications()) {
                    modifications = null;
                } else {
                    modifications = SectionManager.this.getModificationsToCommit();
                    if (!$assertionsDisabled && modifications == null) {
                        throw new AssertionError();
                    }
                }
                return modifications;
            }
        });
    }

    private EOSectionAndPlanModifications readSectionAndPlanModifications() throws EXCorruptProjectData {
        try {
            return (EOSectionAndPlanModifications)this.modificationFileAccessor.read();
        }
        catch (Exception e) {
            throw new EXCorruptProjectData(e);
        }
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return this.getProjectAgent().getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.section");
    }

    private class HierarchyCache {
        private static final int masterDataUpdateInProgressIitialValue = 0;
        private int masterDataUpdateInProgress;
        private final Map<String, Collection<Plan>> childPlansInfo;
        private final Map<String, Collection<Section>> childSectionsInfo;
        private final Map<String, Collection<IAttributeOwner>> childrenInfo;

        public HierarchyCache() {
            int initialCapacity = 50;
            float loadFactor = 0.5f;
            this.childPlansInfo = new HashMap<String, Collection<Plan>>(50, 0.5f);
            this.childSectionsInfo = new HashMap<String, Collection<Section>>(50, 0.5f);
            this.childrenInfo = new HashMap<String, Collection<IAttributeOwner>>(50, 0.5f);
            this.masterDataUpdateInProgress = 0;
        }

        public void startMasterDataUpdate() {
            assert (this.masterDataUpdateInProgress >= 0);
            ++this.masterDataUpdateInProgress;
            this.clear();
        }

        public void finishedMasterDataUpdate() {
            --this.masterDataUpdateInProgress;
            assert (this.masterDataUpdateInProgress >= 0);
            this.clear();
        }

        private void clear() {
            this.childPlansInfo.clear();
            this.childSectionsInfo.clear();
            this.childrenInfo.clear();
        }

        public Map<String, Collection<Plan>> getChildPlansInfo() {
            if (this.masterDataUpdateInProgress != 0) {
                this.clear();
            }
            return this.childPlansInfo;
        }

        public Map<String, Collection<Section>> getChildSectionsInfo() {
            if (this.masterDataUpdateInProgress != 0) {
                this.clear();
            }
            return this.childSectionsInfo;
        }

        public Map<String, Collection<IAttributeOwner>> getChildrenInfo() {
            if (this.masterDataUpdateInProgress != 0) {
                this.clear();
                assert (false);
            }
            return this.childrenInfo;
        }
    }
}

