/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links.linkableobjects;

import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.AbstractBasicLOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILinkTypeFilter;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LOLinkAccessFacade
extends AbstractBasicLOLinkAccessFacade
implements ILOLinkAccessFacade {
    public LOLinkAccessFacade(String dataTypeID, LinkManager linkManager) {
        super(dataTypeID, linkManager);
    }

    @Override
    public Collection linkableObjectDeleted(ICockpitProjectData linkableObject) {
        return this.getLinkManager().linkedItemDeleted(this.getDataTypeID(), linkableObject);
    }

    @Override
    public Collection<EOLink> getCrossLinks(String linkableObjectUID, ILinkTypeFilter linkTypeFilter) {
        Set<EOLink> allLinks = this.getLinkManager().getLinksForLinkableObject(this.getDataTypeID(), linkableObjectUID);
        ArrayList<EOLink> linksIgnoreSequencerLinks = new ArrayList<EOLink>(allLinks.size());
        for (EOLink link : allLinks) {
            String linkTypeID = link.getLinkTypeID();
            if (linkTypeFilter.isLinkTypeToExclude(linkTypeID) || !LOLinkAccessFacade.isRealDataLink(link)) continue;
            linksIgnoreSequencerLinks.add(link);
        }
        return linksIgnoreSequencerLinks;
    }

    @Override
    public Collection<EOLink> getParentChildLinks(String linkableObjectUID) {
        Set<EOLink> allLinks = this.getLinkManager().getLinksForLinkableObject(this.getDataTypeID(), linkableObjectUID);
        ArrayList<EOLink> parentChildLinks = new ArrayList<EOLink>(allLinks.size());
        for (EOLink link : allLinks) {
            if (!LOLinkAccessFacade.isParentChildLink(link)) continue;
            parentChildLinks.add(link);
        }
        return parentChildLinks;
    }

    @Override
    public Collection addLinks(Collection links) {
        return this.getLinkManager().addLinks(links);
    }

    @Override
    public List<ICockpitProjectData> getCrossLinkedModuleData(String linkableObjectUID, ILinkTypeFilter linkTypeFilter) {
        Collection<EOLink> links = this.getCrossLinks(linkableObjectUID, linkTypeFilter);
        ArrayList<ICockpitProjectData> linkableObjects = new ArrayList<ICockpitProjectData>(links.size());
        for (EOLink link : links) {
            linkableObjects.add(this.getLinkManager().getModuleDataItem(link));
        }
        return linkableObjects;
    }

    public static boolean isRealDataLink(EOLink link) {
        String linkTypeID = link.getLinkTypeID();
        if (linkTypeID.startsWith("parent_child_")) {
            return false;
        }
        return !linkTypeID.startsWith("data_sequences_");
    }

    public static boolean isParentChildLink(EOLink link) {
        String linkTypeID = link.getLinkTypeID();
        return linkTypeID.startsWith("parent_child_");
    }

    @Override
    public Collection getModuleData(String linkableObjectUID, int modCount) {
        ArrayList<ICockpitProjectData> moduleData = new ArrayList<ICockpitProjectData>();
        for (EOLinkLog link : this.getLinkLogs(linkableObjectUID, modCount)) {
            moduleData.add(this.getLinkManager().getVersionedModuleData(link));
        }
        return moduleData;
    }

    @Override
    public Collection getLinkLogs(String linkableObjectUID, int modCount) {
        return this.getLinkManager().getVersionedLinksForLinkableObject(this.getDataTypeID(), linkableObjectUID, modCount);
    }

    @Override
    public Collection getLinksForData(Collection linkableObjects, Collection moduleData) {
        assert (linkableObjects != null) : "linkableObjects must not be null";
        assert (moduleData != null) : "moduleData must not be null";
        HashSet<EOLink> links = new HashSet<EOLink>();
        for (ICockpitProjectData linkableObject : linkableObjects) {
            links.addAll(this.getLinkManager().getLinksForLinkableObject(this.getDataTypeID(), linkableObject.getUID()));
        }
        HashSet<String> moduleDataUIDs = new HashSet<String>();
        for (ICockpitProjectData element : moduleData) {
            moduleDataUIDs.add(element.getUID());
        }
        Iterator i = links.iterator();
        while (i.hasNext()) {
            EOLink link = (EOLink)i.next();
            if (moduleDataUIDs.contains(link.getModuleDataUID())) continue;
            i.remove();
        }
        return links;
    }
}

