/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.ILinkModificationListener;
import com.arcway.cockpit.frame.client.project.core.links.ILinkedItemDeletionListener;
import com.arcway.cockpit.frame.client.project.core.links.LinkAccessAgent;
import com.arcway.cockpit.frame.client.project.core.links.LinkTypeRegistry;
import com.arcway.cockpit.frame.client.project.core.links.LinkedDataAccessFacadeRegistry;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.LOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linkeddataaccess.ILinkedDataAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkTypeLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.LinkTypeLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.modifications.AddedLinksOfLinkType;
import com.arcway.cockpit.frame.client.project.core.links.modifications.DeletedLinksOfLinkType;
import com.arcway.cockpit.frame.client.project.core.links.modifications.LinkModificationsForProjectView;
import com.arcway.cockpit.frame.client.project.core.locking.ILockManager;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.exceptions.LinkModificationException;
import com.arcway.cockpit.frame.client.project.modules.IModuleLinkManager;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentLinkManager;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.cockpit.frame.shared.message.EOLinkModificationContainer;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LinkManager
implements IPlanAgentLinkManager,
IModuleLinkManager,
IFrameDataManager {
    private static final ILogger logger = Logger.getLogger(LinkManager.class);
    static final int RUNLEVEL_INITIALISATION = 0;
    static final int RUNLEVEL_LOADINGSERVERSTATE = 1;
    static final int RUNLEVEL_LOADINGSAVEDMODIFICATIONS = 2;
    static final int RUNLEVEL_PRODUCTIVE = 3;
    public static final String[] RUNLEVEL_DESCRIPTIONS = new String[]{"Initialisation", "Loading server state", "Loading saved modifications", "Productive"};
    private int runLevel;
    private final ProjectAgent projectAgent;
    private final LinkAccessAgent linkAccessAgent;
    private final LinkTypeRegistry linkTypeRegistry;
    private final LinkedDataAccessFacadeRegistry linkedDataAccessFacadeRegistry;
    private final Collection<ILinkedItemDeletionListener> deletionListeners = new ArrayList<ILinkedItemDeletionListener>();
    private final SetMap<String, ILinkModificationListener> mapLinkTypeID_linkModificationListeners;
    private final SetMap<String, ILinkModificationListener> mapLoTypeID_linkModificationListeners;
    private final SetMap<String, ILinkModificationListener> mapLinkableObjectUID_linkModificationListeners;
    private final SetMap<String, ILinkModificationListener> mapModuleDataUID_linkModificationListeners;

    public LinkManager(ProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.linkTypeRegistry = new LinkTypeRegistry();
        this.linkedDataAccessFacadeRegistry = new LinkedDataAccessFacadeRegistry();
        this.linkAccessAgent = new LinkAccessAgent(this, this.linkTypeRegistry, projectAgent);
        this.mapLinkableObjectUID_linkModificationListeners = new SetMap();
        this.mapLinkTypeID_linkModificationListeners = new SetMap();
        this.mapLoTypeID_linkModificationListeners = new SetMap();
        this.mapModuleDataUID_linkModificationListeners = new SetMap();
        this.runLevel = 0;
    }

    @Override
    public String getLocalizedManagerName() {
        return "Link Manager";
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.checkLinkTypesAndInitialiseLinkAccessAgent();
        this.runLevel = 1;
        this.linkAccessAgent.loadLinksFromServer(serverDataContainer);
        this.runLevel = 2;
        this.linkAccessAgent.loadSavedModifications();
        this.runLevel = 3;
    }

    private void checkLinkTypesAndInitialiseLinkAccessAgent() {
        this.linkAccessAgent.initialize();
        for (ILinkType linkType : this.linkTypeRegistry.getLinkTypes()) {
            if (!this.linkedDataAccessFacadeRegistry.contains(linkType.getModuleDataTypeID())) {
                logger.error("Rejecting link type: " + linkType.getUID() + " No data access facade has been registered for the link start: " + linkType.getModuleDataTypeID());
                this.linkTypeRegistry.removeLinkType(linkType);
                continue;
            }
            if (!this.linkedDataAccessFacadeRegistry.contains(linkType.getLinkableObjectTypeID())) {
                logger.error("Rejecting link type " + linkType.getUID() + " No data access facade has been registered for the link end: " + linkType.getLinkableObjectTypeID());
                this.linkTypeRegistry.removeLinkType(linkType);
                continue;
            }
            this.linkAccessAgent.createLinkStoreForLinkType(linkType);
        }
    }

    @Override
    public void registerLinkedDataAccessFacade(ILinkedDataAccessFacade linkedDataAccessFacade) {
        assert (linkedDataAccessFacade != null) : "p must not be null";
        if (this.runLevel != 0) {
            throw new IllegalStateException("Linked data access facades can not be registered after the link manager initialisation is completed. (Type ID: " + linkedDataAccessFacade.getDataTypeID());
        }
        this.linkedDataAccessFacadeRegistry.addLinkedDataAccessFacade(linkedDataAccessFacade);
    }

    @Override
    public ILinkTypeLinkAccessFacade registerLinkType(ILinkType linkType) {
        assert (linkType != null) : "linkType must not be null";
        if (this.runLevel == 0) {
            this.linkTypeRegistry.addLinkType(linkType);
            return new LinkTypeLinkAccessFacade(this.projectAgent.getProjectUID(), linkType.getModuleID(), linkType, this);
        }
        throw new IllegalStateException("Link types can not be registered after the link manager initialisation is completed. (Link Type ID: " + linkType.getUID());
    }

    @Override
    public void registerTypeTranslation(String virtualTypeID, Collection<String> realTypeIDs) {
        if (this.runLevel != 0) {
            throw new IllegalStateException("Types translations can not be registered after the link manager initialisation is completed. (Virtual Type ID: " + virtualTypeID);
        }
        this.linkTypeRegistry.addTypeTranslationMapping(virtualTypeID, realTypeIDs);
    }

    public Collection<ILinkType> getLinkTypes() {
        return this.linkTypeRegistry.getLinkTypes();
    }

    public ILinkType getLinkType(String linkTypeID) {
        return this.linkTypeRegistry.getLinkTypeByUID(linkTypeID);
    }

    public ILinkType getLinkType(EOLink link) {
        return this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID());
    }

    public Collection<ILinkType> getLinkTypesForLinkableObjectTypeID(String linkableObjectTypeID) {
        return this.linkTypeRegistry.getLinkTypesByLinkableObjectTypeID(linkableObjectTypeID);
    }

    protected ILinkedDataAccessFacade getLinkedDataAccessFacadeForMD(EOLink link) {
        return this.getLinkedDataAccessFacadeForMD(this.getLinkType(link));
    }

    protected ILinkedDataAccessFacade getLinkedDataAccessFacadeForMD(ILinkType linkType) {
        if (linkType != null) {
            return this.linkedDataAccessFacadeRegistry.getLinkedDataAccessFacade(linkType.getModuleDataTypeID());
        }
        return null;
    }

    protected ILinkedDataAccessFacade getLinkedDataAccessFacadeForLO(EOLink link) {
        return this.getLinkedDataAccessFacadeForLO(this.getLinkType(link));
    }

    protected ILinkedDataAccessFacade getLinkedDataAccessFacadeForLO(ILinkType linkType) {
        if (linkType != null) {
            return this.linkedDataAccessFacadeRegistry.getLinkedDataAccessFacade(linkType.getLinkableObjectTypeID());
        }
        return null;
    }

    @Override
    public ILOLinkAccessFacade getLinkableObjectLinkAccessFacade(String dataTypeID) {
        return new LOLinkAccessFacade(dataTypeID, this);
    }

    protected boolean linkableObjectExists(EOLink link, boolean checkOnServerState) {
        assert (link != null) : "link must not be null";
        ILinkedDataAccessFacade linkedDataAccessFacade = this.getLinkedDataAccessFacadeForLO(link);
        if (linkedDataAccessFacade != null) {
            return linkedDataAccessFacade.isLinkedItemExistent(link.getLinkableObjectUID(), checkOnServerState);
        }
        return false;
    }

    protected boolean moduleDataItemExists(EOLink link, boolean checkOnServerState) {
        assert (link != null) : "link must not be null";
        ILinkedDataAccessFacade linkedDataAccessFacade = this.getLinkedDataAccessFacadeForMD(link);
        if (linkedDataAccessFacade != null) {
            return linkedDataAccessFacade.isLinkedItemExistent(link.getModuleDataUID(), checkOnServerState);
        }
        return false;
    }

    @Override
    public ICockpitProjectData getModuleDataItem(EOLink link) {
        assert (link != null) : " link must not be null";
        ILinkedDataAccessFacade facade = this.getLinkedDataAccessFacadeForMD(link);
        return facade.getLinkedItem(link.getModuleDataUID());
    }

    public ICockpitProjectData getLinkableObject(EOLink link) {
        assert (link != null) : "link must not be null";
        ILinkedDataAccessFacade facade = this.getLinkedDataAccessFacadeForLO(link);
        return facade.getLinkedItem(link.getLinkableObjectUID());
    }

    public boolean linkExists(EOLink link) {
        return this.linkAccessAgent.linkExists(link);
    }

    public Set<EOLink> getLinksForLinkableObject(String dataTypeID, String objectUID) {
        assert (dataTypeID != null) : "dataTypeID must not be null";
        assert (objectUID != null) : "objectUID must not be null";
        return this.linkAccessAgent.getLinksForLinkableObject(dataTypeID, objectUID);
    }

    public Set<EOLink> getLinksOfLinkTypeForLinkableObject(ILinkType linkType, String linkableObjectUID) {
        assert (linkType != null) : "linkType must not be null";
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        return this.linkAccessAgent.getLinksOfLinkTypeForLinkableObject(linkType, linkableObjectUID);
    }

    public Set<EOLink> getLinksOfLinkTypeForModuleDataItem(ILinkType linkType, String moduleDataUID) {
        assert (linkType != null) : "value must not be null";
        assert (moduleDataUID != null) : "moduleDataUID must not be null";
        return this.linkAccessAgent.getLinksOfLinkTypeForModuleDataItem(linkType, moduleDataUID);
    }

    public Collection<EOLink> getLinks(ICockpitProjectData moduleDataItem, String linkableObjectTypeID) {
        assert (linkableObjectTypeID != null) : "linkableObjectTypeID must not be null";
        Set<ILinkType> linkTypes = this.linkTypeRegistry.getLinkTypes(linkableObjectTypeID, moduleDataItem.getTypeID());
        HashSet<EOLink> links = new HashSet<EOLink>();
        for (ILinkType linkType : linkTypes) {
            links.addAll(this.getLinksOfLinkTypeForModuleDataItem(linkType, moduleDataItem.getUID()));
        }
        return links;
    }

    public Set<EOLink> getLinks(ILinkType linkType) {
        return this.linkAccessAgent.getAllLinks(linkType);
    }

    public ISetMapWithFixReturnSetsRO<String, EOLink> getLinksMappedByLinkableObjectUID(String linkTypeID) {
        return this.linkAccessAgent.getLinksForLinkTypeMappedByLinkableObjectUID(linkTypeID);
    }

    public Collection<EOLink> getAllLinks() {
        ArrayList<EOLink> links = new ArrayList<EOLink>();
        for (ILinkType linkType : this.getLinkTypes()) {
            links.addAll(this.getLinks(linkType));
        }
        return links;
    }

    public ICockpitProjectData getVersionedLinkableObject(EOLinkLog link) {
        assert (link != null) : "link must not be null";
        ILinkedDataAccessFacade facade = this.getLinkedDataAccessFacadeForLO((EOLink)link);
        return facade.getLinkedItemVersion(link.getLinkableObjectUID(), link.getLinkableObjectVersion());
    }

    public ICockpitProjectData getVersionedModuleData(EOLinkLog link) {
        assert (link != null) : "link must not be null";
        ILinkedDataAccessFacade facade = this.getLinkedDataAccessFacadeForMD((EOLink)link);
        return facade.getLinkedItemVersion(link.getModuleDataUID(), link.getModuleDataVersion());
    }

    public Set<EOLinkLog> getVersionedLinksForLinkableObject(String dataTypeID, String objectUID, int modCount) {
        assert (dataTypeID != null) : "dataTypeID must not be null";
        assert (objectUID != null) : "objectUID must not be null";
        return this.linkAccessAgent.getVersionedLinksForLinkableObject(dataTypeID, objectUID, modCount);
    }

    public Set<EOLinkLog> getVersionedLinksOfLinkTypeForLinkableObject(String linkTypeID, String linkableObjectUID, int modCount) {
        return this.linkAccessAgent.getVersionedLinksOfLinkTypeForLinkableObject(this.linkTypeRegistry.getLinkTypeByUID(linkTypeID), linkableObjectUID, modCount);
    }

    public Set<EOLinkLog> getVersionedLinksOfLinkTypeForModuleDataItem(String linkTypeID, String moduleDataUID, int modCount) {
        return this.linkAccessAgent.getVersionedLinksOfLinkTypeForModuleDataItem(this.linkTypeRegistry.getLinkTypeByUID(linkTypeID), moduleDataUID, modCount);
    }

    public IStatus checkLinkAddition(EOLink link) {
        try {
            this.linkAccessAgent.checkAddition(link, false, false);
        }
        catch (LinkModificationException e) {
            return new Status(4, FramePlugin.getDefault().getPluginID(), e.getReason(), e.getMessage(), (Throwable)e);
        }
        return new Status(0, FramePlugin.getDefault().getPluginID(), 0, "", null);
    }

    public IStatus addLink(EOLink link) {
        try {
            this.acquireLock(link);
        }
        catch (LinkModificationException e) {
            return new Status(4, FramePlugin.getDefault().getPluginID(), e.getReason(), e.getMessage(), (Throwable)e);
        }
        try {
            this.linkAccessAgent.addLink(link);
        }
        catch (LinkModificationException e) {
            return new Status(4, FramePlugin.getDefault().getPluginID(), e.getReason(), e.getMessage(), (Throwable)e);
        }
        this.informLinkModificationListenersOfAddition(Collections.singleton(link), false);
        PropertyChanges changes = new PropertyChanges((Object)link, null, null);
        this.storePropertyChange(changes, EOLink.class);
        return new Status(0, FramePlugin.getDefault().getPluginID(), 0, "", null);
    }

    public Collection<EOLink> addLinks(Collection<EOLink> links) {
        assert (links != null) : "links must not be null";
        Collection<EOLink> lockedLinks = this.acquireLocks(links);
        Collection<EOLink> addedLinks = this.linkAccessAgent.addLinks(lockedLinks);
        this.informLinkModificationListenersOfAddition(addedLinks, false);
        PropertyChanges changes = new PropertyChanges(addedLinks, null, null);
        this.storePropertyChange(changes, EOLink.class);
        return addedLinks;
    }

    public Collection<EOLink> createLinks(final ILinkType linkType, final Collection<String> moduleDataUIDs, final String linkableObjectUID) {
        assert (linkType != null) : "lt must not be null";
        assert (moduleDataUIDs != null) : "moduleDataUIDs must not be null";
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        final HashSet<EOLink> successfullyCreatedLinks = new HashSet<EOLink>();
        this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                for (String moduleDataUID : moduleDataUIDs) {
                    EOLink newLink = new EOLink(LinkManager.this.projectAgent.getProjectUID(), linkableObjectUID, moduleDataUID, linkType.getModuleID(), linkType.getUID());
                    successfullyCreatedLinks.add(newLink);
                }
                LinkManager.this.addLinks(successfullyCreatedLinks);
            }
        });
        this.storePropertyChange(new PropertyChanges(successfullyCreatedLinks, null, null), EOLink.class);
        return successfullyCreatedLinks;
    }

    public Collection<EOLink> createLinks(final ILinkType linkType, final String moduleDataUID, final Collection<String> linkableObjectUIDs) {
        assert (moduleDataUID != null) : "moduleDataUID must not be null";
        assert (linkableObjectUIDs != null) : "linkableObjectUIDs must not be null";
        assert (linkType != null) : "lt must not be null";
        final HashSet<EOLink> successfullyCreatedLinks = new HashSet<EOLink>();
        this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                for (String linkableObjectUID : linkableObjectUIDs) {
                    EOLink newLink = new EOLink(LinkManager.this.projectAgent.getProjectUID(), linkableObjectUID, moduleDataUID, linkType.getModuleID(), linkType.getUID());
                    successfullyCreatedLinks.add(newLink);
                }
                LinkManager.this.addLinks(successfullyCreatedLinks);
            }
        });
        this.storePropertyChange(new PropertyChanges(successfullyCreatedLinks, null, null), EOLink.class);
        return successfullyCreatedLinks;
    }

    public IStatus checkLinkDeletion(EOLink link) {
        try {
            this.linkAccessAgent.checkDeletion(link, false);
        }
        catch (LinkModificationException e) {
            return new Status(4, FramePlugin.getDefault().getPluginID(), e.getReason(), e.getMessage(), (Throwable)e);
        }
        return new Status(0, FramePlugin.getDefault().getPluginID(), 0, "", null);
    }

    public IStatus deleteLink(EOLink link) {
        assert (link != null) : "link must not be null";
        try {
            this.acquireLock(link);
        }
        catch (LinkModificationException e) {
            return new Status(4, FramePlugin.getDefault().getPluginID(), e.getReason(), e.getMessage(), (Throwable)e);
        }
        try {
            this.linkAccessAgent.deleteLink(link);
        }
        catch (LinkModificationException e) {
            return new Status(4, FramePlugin.getDefault().getPluginID(), e.getReason(), e.getMessage(), (Throwable)e);
        }
        this.informLinkModificationListenersOfDeletion(Collections.singleton(link), false);
        PropertyChanges changes = new PropertyChanges(null, null, (Object)link);
        this.storePropertyChange(changes, EOLink.class);
        return new Status(0, FramePlugin.getDefault().getPluginID(), 0, "", null);
    }

    public Collection<EOLink> deleteLinks(Collection<String> linkableObjectUIDs, String moduleDataUID, ILinkType type) {
        ArrayList<EOLink> lockedLinks = new ArrayList<EOLink>(linkableObjectUIDs.size());
        for (String linkableObjectUID : linkableObjectUIDs) {
            EOLink link = new EOLink(this.projectAgent.getProjectUID(), linkableObjectUID, moduleDataUID, type.getModuleID(), type.getUID());
            try {
                this.acquireLock(link);
                lockedLinks.add(link);
            }
            catch (LinkModificationException linkModificationException) {
                // empty catch block
            }
        }
        Collection<EOLink> deletedLinks = this.linkAccessAgent.deleteLinks(lockedLinks);
        this.informLinkModificationListenersOfDeletion(deletedLinks, false);
        this.storePropertyChange(new PropertyChanges(null, null, deletedLinks), EOLink.class);
        return deletedLinks;
    }

    public Collection<EOLink> deleteLinks(String linkableObjectUID, Collection<String> moduleDataUIDs, ILinkType type) {
        LinkedList<EOLink> lockedLinks = new LinkedList<EOLink>();
        for (String moduleDataUID : moduleDataUIDs) {
            EOLink link = new EOLink(this.projectAgent.getProjectUID(), linkableObjectUID, moduleDataUID, type.getModuleID(), type.getUID());
            try {
                this.acquireLock(link);
                lockedLinks.add(link);
            }
            catch (LinkModificationException linkModificationException) {
                // empty catch block
            }
        }
        Collection<EOLink> deletedLinks = this.linkAccessAgent.deleteLinks(lockedLinks);
        this.informLinkModificationListenersOfDeletion(deletedLinks, false);
        this.storePropertyChange(new PropertyChanges(null, null, deletedLinks), EOLink.class);
        return deletedLinks;
    }

    @Override
    public Set<EOLink> linkedItemDeleted(String dataTypeID, ICockpitProjectData object) {
        for (ILinkedItemDeletionListener listener : this.deletionListeners) {
            listener.objectDeleted(object);
        }
        Set<EOLink> links = this.linkAccessAgent.deleteLinksForLinkedItem(object.getUID(), dataTypeID);
        this.informLinkModificationListenersOfDeletion(links, false);
        this.storePropertyChange(new PropertyChanges(null, null, links), EOLink.class);
        return links;
    }

    public IStatus addLinkVersion(EOLinkLog link) {
        try {
            this.linkAccessAgent.addLinkVersion(link);
        }
        catch (LinkModificationException e) {
            return new Status(4, FramePlugin.getDefault().getPluginID(), e.getReason(), e.getMessage(), (Throwable)e);
        }
        return new Status(0, FramePlugin.getDefault().getPluginID(), 0, "", null);
    }

    public void deleteLinkVersion(EOLinkLog link) {
        assert (link != null) : "link must not be null";
        this.linkAccessAgent.deleteLinkVersion(link);
    }

    @Override
    public boolean hasProjectWideChangesForModule(String moduleID) {
        assert (moduleID != null) : "moduleID must not be null";
        for (ILinkType linkType : this.linkTypeRegistry.getLinkTypesByModuleID(moduleID)) {
            if (!this.hasProjectWideChangesForLinkType(linkType.getUID())) continue;
            return true;
        }
        return false;
    }

    private boolean hasProjectWideChangesForLinkType(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        return this.linkAccessAgent.hasUncommitedChangesForProject(linkTypeID);
    }

    public EOList<EOLinkModificationContainer> getProjectWideChangesForModule(String moduleID) {
        assert (moduleID != null) : "moduleID must not be null";
        EOList changes = new EOList();
        for (ILinkType linkType : this.linkTypeRegistry.getLinkTypesByModuleID(moduleID)) {
            changes.addAll(this.getCommitChangesForProject(linkType.getUID()));
        }
        return changes;
    }

    private EOList<EOLinkModificationContainer> getCommitChangesForProject(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        return this.linkAccessAgent.getChangesForProject(linkTypeID);
    }

    public EOList<EOLinkModificationContainer> getCommitChangesForProject() {
        EOList modifications = new EOList();
        modifications.add((EncodableObjectBase)this.linkAccessAgent.getChangesForProject());
        return modifications;
    }

    @Override
    public boolean hasLocalModifications() {
        return this.linkAccessAgent.hasCommitChanges();
    }

    public boolean hasModifiedLink(String dataUID) {
        return this.linkAccessAgent.hasModifiedLink(dataUID);
    }

    public boolean hasModifiedLinks(String linkTypeID) {
        return this.linkAccessAgent.hasModifiedLinks(linkTypeID);
    }

    public void handleServerUpdate(EOList<EOLinkModificationContainer> asynchronousUpdate) {
        assert (asynchronousUpdate != null) : "response must not be null";
        ArrayList<EOLink> addedLinks = new ArrayList<EOLink>();
        ArrayList<EOLink> deletedLinks = new ArrayList<EOLink>();
        this.linkAccessAgent.applyAsynchronousModificationsFromServer(asynchronousUpdate, addedLinks, deletedLinks);
        this.informLinkModificationListenersOfDeletion(deletedLinks, true);
        this.informLinkModificationListenersOfAddition(addedLinks, true);
    }

    public void handleResponse(EOList<EOLinkModificationContainer> commitResponse) {
        this.linkAccessAgent.applySynchronousModificationsFromServer(commitResponse);
    }

    @Override
    public void discardLocalModifications() {
        this.linkAccessAgent.clearLocalModifications();
    }

    private Collection<EOLink> acquireLocks(Collection<EOLink> links) {
        final HashSet<EOLink> successfullyLockedLinks = new HashSet<EOLink>(links);
        assert (this.projectAgent.getModelTransactionManager().isInTransaction());
        this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                Iterator i = successfullyLockedLinks.iterator();
                while (i.hasNext()) {
                    EOLink link = (EOLink)i.next();
                    try {
                        LinkManager.this.acquireLock(link);
                    }
                    catch (LinkModificationException e) {
                        i.remove();
                    }
                }
            }
        });
        return successfullyLockedLinks;
    }

    public LockResult acquireLocksForLinkData(String linkableObjectUID, String moduleDataUID, ILinkType linkType) {
        LockResult lockResult;
        long currentTimeMillis = System.currentTimeMillis();
        String projectUID = this.projectAgent.getProjectUID();
        String linkableObjectTypeID = linkType.getLinkableObjectTypeID();
        String moduleDataTypeID = linkType.getModuleDataTypeID();
        ILinkedDataAccessFacade linkDataAccessFacadeForLO = this.getLinkedDataAccessFacadeForLO(linkType);
        ILinkedDataAccessFacade linkDataAccessFacadeForMD = this.getLinkedDataAccessFacadeForMD(linkType);
        boolean loExistsOnServer = false;
        boolean mdExistsOnServer = false;
        if (linkableObjectUID != null) {
            loExistsOnServer = linkDataAccessFacadeForLO.isLinkedItemExistent(linkableObjectUID, true);
        }
        if (moduleDataUID != null) {
            mdExistsOnServer = linkDataAccessFacadeForMD.isLinkedItemExistent(moduleDataUID, true);
        }
        if (loExistsOnServer || mdExistsOnServer) {
            ArrayList<EOLock> standardLocksToBeChecked = new ArrayList<EOLock>();
            ArrayList<EOLock> standardLocksToBeSet = new ArrayList<EOLock>();
            EOLock linkLockLinkableObject = null;
            EOLock linkLockModuleData = null;
            if (linkableObjectUID != null) {
                EOLock addLockLinkableObject = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "add", linkableObjectUID, linkableObjectTypeID, "", "", new Timestamp(currentTimeMillis));
                EOLock delLockLinkableObject = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "delete", linkableObjectUID, linkableObjectTypeID, "", "", new Timestamp(currentTimeMillis));
                standardLocksToBeChecked.add(delLockLinkableObject);
                standardLocksToBeSet.add(addLockLinkableObject);
                linkLockLinkableObject = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "link_lock_linkable_object", linkableObjectUID, linkableObjectTypeID, "", "", new Timestamp(currentTimeMillis));
            }
            if (moduleDataUID != null) {
                EOLock addLockModuleData = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "add", moduleDataUID, moduleDataTypeID, "", "", new Timestamp(currentTimeMillis));
                EOLock delLockModuleData = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "delete", moduleDataUID, moduleDataTypeID, "", "", new Timestamp(currentTimeMillis));
                if (linkType.isAttributeLinkType()) {
                    EOLock modLockModuleData = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "modify", moduleDataUID, moduleDataTypeID, "", "", new Timestamp(currentTimeMillis));
                    standardLocksToBeSet.add(modLockModuleData);
                }
                standardLocksToBeChecked.add(delLockModuleData);
                standardLocksToBeSet.add(addLockModuleData);
                linkLockModuleData = new EOLock(UUIDGenerator.getUniqueID(), projectUID, "link_lock_module_data", moduleDataUID, moduleDataTypeID, "", "", new Timestamp(currentTimeMillis));
            }
            ILockManager lockMgr = this.projectAgent.getLockManager();
            switch (linkType.getLockingBehaviour()) {
                case 0: {
                    lockResult = lockMgr.atomicCheckAndSetLocks(standardLocksToBeChecked, standardLocksToBeSet, false);
                    break;
                }
                case 1: {
                    ArrayList<EOLock> locksLOToBeChecked = new ArrayList<EOLock>();
                    ArrayList<EOLock> locksLOToBeSet = new ArrayList<EOLock>();
                    locksLOToBeChecked.addAll(standardLocksToBeChecked);
                    locksLOToBeSet.addAll(standardLocksToBeSet);
                    if (linkLockLinkableObject != null) {
                        locksLOToBeChecked.add(linkLockLinkableObject);
                        locksLOToBeSet.add(linkLockLinkableObject);
                    }
                    lockResult = lockMgr.atomicCheckAndSetLocks(locksLOToBeChecked, locksLOToBeSet, false);
                    break;
                }
                case 2: {
                    ArrayList<EOLock> locksMDToBeChecked = new ArrayList<EOLock>();
                    ArrayList<EOLock> locksMDToBeSet = new ArrayList<EOLock>();
                    locksMDToBeChecked.addAll(standardLocksToBeChecked);
                    locksMDToBeSet.addAll(standardLocksToBeSet);
                    if (linkLockModuleData != null) {
                        locksMDToBeChecked.add(linkLockModuleData);
                        locksMDToBeSet.add(linkLockModuleData);
                    }
                    lockResult = lockMgr.atomicCheckAndSetLocks(locksMDToBeChecked, locksMDToBeSet, false);
                    break;
                }
                case 3: {
                    ArrayList<EOLock> bothEndsLocksToBeChecked = new ArrayList<EOLock>();
                    ArrayList<EOLock> bothEndsLocksToBeSet = new ArrayList<EOLock>();
                    bothEndsLocksToBeChecked.addAll(standardLocksToBeChecked);
                    bothEndsLocksToBeSet.addAll(standardLocksToBeSet);
                    if (linkLockLinkableObject != null) {
                        bothEndsLocksToBeChecked.add(linkLockLinkableObject);
                        bothEndsLocksToBeSet.add(linkLockLinkableObject);
                    }
                    if (linkLockModuleData != null) {
                        bothEndsLocksToBeChecked.add(linkLockModuleData);
                        bothEndsLocksToBeSet.add(linkLockModuleData);
                    }
                    lockResult = lockMgr.atomicCheckAndSetLocks(bothEndsLocksToBeChecked, bothEndsLocksToBeSet, false);
                    break;
                }
                default: {
                    logger.warn("Unknown locking behaviour for link type: " + linkType.getUID());
                    lockResult = new LockResult(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
                    break;
                }
            }
        } else {
            lockResult = new LockResult(true, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
        }
        return lockResult;
    }

    private void acquireLock(EOLink link) throws LinkModificationException {
        String moduleDataUID;
        assert (link != null) : "link must not be null";
        ILinkType linkType = this.getLinkType(link);
        String linkableObjectUID = link.getLinkableObjectUID();
        LockResult lockResult = this.acquireLocksForLinkData(linkableObjectUID, moduleDataUID = link.getModuleDataUID(), linkType);
        if (!lockResult.wasSuccessful()) {
            throw new LinkModificationException(link, 3, 3, this.getRunLevel());
        }
    }

    @Override
    public void addLinkModificationListenerForLinkType(ILinkModificationListener listener, String linkTypeID) {
        this.mapLinkTypeID_linkModificationListeners.add((Object)linkTypeID, (Object)listener);
    }

    public void addLinkModificationListenerForLODataType(ILinkModificationListener listener, String LOCockpitTypeID) {
        this.mapLoTypeID_linkModificationListeners.add((Object)LOCockpitTypeID, (Object)listener);
    }

    public void addLinkModificationListenerForLinkableObject(ILinkModificationListener listener, String linkableObjectUID) {
        this.mapLinkableObjectUID_linkModificationListeners.add((Object)linkableObjectUID, (Object)listener);
    }

    public void addLinkModificationListenerForModuleDataItem(ILinkModificationListener listener, String moduleDataUID) {
        this.mapModuleDataUID_linkModificationListeners.add((Object)moduleDataUID, (Object)listener);
    }

    public void addLinkedItemDeletionListener(ILinkedItemDeletionListener listener) {
        if (!this.deletionListeners.contains(listener)) {
            this.deletionListeners.add(listener);
        }
    }

    private void informLinkModificationListenersOfAddition(Collection<EOLink> links, boolean isDuringServerUpdate) {
        this.informLinkModificationListeners_internal(links, isDuringServerUpdate, Caller.LinksAddedCaller);
    }

    private void informLinkModificationListenersOfDeletion(Collection<EOLink> links, boolean isDuringServerUpdate) {
        this.informLinkModificationListeners_internal(links, isDuringServerUpdate, Caller.LinksDeletedCaller);
    }

    private void informLinkModificationListeners_internal(Collection<EOLink> links, boolean isDuringServerUpdate, Caller caller) {
        Set addedLinks;
        SetMap linkType_links = new SetMap();
        SetMap loTypeID_links = new SetMap();
        SetMap linkableObjectUID_links = new SetMap();
        SetMap moduleDataUID_links = new SetMap();
        for (EOLink link : links) {
            linkType_links.add((Object)link.getLinkTypeID(), (Object)link);
            loTypeID_links.add((Object)this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()).getLinkableObjectTypeID(), (Object)link);
            linkableObjectUID_links.add((Object)link.getLinkableObjectUID(), (Object)link);
            moduleDataUID_links.add((Object)link.getModuleDataUID(), (Object)link);
        }
        for (String linkTypeID : linkType_links.keySet()) {
            addedLinks = linkType_links.get((Object)linkTypeID);
            for (ILinkModificationListener listener : this.mapLinkTypeID_linkModificationListeners.get((Object)linkTypeID)) {
                if (isDuringServerUpdate && !listener.informDuringServerUpdate()) continue;
                caller.callListener(listener, addedLinks);
            }
        }
        for (String LOTypeID : loTypeID_links.keySet()) {
            addedLinks = loTypeID_links.get((Object)LOTypeID);
            for (ILinkModificationListener listener : this.mapLoTypeID_linkModificationListeners.get((Object)LOTypeID)) {
                if (isDuringServerUpdate && !listener.informDuringServerUpdate()) continue;
                caller.callListener(listener, addedLinks);
            }
        }
        for (String linkableObjectUID : linkableObjectUID_links.keySet()) {
            addedLinks = linkableObjectUID_links.get((Object)linkableObjectUID);
            for (ILinkModificationListener listener : this.mapLinkableObjectUID_linkModificationListeners.get((Object)linkableObjectUID)) {
                if (isDuringServerUpdate && !listener.informDuringServerUpdate()) continue;
                caller.callListener(listener, addedLinks);
            }
        }
        for (String moduleDataUID : moduleDataUID_links.keySet()) {
            addedLinks = moduleDataUID_links.get((Object)moduleDataUID);
            for (ILinkModificationListener listener : this.mapModuleDataUID_linkModificationListeners.get((Object)moduleDataUID)) {
                if (isDuringServerUpdate && !listener.informDuringServerUpdate()) continue;
                caller.callListener(listener, addedLinks);
            }
        }
    }

    private <T> void storePropertyChange(PropertyChanges<? extends T> changes, Class<T> clazz) {
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed(changes, clazz);
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return false;
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        return null;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        return null;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        if (displayableOnly) {
            EOLinkModificationContainer changes = this.linkAccessAgent.getChangesForProject();
            Map<String, Integer> map_linkTypeID_numberOfAddedLinks = this.getLinkChangesMappedByLinkType((List<? extends EOLink>)changes.getInsertLinks());
            IAddedItem[] additions = new IAddedItem[map_linkTypeID_numberOfAddedLinks.keySet().size()];
            int index = 0;
            for (Map.Entry<String, Integer> entry : map_linkTypeID_numberOfAddedLinks.entrySet()) {
                ILinkType linkType = this.linkTypeRegistry.getLinkTypeByUID(entry.getKey());
                AddedLinksOfLinkType addedItem = new AddedLinksOfLinkType(linkType.getDisplayName(), entry.getValue());
                additions[index] = addedItem;
                ++index;
            }
            Map<String, Integer> map_linkTypeID_numberOfDeletedLinks = this.getLinkChangesMappedByLinkType((List<? extends EOLink>)changes.getDeleteLinks());
            IDeletedItem[] deletions = new IDeletedItem[map_linkTypeID_numberOfDeletedLinks.keySet().size()];
            index = 0;
            for (Map.Entry<String, Integer> entry : map_linkTypeID_numberOfDeletedLinks.entrySet()) {
                ILinkType linkType = this.linkTypeRegistry.getLinkTypeByUID(entry.getKey());
                DeletedLinksOfLinkType deletedItem = new DeletedLinksOfLinkType(linkType.getDisplayName(), entry.getValue());
                deletions[index] = deletedItem;
                ++index;
            }
            return new ILocalModificationContainer[]{new LinkModificationsForProjectView(additions, deletions)};
        }
        return null;
    }

    private Map<String, Integer> getLinkChangesMappedByLinkType(List<? extends EOLink> changes) {
        HashMap<String, Integer> map_linkTypeID_numberOfAddedLinks = new HashMap<String, Integer>();
        for (EOLink eOLink : changes) {
            String linkTypeID = eOLink.getLinkTypeID();
            ILinkType linkType = this.linkTypeRegistry.getLinkTypeByUID(linkTypeID);
            if (!linkType.isModificationToBeDisplayedToTheUser()) continue;
            Integer linkNr = (Integer)map_linkTypeID_numberOfAddedLinks.get(linkTypeID);
            linkNr = linkNr != null ? Integer.valueOf(linkNr + 1) : Integer.valueOf(1);
            map_linkTypeID_numberOfAddedLinks.put(linkTypeID, linkNr);
        }
        return map_linkTypeID_numberOfAddedLinks;
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        return null;
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        return null;
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        return null;
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        return null;
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        return null;
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        return null;
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        return false;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
    }

    @Override
    public void dataModified(IAttributeOwner attributeOwner) {
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        return null;
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        return false;
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        return false;
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        return null;
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        return null;
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return null;
    }

    private static interface Caller {
        public static final Caller LinksAddedCaller = new Caller(){

            @Override
            public void callListener(ILinkModificationListener listener, Set<EOLink> links) {
                listener.linksAdded(links);
            }
        };
        public static final Caller LinksDeletedCaller = new Caller(){

            @Override
            public void callListener(ILinkModificationListener listener, Set<EOLink> links) {
                listener.linksDeleted(links);
            }
        };

        public void callListener(ILinkModificationListener var1, Set<EOLink> var2);
    }
}

