/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.AttributeIntegerFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.IntegerAttributeFilter;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import de.plans.lib.util.IntegerVerifyListener;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EOInteger;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DataTypeInteger
extends AbstractDataType {
    private static DataTypeInteger singleInstance;

    public static DataTypeInteger getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new DataTypeInteger();
        }
        return singleInstance;
    }

    private DataTypeInteger() {
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        return value instanceof Integer;
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        if (!this.supportsValue(originalValue, valueRange)) {
            throw new ExInvalidDataType(originalValue.getClass().toString(), Integer.class.toString());
        }
        Integer integer = (Integer)originalValue;
        return new Integer(integer);
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return Messages.getString("DataTypeInteger.integer", locale);
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) throws ExInvalidDataType {
        if (!(value instanceof Integer)) {
            throw new ExInvalidDataType(value.getClass().toString(), this.getDisplayName());
        }
        return new EOInteger((Integer)value);
    }

    public Object getEOAsValue(EOEncodableObject eo) throws ExInvalidDataType {
        if (!(eo instanceof EOInteger)) {
            throw new ExInvalidDataType(eo.getClass().toString(), EOInteger.class.toString());
        }
        EOInteger eoInteger = (EOInteger)eo;
        return eoInteger.getInteger();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DataTypeInteger;
    }

    @Override
    protected AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        final Text text = new Text(parent, 2048);
        text.addVerifyListener((VerifyListener)new IntegerVerifyListener(text, false));
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        text.setLayoutData((Object)gridData);
        Integer integer = (Integer)initialValue;
        String intString = String.valueOf(integer);
        text.setText(intString);
        text.selectAll();
        final AbstractDataType.SWTControlForModification wrapper = new AbstractDataType.SWTControlForModification(this, (Control)text, null);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataTypeInteger.this.informSWTModifyListeners(wrapper, DataTypeInteger.this.getAttributeValueFromSWTControl(text), null);
            }
        });
        return wrapper;
    }

    private Object getAttributeValueFromSWTControl(Text text) throws ExInvalidDataType {
        String content = text.getText();
        String minus = new String(new char[]{'-'});
        String strDoubleMinus = String.valueOf(minus) + minus;
        int index = content.indexOf(strDoubleMinus);
        while (index > -1) {
            content = String.valueOf(content.substring(0, index)) + content.substring(index + 1);
            index = content.indexOf(strDoubleMinus);
        }
        if (content.equals("") || content.equals(minus)) {
            return new Integer(0);
        }
        return new Integer(content);
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) throws ExInvalidDataType {
        StyledText text = new StyledText(parent, 0);
        text.setText(this.getValueAsSingleLineString(value, valueRange, "", Locale.getDefault()));
        text.setEditable(false);
        return text;
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        if (!(value instanceof Integer)) {
            throw new ExInvalidDataType(value.getClass().toString(), Integer.class.toString());
        }
        Integer integer = (Integer)value;
        return integer.toString();
    }

    public Object getDefaultValue() {
        return new Integer(0);
    }

    public IValueRangeDefiner getValueRangeHelper() {
        return null;
    }

    public String getID() {
        return "integer";
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Comparator getComparator(IValueRange valueRange) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    Integer i1 = (Integer)o1;
                    Integer i2 = (Integer)o2;
                    return i1 - i2;
                }
                catch (ClassCastException e) {
                    return 0;
                }
            }
        };
    }

    @Override
    public IFilterItem createFilterItem(String filterName, AbstractFilter filter, IValueRange vaueRange) {
        return new AttributeIntegerFilterItem(filterName, filter, this);
    }

    @Override
    public IAttributeFilter getFilter() {
        return IntegerAttributeFilter.getDefault();
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        try {
            return new Integer(Integer.parseInt(valueAsString));
        }
        catch (NumberFormatException pE) {
            return null;
        }
    }
}

