/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core;

import com.arcway.cockpit.client.base.interfaces.frame.ICommitAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IItemToCommit;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IUniqueElementRelationshipManager;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.ModificationCommentDialog;
import com.arcway.cockpit.frame.client.project.core.PropertyChange_AsynchronousUpdateFinished;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.DataManager;
import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.locking.LockMgr;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderManager;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementMgr;
import com.arcway.cockpit.frame.client.project.modules.ModuleController;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineMode;
import com.arcway.cockpit.frame.client.project.sequences.SequencerManager;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOCommit;
import com.arcway.cockpit.frame.shared.message.EOFileModification;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.cockpit.frame.shared.message.EOLinkModificationContainer;
import com.arcway.cockpit.frame.shared.message.EOPlan;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.EOSectionAndPlanModifications;
import com.arcway.cockpit.frame.shared.message.EOStakeholderModification;
import com.arcway.cockpit.frame.shared.message.EOUniqueElement;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementModification;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationshipModification;
import com.arcway.cockpit.frame.shared.message.FrameMessageIDs;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.EOUserDefinedAttributeTypesModification;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.cockpitadapter.EOCommitCountAndCommitInformation;
import com.arcway.repository.cockpitadapter.EOCommitInformation;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOException;
import de.plans.psc.shared.message.EONotification;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CommitMgr {
    private static final ILogger logger = Logger.getLogger(CommitMgr.class);
    private static final int AsynchronousUpdatesSuspendCountInitialValue = 0;
    private IFrameProjectAgent projectAgent;
    private ModuleController moduleController;
    private UniqueElementMgr uniqueElementMgr;
    private StakeholderManager stakeholderManager;
    private IUniqueElementRelationshipManager uniqueElementRelationshipMgr;
    private SectionManager sectionMgr;
    private IFrameServerProxy serverProxy;
    private LockMgr lockMgr;
    private LinkManager linkManager;
    private INotificationBusListener notificationListener;
    private boolean asynchronousUpdatesDeliveryStarted = false;
    private int asynchronousUpdatesSuspendCount = 0;
    private final LinkedList<EOCommit> unappliedAsynchronousUpdates = new LinkedList();
    private EOCommit asynchronousUpdateAboutToBeApplied = null;
    private boolean serverSideListenersPossiblyRegistered = false;
    private String notificationTypeForAsyncUpdates;
    private EONotification notificationForCommitVersionListenerOnServer;

    public void construct(IFrameProjectAgent p_projectAgent, ModuleController newModuleController, UniqueElementMgr newUniqueElementMgr, SectionManager newSectionMgr, IFrameServerProxy newServerProxy, LockMgr newLockMgr, LinkManager newLinkManager, StakeholderManager newStakeholderManager) {
        this.projectAgent = p_projectAgent;
        this.moduleController = newModuleController;
        this.uniqueElementMgr = newUniqueElementMgr;
        this.stakeholderManager = newStakeholderManager;
        this.sectionMgr = newSectionMgr;
        this.serverProxy = newServerProxy;
        this.lockMgr = newLockMgr;
        this.linkManager = newLinkManager;
        this.uniqueElementRelationshipMgr = p_projectAgent.getUniqueElementRelationshipManager();
        String projectUID = this.projectAgent.getProjectUID();
        this.notificationTypeForAsyncUpdates = FrameMessageIDs.getProjectSpecificNotificationID((String)"ac1.frame.serverupdate", (String)projectUID);
        String commitVersionListenerNotificationID = FrameMessageIDs.getProjectSpecificNotificationID((String)"cockpit.commit.version.update", (String)projectUID);
        this.notificationForCommitVersionListenerOnServer = new EONotification(commitVersionListenerNotificationID, (EncodableObjectBase)new EOString(projectUID));
        this.notificationListener = new INotificationBusListener(){

            public void receiveNotification(Notification notification) {
                EOCommit commitResponse;
                Object parameter = notification.getParameter();
                if (notification.getType().equals(CommitMgr.this.notificationTypeForAsyncUpdates) && parameter instanceof EOCommit && (commitResponse = (EOCommit)parameter).getProjectUID().equals(CommitMgr.this.projectAgent.getProjectUID())) {
                    Display display = Display.getDefault();
                    if (display.getThread() == Thread.currentThread()) {
                        CommitMgr.this.applyAsynchronousModificationsOnClient(commitResponse);
                    } else {
                        display.asyncExec((Runnable)new PerformAsynchronousChangesOnClientRequest(commitResponse));
                    }
                }
            }
        };
    }

    public void destroy() {
        if (this.serverSideListenersPossiblyRegistered) {
            this.serverSideListenersPossiblyRegistered = false;
            try {
                this.serverProxy.sendRequest("frame.lock", "frame.unsubscribeCVL", (EncodableObjectBase)this.notificationForCommitVersionListenerOnServer);
            }
            catch (ServerNotAvailableException serverNotAvailableException) {
            }
            catch (LoginCanceledException loginCanceledException) {
            }
            catch (EXServerException e) {
                logger.debug("Could not deregister listeners on server due to EXServerException.", (Throwable)e);
            }
            catch (UnknownServerException e) {
            }
            catch (EXOfflineMode e) {
                // empty catch block
            }
            try {
                this.serverProxy.unsubscribeListenerOnServer(this.notificationListener, this.notificationTypeForAsyncUpdates);
            }
            catch (ServerNotAvailableException e) {
            }
            catch (LoginCanceledException e) {
            }
            catch (EXServerException e) {
                logger.debug("Could not deregister listeners on server due to EXServerException.", (Throwable)e);
            }
            catch (UnknownServerException unknownServerException) {
                // empty catch block
            }
            PSCClientServiceFacade.getFacade().deliverAsynchronousUpdatesNow(this.projectAgent.getServerID());
            if (logger.isDebugEnabled()) {
                logger.debug("destroy() - Deregistered for server updates of project " + this.projectAgent.getProjectUID());
            }
        }
    }

    public boolean commitProject(final String modificationComment, final boolean serverProxyIsPrepared, final boolean useDefaultDestination, final Shell shell) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        final boolean[] success = new boolean[1];
        boolean successFullySaved = this.projectAgent.saveAllEditors(shell, Messages.getString("CommitMgr.In_order_to_upload_changes_all_plans_need_to_be_saved._6"), true, true, false);
        if (successFullySaved) {
            this.projectAgent.getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new ICommitAgent(){

                public void performCommit() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                success[0] = CommitMgr.this.commitDataSectionsAndPlans(modificationComment, serverProxyIsPrepared, useDefaultDestination, shell, monitor);
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
                    progressDialog.setOpenOnRun(true);
                    try {
                        progressDialog.run(false, false, runnable);
                    }
                    catch (InvocationTargetException e) {
                        Throwable th = e.getTargetException();
                        if (th instanceof ServerNotAvailableException) {
                            throw (ServerNotAvailableException)th;
                        }
                        if (th instanceof EXServerException) {
                            throw (EXServerException)th;
                        }
                        if (th instanceof LoginCanceledException) {
                            throw (LoginCanceledException)th;
                        }
                        if (th instanceof UnknownServerException) {
                            throw (UnknownServerException)th;
                        }
                        if (th instanceof ExPrematureEndOfTransfer) {
                            throw (ExPrematureEndOfTransfer)th;
                        }
                        logger.warn("Unknown exception thrown. [CommitMgr - commitProject]", th);
                    }
                    catch (InterruptedException e) {
                        logger.error("Commit failed.", (Throwable)e);
                    }
                    progressDialog.getProgressMonitor().done();
                }
            });
        } else {
            String serverID = this.projectAgent.getServerID();
            IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
            String commitLabel = projectMgrServerProxy.getVersionDependendDescription("commitlabel");
            MessageDialog msgDialog = new MessageDialog(shell, commitLabel, Icons.getArcWayLogo(), NLS.bind((String)Messages.getString("CommitMgr.CommitAborted.NotAllEditorsSaved"), (Object)commitLabel), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            msgDialog.open();
        }
        return success[0];
    }

    private boolean commitDataSectionsAndPlans(String forcedModificationComment, boolean serverProxyIsPrepared, boolean useDefaultDestination, Shell shell, IProgressMonitor monitor) throws ExPrematureEndOfTransfer, ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        boolean success = true;
        this.serverProxy.refreshProject();
        if (serverProxyIsPrepared || this.serverProxy.prepareCommit(useDefaultDestination, shell)) {
            ModificationCommentDialog dialog;
            int answer;
            String modificationComment = forcedModificationComment == null ? (this.serverProxy.supportsVersioning() ? ((answer = (dialog = new ModificationCommentDialog(shell)).open()) == 0 ? dialog.getComment() : null) : "") : forcedModificationComment;
            if (modificationComment != null) {
                String serverID = this.projectAgent.getServerID();
                IProjectManagerServerProxy projectMgrServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
                String commitLabel = projectMgrServerProxy.getVersionDependendDescription("commitlabel");
                JFaceProgressMonitorToProgressDisplayAdapter pDisplay = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                pDisplay.beginQuantifiedTask(commitLabel, 100, false);
                pDisplay.reportQuantifiedProgress(0, Messages.getString("CommitMgr.Commit.FileUpload"));
                EOFileModification fileModification = this.projectAgent.getFilesManager().getLocalModificationsForCommit();
                pDisplay.reportQuantifiedProgress(50, Messages.getString("CommitMgr.Commit.CollectModifications"));
                EOProject modifiedProject = this.projectAgent.getProjectMetaDataManager().getLocalModification();
                EOUserDefinedAttributeTypesModification userDefinedAttributeTypesModification = this.projectAgent.getFrameUserDefinedAttributeTypesManager().getUserDefinedAttributeTypesModification();
                EOFrameDataModification objectTypeCategoryCreateAndUpdateModifications = this.projectAgent.getObjectTypeCategoriesManager().getCreationAndModificationChangesForCommit();
                EOFrameDataModification objectTypeCategoryDeleteModifications = this.projectAgent.getObjectTypeCategoriesManager().getDeletionChangesForCommit();
                EOUniqueElementModification uniqueElementsModification = this.uniqueElementMgr.getModification();
                EOStakeholderModification stakeholders = this.stakeholderManager.getModification(false);
                EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>> createdAndModifiedModuleDataChanges = this.moduleController.getCreatedOrModifiedDataChanges();
                EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>> deletedModuleDataChanges = this.moduleController.getDeletedDataChanges();
                EOList<EOLinkModificationContainer> modifiedLinks = this.linkManager.getCommitChangesForProject();
                EOSectionAndPlanModifications sectionAndPlanModifications = this.sectionMgr.getModificationsToCommit();
                EOList uniqueElementRelationshipModifications = new EOList();
                for (EOPlan eoPlan : sectionAndPlanModifications.getAllExistingAndModifiedPlans()) {
                    EOList<EOUniqueElementRelationship> relationships = this.uniqueElementRelationshipMgr.getModifiedUniqueElementRelationshipsForPlan(eoPlan.getUID());
                    if (relationships == null) continue;
                    EOUniqueElementRelationshipModification urMod = new EOUniqueElementRelationshipModification();
                    urMod.setPlan((EOFrameData)eoPlan);
                    urMod.setRelationships(relationships);
                    uniqueElementRelationshipModifications.add((EncodableObjectBase)urMod);
                }
                pDisplay.reportQuantifiedProgress(60, Messages.getString("CommitMgr.Commit.CreateCommitDataForServer"));
                EOCommitInformation commitInformation = new EOCommitInformation(UUIDGenerator.getUniqueID(), new Date(System.currentTimeMillis()), this.projectAgent.getCockpitController().getWorkspaceInformation().getLastUserInformation(), modificationComment);
                EOCommit projectModifications = new EOCommit(new EOCommitCountAndCommitInformation(1, commitInformation), this.projectAgent.getCockpitController().getWorkspaceInformation(), this.projectAgent.getProjectUID(), null);
                if (modifiedProject != null) {
                    projectModifications.setModifiedProject(modifiedProject);
                }
                ListIterator<? extends IFrameDataManager> i = this.projectAgent.getDataManagers().listIterator();
                while (i.hasNext()) {
                    IFrameDataManager dataManager = (IFrameDataManager)i.next();
                    if (!(dataManager instanceof DataManager)) continue;
                    ILocalModificationContainer[] modItems = dataManager.getLocalModifications(false);
                    EOList<EOFrameDataModification<EOFrameData>> commitData = this.getCommitData(modItems);
                    projectModifications.addFrameDataModifications(commitData);
                }
                projectModifications.setFileModification(fileModification);
                projectModifications.setUserDefinedAttributeTypesModification(userDefinedAttributeTypesModification);
                projectModifications.setObjectTypeCategoryModifications(objectTypeCategoryCreateAndUpdateModifications, objectTypeCategoryDeleteModifications);
                projectModifications.setUniqueElementModification(uniqueElementsModification);
                projectModifications.setCreatedOrModifiedModuleDataChanges(createdAndModifiedModuleDataChanges);
                projectModifications.setDeletedModuleDataChanges(deletedModuleDataChanges);
                projectModifications.setSectionAndPlanChanges(sectionAndPlanModifications);
                projectModifications.setUniqueElementRelationshipModifications(uniqueElementRelationshipModifications);
                projectModifications.setLinkModifications(modifiedLinks);
                projectModifications.setStakeholderModification(stakeholders);
                pDisplay.reportQuantifiedProgress(70, NLS.bind((String)Messages.getString("CommitMgr.Commit.FinishCommitProcess"), (Object)commitLabel));
                this.finishCommitProcess(projectModifications, shell);
                pDisplay.reportQuantifiedProgress(100, NLS.bind((String)Messages.getString("CommitMgr.Commit.Finished"), (Object)commitLabel));
                pDisplay.endTask();
            } else {
                success = false;
            }
        } else {
            success = false;
        }
        return success;
    }

    private EOList<EOFrameDataModification<EOFrameData>> getCommitData(ILocalModificationContainer[] modItems) {
        EOList commitData = new EOList();
        ILocalModificationContainer[] iLocalModificationContainerArray = modItems;
        int n = modItems.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalModificationContainer item = iLocalModificationContainerArray[n2];
            IAddedItem[] addedItems = item.getAddedItems();
            IModifiedItem[] modifiedItems = item.getModifiedItems();
            IDeletedItem[] deletedItems = item.getDeletedItems();
            EOList<EOFrameData> eoAdded = this.getEOs((IItemToCommit[])addedItems);
            EOList<EOFrameData> eoModified = this.getEOs((IItemToCommit[])modifiedItems);
            EOList<EOFrameData> eoDeleted = this.getEOs((IItemToCommit[])deletedItems);
            EOFrameDataModification mod = new EOFrameDataModification(item.getTypeIDOfContainedData(), eoAdded, eoModified, eoDeleted);
            commitData.add((EncodableObjectBase)mod);
            ++n2;
        }
        return commitData;
    }

    private EOList<EOFrameData> getEOs(IItemToCommit[] itemsToCommit) {
        EOList eos = new EOList();
        IItemToCommit[] iItemToCommitArray = itemsToCommit;
        int n = itemsToCommit.length;
        int n2 = 0;
        while (n2 < n) {
            IItemToCommit item = iItemToCommitArray[n2];
            IFrameDataRW frameData = (IFrameDataRW)item.getData();
            eos.add((EncodableObjectBase)frameData.createEncodableObject());
            ++n2;
        }
        return eos;
    }

    public boolean isCommitable(IPlan plan) {
        assert (plan != null) : "plan can't be null!";
        if (this.projectAgent.getFrameServerProxy().isCommitable() && this.sectionMgr.isModified(plan)) {
            logger.debug(21, String.valueOf(Messages.getString("CommitMgr._nPlan___17")) + plan.getPlanName() + Messages.getString("CommitMgr._is_commitable._nThe_plan_object_is_marked_as_modified_in_the_section_modificatin_mgr._18"));
            return true;
        }
        return false;
    }

    public boolean areModificationsPresent() {
        for (IFrameDataManager iFrameDataManager : this.projectAgent.getDataManagers()) {
            if (!iFrameDataManager.hasLocalModifications()) continue;
            return true;
        }
        return false;
    }

    public boolean isCommitable(ISection section) {
        assert (section != null) : "section can't be null!";
        if (this.projectAgent.getFrameServerProxy().isCommitable()) {
            if (this.sectionMgr.isModified(section)) {
                return true;
            }
            for (IPlan iPlan : this.sectionMgr.getChildPlans(section)) {
                if (!this.isCommitable(iPlan)) continue;
                return true;
            }
            for (ISection iSection : this.sectionMgr.getChildSections(section)) {
                if (!this.isCommitable(iSection)) continue;
                return true;
            }
        }
        return false;
    }

    protected void applySynchronousModificationsOnClient(EOCommit commitedModifications) {
        assert (commitedModifications != null) : "commit can't be null";
        EOException serverException = commitedModifications.getException();
        if (serverException != null) {
            EXServerException exServerException = new EXServerException(serverException);
            if (logger.isDebugEnabled()) {
                logger.debug("applySynchronousModificationsOnClient() - An Exception occured during the commit process: exception = " + exServerException.getLocalizedMessage(), (Throwable)exServerException);
            }
            PSCServices.getServiceFacade().showException((Exception)((Object)exServerException), this.projectAgent.getServerID());
            return;
        }
        EOProject modifiedProject = commitedModifications.getModifiedProject();
        EOFileModification fileModification = commitedModifications.getFileModification();
        EOUserDefinedAttributeTypesModification userDefinedAttributeTypesModification = commitedModifications.getUserDefinedAttributeTypesModification();
        EOFrameDataModification objectTypeCategoryCreateAndUpdateModifications = commitedModifications.getObjectTypeCategoryCreateAndUpdateModifications();
        EOFrameDataModification objectTypeCategoryDeleteModifications = commitedModifications.getObjectTypeCategoryDeleteModifications();
        EOUniqueElementModification uniqueElementModification = commitedModifications.getUniqueElementModification();
        EOList createdOrModifiedModuleChanges = commitedModifications.getCreatedOrModifiedModuleDataChanges();
        EOList linkModifications = commitedModifications.getLinkModifications();
        EOSectionAndPlanModifications sectionAndPlanModifications = commitedModifications.getSectionAndPlanChanges();
        EOList uniqueElementRelationshipModifications = commitedModifications.getUniqueElementRelationshipModification();
        EOList deletedModuleChanges = commitedModifications.getDeletedModuleDataChanges();
        EOStakeholderModification stakeholderModification = commitedModifications.getStakeholderModification();
        if (modifiedProject != null) {
            this.projectAgent.getProjectMetaDataManager().applySynchronousModification(modifiedProject);
        }
        if (fileModification != null) {
            this.projectAgent.getFilesManager().dataCommitted(fileModification);
        }
        this.projectAgent.getFrameUserDefinedAttributeTypesManager().applySynchronousModifications(userDefinedAttributeTypesModification);
        this.projectAgent.getObjectTypeCategoriesManager().handleCommitResponse(objectTypeCategoryCreateAndUpdateModifications);
        this.projectAgent.getObjectTypeCategoriesManager().handleCommitResponse(objectTypeCategoryDeleteModifications);
        this.projectAgent.getObjectTypeCategoriesManager().finishCommit();
        this.uniqueElementMgr.applySynchronousUniqueElementModificationsExceptDeletions(uniqueElementModification);
        this.moduleController.distributeSynchronousResponses((EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>>)createdOrModifiedModuleChanges);
        if (sectionAndPlanModifications == null) {
            logger.error("The section and plan modifications contained in the server response were null.");
        } else {
            this.sectionMgr.applySynchronousModifications(sectionAndPlanModifications);
        }
        this.uniqueElementRelationshipMgr.applySynchronousUniqueElementRelationshipChanges((Collection<EOUniqueElementRelationshipModification>)uniqueElementRelationshipModifications);
        for (EOFrameDataModification frameDataModification : commitedModifications.getFrameDataModifications()) {
            IFrameDataManager dataManager = this.projectAgent.getDataManager(frameDataModification.getRole());
            if (dataManager == null) continue;
            dataManager.applySynchronousModification((EOFrameDataModification<? extends EOCockpitProjectData>)frameDataModification);
        }
        this.moduleController.distributeSynchronousResponses((EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>>)deletedModuleChanges);
        this.moduleController.finishSynchronousResponse();
        if (uniqueElementModification != null) {
            this.uniqueElementMgr.applySynchronousUniqueElementDeletions((List<EOUniqueElement>)uniqueElementModification.getDeletedUniqueElements());
        }
        this.linkManager.handleResponse((EOList<EOLinkModificationContainer>)linkModifications);
        this.stakeholderManager.applySynchronousUpdates(stakeholderModification);
        this.projectAgent.getCockpitController().applySynchronousModification(commitedModifications.getCommitInformation(), (EOList<EOPlatformLock>)commitedModifications.getPlatformLockLogs());
        this.lockMgr.releaseAllLocks();
    }

    private void applyAsynchronousModificationsOnClient(EOCommit commitedModifications) {
        assert (commitedModifications != null);
        this.unappliedAsynchronousUpdates.add(commitedModifications);
        if (!this.asynchronousUpdatesDeliveryStarted || this.asynchronousUpdatesSuspendCount != 0) {
            logger.debug(20, "Asynchronous Update message enqueued for later applying!", (Throwable)new Exception());
        }
        this.deliverPendingAsynchronousUpdatesIfAdmissible();
    }

    private void immediatelyApplyAsynchronousModificationsOnClient(final EOCommit asynchronousUpdateModifications) {
        assert (asynchronousUpdateModifications != null);
        this.projectAgent.getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                logger.debug(20, "Applying Asynchronous Update message!");
                EOException serverException = asynchronousUpdateModifications.getException();
                if (serverException != null) {
                    logger.debug("applyAsynchronousModificationsOnClient() - An Exception occured during the commit process : exception = " + serverException);
                    PSCServices.getServiceFacade().showException((Exception)((Object)new EXServerException(serverException)), CommitMgr.this.projectAgent.getServerID());
                    return;
                }
                SequencerManager sequencerManager = (SequencerManager)CommitMgr.this.projectAgent.getSequencerManager();
                sequencerManager.asynchronouseUpdateStarted();
                EOProject modifiedProject = asynchronousUpdateModifications.getModifiedProject();
                EOFileModification fileModification = asynchronousUpdateModifications.getFileModification();
                EOUserDefinedAttributeTypesModification userDefinedAttributeTypesModification = asynchronousUpdateModifications.getUserDefinedAttributeTypesModification();
                EOFrameDataModification objectTypeCategoryCreateAndUpdateModifications = asynchronousUpdateModifications.getObjectTypeCategoryCreateAndUpdateModifications();
                EOFrameDataModification objectTypeCategoryDeleteModifications = asynchronousUpdateModifications.getObjectTypeCategoryDeleteModifications();
                EOUniqueElementModification uniqueElementModification = asynchronousUpdateModifications.getUniqueElementModification();
                EOList createdOrModifiedModuleChanges = asynchronousUpdateModifications.getCreatedOrModifiedModuleDataChanges();
                EOSectionAndPlanModifications sectionAndPlanModification = asynchronousUpdateModifications.getSectionAndPlanChanges();
                EOList uniqueElementRelationshipModifications = asynchronousUpdateModifications.getUniqueElementRelationshipModification();
                EOList linkModifications = asynchronousUpdateModifications.getLinkModifications();
                EOList deletedModuleChanges = asynchronousUpdateModifications.getDeletedModuleDataChanges();
                EOStakeholderModification stakeholderModifications = asynchronousUpdateModifications.getStakeholderModification();
                if (modifiedProject != null) {
                    CommitMgr.this.projectAgent.getProjectMetaDataManager().applyAsynchronousModification(modifiedProject);
                }
                CommitMgr.this.projectAgent.getFilesManager().asynchronousUpdateReceived(fileModification);
                CommitMgr.this.projectAgent.getFrameUserDefinedAttributeTypesManager().applyAsynchronousModifications(userDefinedAttributeTypesModification);
                CommitMgr.this.projectAgent.getObjectTypeCategoriesManager().handleAsynchronousUpdate(objectTypeCategoryCreateAndUpdateModifications);
                CommitMgr.this.projectAgent.getObjectTypeCategoriesManager().handleAsynchronousUpdate(objectTypeCategoryDeleteModifications);
                CommitMgr.this.uniqueElementMgr.applyAsynchronousUniqueElementModifications(uniqueElementModification);
                CommitMgr.this.moduleController.distributeAsynchronousResponses((EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>>)createdOrModifiedModuleChanges);
                CommitMgr.this.stakeholderManager.applyAsynchronousStakeholderModifications(stakeholderModifications);
                CommitMgr.this.sectionMgr.applyAsynchronousModifications(sectionAndPlanModification);
                CommitMgr.this.uniqueElementRelationshipMgr.applyAsynchronousUniqueElementRelationshipChanges((Collection<EOUniqueElementRelationshipModification>)uniqueElementRelationshipModifications);
                for (EOFrameDataModification frameDataModification : asynchronousUpdateModifications.getFrameDataModifications()) {
                    IFrameDataManager dataManager = CommitMgr.this.projectAgent.getDataManager(frameDataModification.getRole());
                    if (dataManager == null) continue;
                    dataManager.applyAsynchronousModifications((EOFrameDataModification<? extends EOCockpitProjectData>)frameDataModification);
                }
                CommitMgr.this.linkManager.handleServerUpdate((EOList<EOLinkModificationContainer>)linkModifications);
                CommitMgr.this.moduleController.distributeAsynchronousResponses((EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>>)deletedModuleChanges);
                CommitMgr.this.uniqueElementMgr.applyAsynchronousUniqueElementDeletions(uniqueElementModification);
                CommitMgr.this.stakeholderManager.applyAsynchronousStakeholderDeletions(stakeholderModifications);
                CommitMgr.this.moduleController.finishedAsynchronousUpdate();
                CommitMgr.this.projectAgent.getObjectTypeCategoriesManager().finishServerUpdate();
                sequencerManager.asynchronouseUpdateEnded();
                CommitMgr.this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)new PropertyChanges(null, (Object)new PropertyChange_AsynchronousUpdateFinished(), null, true), PropertyChange_AsynchronousUpdateFinished.class);
                CommitMgr.this.projectAgent.getCockpitController().applyAsynchronousModifications(asynchronousUpdateModifications.getCommitInformation(), asynchronousUpdateModifications.getWorkspaceInformation(), (EOList<EOPlatformLock>)asynchronousUpdateModifications.getPlatformLockLogs());
                String commitUID = asynchronousUpdateModifications.getCommitInformation().getCommitInformation().getCommitUID();
                CommitMgr.this.projectAgent.addCommitVersionUID(commitUID);
                logger.info("Project " + CommitMgr.this.projectAgent.getProjectName() + " refreshed.");
            }
        });
    }

    private void finishCommitProcess(EOCommit projectModifications, Shell shell) {
        assert (projectModifications != null) : "projectModifications can't be null!";
        try {
            final EOCommit commitResponse = this.serverProxy.commitProject(projectModifications, shell);
            if (commitResponse != null) {
                this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

                    @Override
                    public void run() {
                        CommitMgr.this.applySynchronousModificationsOnClient(commitResponse);
                    }
                });
            }
        }
        catch (ServerNotAvailableException e) {
            logger.error("finishCommitProcess() - Server not available when finishing commit process", (Throwable)e);
        }
        catch (UnknownServerException e) {
            logger.error("finishCommitProcess() - Unknown Server when finishing commit process", (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.error("finishCommitProcess() - User canceled login when finishing commit process", (Throwable)e);
        }
        catch (EXServerException e) {
            logger.error("finishCommitProcess() - Exception when finishing commit process", (Throwable)e);
        }
    }

    public void doWithSuspendedAsynchronousUpdate(Runnable todo) {
        ++this.asynchronousUpdatesSuspendCount;
        try {
            todo.run();
        }
        finally {
            --this.asynchronousUpdatesSuspendCount;
            this.deliverPendingAsynchronousUpdatesIfAdmissible();
        }
    }

    public void initializeAsynchronousUpdateDelayMachinery() {
        this.asynchronousUpdatesDeliveryStarted = false;
        this.asynchronousUpdatesSuspendCount = 0;
        this.unappliedAsynchronousUpdates.clear();
        this.asynchronousUpdateAboutToBeApplied = null;
    }

    public void startAsynchronousUpdateProcessing() {
        assert (!this.asynchronousUpdatesDeliveryStarted);
        assert (this.asynchronousUpdatesSuspendCount == 0);
        assert (this.asynchronousUpdateAboutToBeApplied == null);
        this.asynchronousUpdatesDeliveryStarted = true;
        this.deliverPendingAsynchronousUpdatesIfAdmissible();
    }

    /*
     * Unable to fully structure code
     */
    private void deliverPendingAsynchronousUpdatesIfAdmissible() {
        if (CommitMgr.$assertionsDisabled || this.asynchronousUpdatesSuspendCount >= 0) ** GOTO lbl6
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.asynchronousUpdateAboutToBeApplied = this.unappliedAsynchronousUpdates.removeFirst();
            this.immediatelyApplyAsynchronousModificationsOnClient(this.asynchronousUpdateAboutToBeApplied);
            this.asynchronousUpdateAboutToBeApplied = null;
lbl6:
            // 2 sources

            ** while (this.asynchronousUpdatesDeliveryStarted && this.asynchronousUpdatesSuspendCount == 0 && !this.unappliedAsynchronousUpdates.isEmpty() && this.asynchronousUpdateAboutToBeApplied == null)
        }
lbl7:
        // 1 sources

    }

    public EOClientRequest registerNotificationListenerOnClientAndGetRegistrationRequest() {
        this.serverSideListenersPossiblyRegistered = true;
        return this.serverProxy.subscribeListenerOnClientBusAndGetRequestToRegisterOnServer(this.notificationListener, this.notificationTypeForAsyncUpdates);
    }

    public EOClientRequest getCommitVersionListenerRegistrationRequest() {
        this.serverSideListenersPossiblyRegistered = true;
        return new EOClientRequest("frame.lock", "frame.subscribeCVL", (EncodableObjectBase)this.notificationForCommitVersionListenerOnServer);
    }

    private class PerformAsynchronousChangesOnClientRequest
    implements Runnable {
        EOCommit modificationsToCommit;

        PerformAsynchronousChangesOnClientRequest(EOCommit modificationsToCommit) {
            this.modificationsToCommit = modificationsToCommit;
        }

        @Override
        public void run() {
            CommitMgr.this.applyAsynchronousModificationsOnClient(this.modificationsToCommit);
        }
    }
}

