/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.IChildRelationsManager;
import java.util.ArrayList;
import java.util.Collection;

public class ChildRelationsManager
implements IChildRelationsManager {
    private final IFrameProjectAgent projectAgent;

    public ChildRelationsManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    @Override
    public boolean hasChildren(IAttributeOwner attributeOwner) {
        return false;
    }

    public Collection getChildren(IAttributeOwner attributeOwner) {
        IFrameDataManager dataManager = this.projectAgent.getDataManager(attributeOwner.getTypeID());
        return dataManager.getChildren(attributeOwner);
    }

    public Collection getChildren(IAttributeOwner attributeOwner, String dataTypeID) {
        Collection allChildren = this.getChildren(attributeOwner);
        ArrayList<IAttributeOwner> result = new ArrayList<IAttributeOwner>(allChildren.size());
        for (IAttributeOwner child : allChildren) {
            if (!child.getTypeID().equals(dataTypeID)) continue;
            result.add(child);
        }
        return result;
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner attributeOwner) {
        IFrameDataManager dataManager = this.projectAgent.getDataManager(attributeOwner.getTypeID());
        return dataManager.getParent(attributeOwner);
    }
}

