/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied;

import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Edge;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.EdgeList;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Node;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.NodeList;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.patched.GraphVisitor;
import java.util.ArrayList;
import java.util.Stack;

public class InitialRankSolver
extends GraphVisitor {
    protected DirectedGraph graph;
    protected EdgeList candidates = new EdgeList();
    protected NodeList members = new NodeList();

    @Override
    public void visit(DirectedGraph graph) {
        this.graph = graph;
        graph.edges.resetFlags(false);
        graph.nodes.resetFlags();
        this.solve();
    }

    protected void solve() {
        if (this.graph.nodes.size() == 0) {
            return;
        }
        NodeList unranked = new NodeList(this.graph.nodes);
        NodeList rankMe = new NodeList();
        while (!unranked.isEmpty()) {
            Node node;
            rankMe.clear();
            int i = 0;
            while (i < unranked.size()) {
                node = unranked.getNode(i);
                if (node.incoming.isCompletelyFlagged()) {
                    rankMe.add(node);
                    unranked.remove(i);
                    continue;
                }
                ++i;
            }
            if (rankMe.size() == 0) {
                throw new RuntimeException("Cycle detected in graph");
            }
            i = 0;
            while (i < rankMe.size()) {
                node = rankMe.getNode(i);
                this.assignMinimumRank(node);
                node.outgoing.setFlags(true);
                ++i;
            }
        }
        this.connectForest();
    }

    private void connectForest() {
        NodeList tree;
        ArrayList<NodeList> forest = new ArrayList<NodeList>();
        Stack<Node> stack = new Stack<Node>();
        this.graph.nodes.resetFlags();
        int i = 0;
        while (i < this.graph.nodes.size()) {
            Node n = this.graph.nodes.getNode(i);
            if (!n.flag) {
                tree = new NodeList();
                stack.push(n);
                while (!stack.isEmpty()) {
                    Node neighbor;
                    n = (Node)stack.pop();
                    n.flag = true;
                    tree.add(n);
                    int s = 0;
                    while (s < n.incoming.size()) {
                        neighbor = n.incoming.getEdge((int)s).source;
                        if (!neighbor.flag) {
                            stack.push(neighbor);
                        }
                        ++s;
                    }
                    s = 0;
                    while (s < n.outgoing.size()) {
                        neighbor = n.outgoing.getEdge((int)s).target;
                        if (!neighbor.flag) {
                            stack.push(neighbor);
                        }
                        ++s;
                    }
                }
                forest.add(tree);
            }
            ++i;
        }
        if (forest.size() > 1) {
            this.graph.forestRoot = new Node("the forest root");
            this.graph.nodes.add(this.graph.forestRoot);
            i = 0;
            while (i < forest.size()) {
                tree = (NodeList)forest.get(i);
                this.graph.edges.add(new Edge(this.graph.forestRoot, tree.getNode(0), 0, 0));
                ++i;
            }
        }
    }

    private void assignMinimumRank(Node node) {
        int rank = 0;
        int i1 = 0;
        while (i1 < node.incoming.size()) {
            Edge e = node.incoming.getEdge(i1);
            rank = Math.max(rank, e.delta + e.source.rank);
            ++i1;
        }
        node.rank = rank;
    }
}

