/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews;

import com.arcway.cockpit.frame.client.lib.relationviews.EdgeAttributes;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.NodeAttributes;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class LabelCreator {
    private final IGraphNodeLayoutProvider layoutProvider;

    public LabelCreator(IGraphNodeLayoutProvider layoutProvider) {
        this.layoutProvider = layoutProvider;
    }

    public NodeAttributes getNodeAttributes(ICockpitProjectData data, int nodeType) {
        Font font = this.layoutProvider.getFont();
        int width = this.layoutProvider.getWidthHint(font, data, nodeType);
        int height = this.layoutProvider.getHeightHint(font, data, nodeType);
        String unwrappedText = this.layoutProvider.getLabel(data, nodeType);
        String wrappedText = this.layoutProvider.getWrappedLabel(font, data, nodeType);
        Image icon = this.layoutProvider.hasIcon(data, nodeType) ? this.layoutProvider.getIcon(data, nodeType) : null;
        Color foregroundColor = this.layoutProvider.getForegroundColor(data, nodeType);
        Color backgroundColor = this.layoutProvider.getBackgroundColor(data, nodeType);
        Color toolTipColor = this.layoutProvider.getToolTipColor();
        boolean isLabelShortening = this.layoutProvider.isLabelShortening(data, wrappedText, nodeType);
        return new NodeAttributes(font, unwrappedText, wrappedText, isLabelShortening, width, height, icon, foregroundColor, backgroundColor, toolTipColor);
    }

    public EdgeAttributes getEdgeAttributes(int edgeType, boolean virtualSource, boolean virtualTarget) {
        boolean hasSourceArrow = this.layoutProvider.hasSourceArrow(edgeType, virtualSource);
        boolean hasTargetArrow = this.layoutProvider.hasTargetArrow(edgeType, virtualTarget);
        return new EdgeAttributes(this.layoutProvider.showEdge(edgeType), hasSourceArrow, hasTargetArrow, this.layoutProvider.getLineColor());
    }

    public void dispose() {
        this.layoutProvider.dispose();
    }
}

