/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews;

import com.arcway.cockpit.frame.client.lib.relationviews.IRelationView;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewFigureFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Edge;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.Node;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.VirtualNode;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.derived.RelationViewGraphEdge;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.derived.RelationViewGraphNode;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.XYLayout;

public class GraphToFigureConverter {
    public static IFigure getFigure(IRelationViewFigureFactory factory, DirectedGraph graph, LabelCreator labelCreator, IRelationView relationView) {
        Panel mainFigure = new Panel();
        mainFigure.setBackgroundColor(ColorConstants.white);
        mainFigure.setLayoutManager((LayoutManager)new XYLayout());
        ArrayList<IFigure> figures = new ArrayList<IFigure>();
        int i = 0;
        while (i < graph.nodes.size()) {
            boolean nodeIsVirtual;
            Node node = graph.nodes.getNode(i);
            boolean nodeIsRelationViewNode = node instanceof RelationViewGraphNode && ((RelationViewGraphNode)node).getNodeType() != -1;
            boolean bl = nodeIsVirtual = node instanceof VirtualNode || node instanceof RelationViewGraphNode && ((RelationViewGraphNode)node).getNodeType() == -1;
            if (nodeIsRelationViewNode) {
                figures.addAll(factory.createNodeFigures(node.x, node.y, node.width, node.height, labelCreator.getNodeAttributes((ICockpitProjectData)node.data, ((RelationViewGraphNode)node).getNodeType()), node.data, relationView));
            } else if (nodeIsVirtual) {
                figures.addAll(factory.createEdgeFigures(node.x + node.width / 2, node.y, node.x + node.width / 2, node.y + node.height, labelCreator.getEdgeAttributes(-1, true, true)));
            }
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            Node s = edge.source;
            Node t = edge.target;
            int edgeType = -1;
            if (edge instanceof RelationViewGraphEdge) {
                edgeType = ((RelationViewGraphEdge)edge).getEdgeType();
            }
            boolean sourceVirtual = s instanceof VirtualNode || s instanceof RelationViewGraphNode && ((RelationViewGraphNode)s).getNodeType() == -1;
            boolean targetVirtual = t instanceof VirtualNode || t instanceof RelationViewGraphNode && ((RelationViewGraphNode)t).getNodeType() == -1;
            figures.addAll(factory.createEdgeFigures(s.x + edge.getSourceOffset(), s.y + s.height, t.x + edge.getTargetOffset(), t.y, labelCreator.getEdgeAttributes(edgeType, sourceVirtual, targetVirtual)));
            ++i;
        }
        for (IFigure figure : figures) {
            mainFigure.add(figure, (Object)figure.getBounds());
        }
        mainFigure.setSize(mainFigure.getPreferredSize());
        return mainFigure;
    }
}

