/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListenerManager;
import com.arcway.cockpit.cockpitlib.client.gui.DeferredRefresher;
import com.arcway.cockpit.cockpitlib.client.gui.IRefreshableDisplay;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.lib.relationviews.BackgroundSelectionListener;
import com.arcway.cockpit.frame.client.lib.relationviews.GraphToFigureConverter;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationView;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewFigureFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.RelationViewFigureFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.gefpatch.copied.DirectedGraph;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gef.draw2d.IFigureProvider;
import com.arcway.lib.eclipse.gef.draw2d.printing.PrintAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractRelationView
extends ViewPart
implements IRelationView,
IFigureProvider,
IPropertyChangesListener,
ISelectionListener,
IProjectCloseListener,
IPartListener2,
ISelectionProvider,
IRefreshableDisplay,
IMenuListener {
    private static final String CONTEXTMENU_ID_SUFFIX = ".contextmenu";
    private ICockpitProjectData currentItem = null;
    private String currentProjectId = null;
    private ICockpitProjectData newItemAfterRefresh = null;
    private IFigure currentGraphFigure = null;
    private final HashSet<ISelectionChangedListener> selectionChangedListeners = new HashSet();
    private MenuManager contextMenuManagerCanvas;
    private SelectionProviderForContextMenu selectionProviderForContextMenu;
    private long timestampOfLastBackgroundSelectionEvent = 0L;
    private Composite baseComposite;
    private Control viewerControl;
    private PrintAction printAction;
    private boolean isDisposed = false;
    private boolean refreshRequestedWhileInvisible = false;
    private boolean isVisible = false;
    private DeferredRefresher refresher;
    private ProjectAgent currentProjectAgent;
    private IPropertyChangesListenerManager currentPropertyChangesListenerManager = null;
    private RelationViewFigureFactory figureFactory;
    private LabelCreator figureLabelCreator;

    public final void createPartControl(Composite parent) {
        this.initialize(parent);
        this.createToolbar();
        this.baseComposite = new Composite(parent, 0);
        this.baseComposite.setLayout((Layout)new GridLayout(1, true));
        String helpContextID = this.getHelpContextID();
        if (helpContextID != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.baseComposite, helpContextID);
        }
        CockpitSelectionService selectionService = CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService());
        selectionService.addSelectionListener(this);
        this.contextMenuManagerCanvas = this.createContextMenu();
        this.showEmptyView();
        this.selectionChanged(null, (ISelection)selectionService.getLastSelection());
        this.getSite().getPage().addPartListener((IPartListener2)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.printAction = new PrintAction((IWorkbenchPart)this, (IFigureProvider)this);
        this.printAction.setEnabled(false);
        toolbarManager.add((IAction)this.printAction);
        toolbarManager.update(true);
    }

    protected void initialize(Composite parent) {
    }

    private void showItem(ICockpitProjectData item) {
        this.currentItem = item;
        String newProjectId = item.getProjectUID();
        if (this.currentProjectId == null || !this.currentProjectId.equals(newProjectId)) {
            this.switchProject(newProjectId);
            this.currentProjectId = newProjectId;
        }
        if (this.viewerControl != null && !this.viewerControl.isDisposed()) {
            this.viewerControl.dispose();
        }
        Color backgroundColour = this.baseComposite.getDisplay().getSystemColor(1);
        this.baseComposite.setBackground(backgroundColour);
        FigureCanvas canvas = new FigureCanvas(this.baseComposite);
        this.viewerControl = canvas;
        GridData gridData = new GridData(1808);
        canvas.setLayoutData((Object)gridData);
        canvas.setBackground(backgroundColour);
        FreeformViewport viewPort = new FreeformViewport();
        FreeformLayeredPane innerLayers = new FreeformLayeredPane();
        innerLayers.add((IFigure)new FreeformLayer(), (Object)"Primary Layer");
        LabelCreator labelCreator = this.getFigureLabelCreator();
        DirectedGraph graph = this.getGraphBuilder(labelCreator).createGraph(this.getNodeFont(), this.currentItem);
        IFigure contentFigure = GraphToFigureConverter.getFigure(this.getFigureFactory(), graph, labelCreator, this);
        innerLayers.add(contentFigure);
        this.currentGraphFigure = contentFigure;
        this.currentGraphFigure.validate();
        canvas.setMenu(this.contextMenuManagerCanvas.createContextMenu((Control)canvas));
        canvas.addMouseListener((org.eclipse.swt.events.MouseListener)new BackgroundSelectionListener(this));
        this.currentGraphFigure.addMouseListener((MouseListener)new BackgroundSelectionListener(this));
        viewPort.setContents((IFigure)innerLayers);
        canvas.setViewport((Viewport)viewPort);
        this.baseComposite.layout();
        if (!canvas.isDisposed()) {
            Dimension graphSize = contentFigure.getPreferredSize();
            Dimension viewPortClientAreaSize = new Dimension(this.baseComposite.getClientArea().width, this.baseComposite.getClientArea().height);
            Point center = new Point(Math.max(0, (viewPortClientAreaSize.width - graphSize.width) / 2), Math.max(0, (viewPortClientAreaSize.height - graphSize.height) / 2));
            viewPort.setLocation(center);
        }
        this.printAction.setEnabled(true);
    }

    private void showEmptyView() {
        this.currentItem = null;
        this.currentProjectId = null;
        this.switchProject(null);
        this.baseComposite.setLayout((Layout)new GridLayout());
        this.baseComposite.setBackground(this.baseComposite.getDisplay().getSystemColor(22));
        this.baseComposite.setMenu(null);
        if (this.viewerControl != null && !this.viewerControl.isDisposed()) {
            this.viewerControl.dispose();
        }
        Composite composite = new Composite(this.baseComposite, 0);
        this.viewerControl = composite;
        composite.setBackground(composite.getDisplay().getSystemColor(22));
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1, 1, true, true));
        Label noItemLabel = new Label(composite, 16640);
        noItemLabel.setText(this.getEmptyViewMessage());
        noItemLabel.setLayoutData((Object)new GridData(1, 1, true, false));
        this.baseComposite.layout();
        this.baseComposite.redraw();
        this.printAction.setEnabled(false);
        this.currentGraphFigure = null;
    }

    protected ICockpitProjectData getCurrentItem() {
        return this.currentItem;
    }

    protected void refreshCurrentItem() {
        if (this.currentItem != null) {
            this.newItemAfterRefresh = !this.validateItem(this.currentItem) ? null : this.currentItem;
            this.needsRefresh();
        }
    }

    protected void clearCurrentItem() {
        this.newItemAfterRefresh = null;
        this.needsRefresh();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (part != this && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() >= 1) {
            Iterator selectionIterator = structuredSelection.iterator();
            ICockpitProjectData cockpitDataItem = null;
            while (selectionIterator.hasNext() && cockpitDataItem == null) {
                Object item = selectionIterator.next();
                if (!(item instanceof ICockpitProjectData)) continue;
                cockpitDataItem = this.translateItem((ICockpitProjectData)item);
            }
            if (cockpitDataItem != null) {
                ICockpitProjectData validatedItem = this.validateItem(cockpitDataItem) ? cockpitDataItem : null;
                if (!(validatedItem == null && this.currentItem == null || validatedItem != null && this.currentItem != null && validatedItem.equals(this.currentItem))) {
                    this.newItemAfterRefresh = validatedItem;
                    this.needsRefresh();
                }
                return;
            }
            for (Object item : structuredSelection.toList()) {
                if (!(item instanceof ICockpitProjectData) || ((ICockpitProjectData)item).getProjectUID().equals(this.currentProjectId)) continue;
                this.newItemAfterRefresh = null;
                this.needsRefresh();
                return;
            }
        }
    }

    @Override
    public void updateSelection(IStructuredSelection selection, boolean contextMenuOnly, boolean isBackground) {
        if (!isBackground) {
            this.timestampOfLastBackgroundSelectionEvent = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.timestampOfLastBackgroundSelectionEvent < 100L) {
            return;
        }
        this.selectionProviderForContextMenu.setSelection((ISelection)selection);
        if (!contextMenuOnly) {
            ICockpitProjectData oldSelection = this.newItemAfterRefresh;
            this.selectionChanged(null, (ISelection)selection);
            if (this.newItemAfterRefresh == null && oldSelection != null || this.newItemAfterRefresh != null && !this.newItemAfterRefresh.equals(oldSelection)) {
                for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
                }
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        if (this.newItemAfterRefresh != null) {
            return new StructuredSelection((Object)this.newItemAfterRefresh);
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException("Can't set selection on relation view explicitely.");
    }

    private MenuManager createContextMenu() {
        String contextMenuID = String.valueOf(this.getSite().getId()) + CONTEXTMENU_ID_SUFFIX;
        MenuManager contextMenuManager = new MenuManager("#PopUp", contextMenuID);
        this.prefillContextMenu((IMenuManager)contextMenuManager);
        contextMenuManager.addMenuListener((IMenuListener)this);
        contextMenuManager.setVisible(true);
        this.selectionProviderForContextMenu = new SelectionProviderForContextMenu();
        this.getSite().registerContextMenu(contextMenuID, contextMenuManager, (ISelectionProvider)this.selectionProviderForContextMenu);
        return contextMenuManager;
    }

    public final void menuAboutToShow(IMenuManager menuManager) {
        this.setCommandVisibility(menuManager, (IStructuredSelection)this.selectionProviderForContextMenu.getSelection());
    }

    protected void setCommandVisibility(IMenuManager menuManager, IStructuredSelection selection) {
    }

    protected void prefillContextMenu(IMenuManager contextMenu) {
        contextMenu.add((IContributionItem)new Separator("additions"));
    }

    public IFigure getCurrentFigure() {
        return this.currentGraphFigure;
    }

    private void needsRefresh() {
        if (this.refresher == null) {
            this.refresher = new DeferredRefresher((IRefreshableDisplay)this, 300L);
            this.refresher.start();
        }
        this.refresher.scheduleDeferredRefresh();
    }

    public void refresh() {
        if (this.newItemAfterRefresh != null && !this.validateItem(this.newItemAfterRefresh)) {
            this.newItemAfterRefresh = null;
        }
        if (this.isVisible) {
            if (this.newItemAfterRefresh != null) {
                this.showItem(this.newItemAfterRefresh);
            } else if (this.currentItem != null) {
                this.showEmptyView();
            }
        } else {
            this.refreshRequestedWhileInvisible = true;
        }
    }

    public Display getDisplay() {
        return this.getSite().getShell().getDisplay();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener((IPartListener2)this);
        this.isDisposed = true;
        if (this.refresher != null) {
            this.refresher.halt();
            this.refresher = null;
        }
        CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService()).removeSelectionListener(this);
        if (this.currentPropertyChangesListenerManager != null) {
            this.currentPropertyChangesListenerManager.deregister((IPropertyChangesListener)this);
        }
        this.handleDispose();
        if (this.figureLabelCreator != null) {
            this.figureLabelCreator.dispose();
        }
        if (this.figureFactory != null) {
            this.figureFactory.disposeResources();
        }
    }

    public boolean isDisposed() {
        return this.isDisposed || this.baseComposite.isDisposed();
    }

    public void setFocus() {
        this.baseComposite.setFocus();
    }

    @Override
    public void closeProject(IFrameProjectAgent projectAgent) {
        assert (this.currentProjectAgent == projectAgent);
        this.switchProject(null);
        this.newItemAfterRefresh = null;
        this.needsRefresh();
        this.refresher.executePendingRefreshNow();
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        this.handleModelRefresh(changes, clazz, projectUID);
    }

    private void switchProject(String newProjectUID) {
        if (this.currentProjectAgent != null) {
            this.currentProjectAgent.removeProjectCloseListener(this);
        }
        if (this.currentPropertyChangesListenerManager != null) {
            this.currentPropertyChangesListenerManager.deregister((IPropertyChangesListener)this);
        }
        this.handleProjectSwitch_Before(newProjectUID);
        if (newProjectUID != null) {
            this.currentProjectAgent = ProjectMgr.getProjectMgr().getProjectAgent(newProjectUID);
            this.currentProjectAgent.addProjectCloseListener(this);
        } else {
            this.currentProjectAgent = null;
        }
        if (newProjectUID != null) {
            this.currentPropertyChangesListenerManager = this.currentProjectAgent.getPropertyChangesListenerManager();
            for (Class<?> clazz : this.getDataTypesWhichCauseRefresh()) {
                this.currentPropertyChangesListenerManager.register((IPropertyChangesListener)this, clazz);
            }
        } else {
            this.currentPropertyChangesListenerManager = null;
        }
        this.handleProjectSwitch_After(newProjectUID);
    }

    protected void deregisterForPropertyChanges(IPropertyChangesListener listener) {
        if (this.currentPropertyChangesListenerManager != null) {
            this.currentPropertyChangesListenerManager.deregister(listener);
        }
    }

    protected abstract void handleProjectSwitch_Before(String var1);

    protected abstract void handleProjectSwitch_After(String var1);

    protected abstract void handleModelRefresh(IPropertyChanges<?> var1, Class<?> var2, String var3);

    protected abstract void handleDispose();

    protected abstract ICockpitProjectData translateItem(ICockpitProjectData var1);

    protected abstract boolean validateItem(ICockpitProjectData var1);

    protected abstract Collection<Class<?>> getDataTypesWhichCauseRefresh();

    protected abstract String getEmptyViewMessage();

    protected abstract IRelationViewGraphBuilder getGraphBuilder(LabelCreator var1);

    protected abstract IGraphNodeLayoutProvider createFigureLayoutProvider();

    private Font getNodeFont() {
        Font font = this.getViewSite().getShell().getFont();
        return font;
    }

    private LabelCreator getFigureLabelCreator() {
        if (this.figureLabelCreator == null) {
            this.figureLabelCreator = new LabelCreator(this.createFigureLayoutProvider());
        }
        return this.figureLabelCreator;
    }

    protected IRelationViewFigureFactory getFigureFactory() {
        if (this.figureFactory == null) {
            this.figureFactory = new RelationViewFigureFactory(this.getViewSite().getShell().getDisplay());
        }
        return this.figureFactory;
    }

    protected abstract String getHelpContextID();

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) == this) {
            this.isVisible = false;
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) == this) {
            this.isVisible = true;
            if (this.refreshRequestedWhileInvisible) {
                this.refreshRequestedWhileInvisible = false;
                this.needsRefresh();
                this.refresher.executePendingRefreshNow();
            }
        }
    }

    private class SelectionProviderForContextMenu
    implements ISelectionProvider {
        ICockpitProjectData currentSelectionForContextMenu = null;

        private SelectionProviderForContextMenu() {
        }

        public ISelection getSelection() {
            if (this.currentSelectionForContextMenu != null) {
                return new StructuredSelection((Object)this.currentSelectionForContextMenu);
            }
            return new StructuredSelection();
        }

        public void setSelection(ISelection selection) {
            Object selectedItem;
            IStructuredSelection structuredSelection;
            this.currentSelectionForContextMenu = null;
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (selectedItem = structuredSelection.getFirstElement()) instanceof ICockpitProjectData) {
                this.currentSelectionForContextMenu = (ICockpitProjectData)selectedItem;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            throw new UnsupportedOperationException();
        }
    }
}

