/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.dnd;

import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.lib.eclipse.transfer.dnd.DropTargetParameters;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class DataViewDropTargetListener
implements DropTargetListener {
    private Control control;
    private Object currentTarget;
    private int currentLocation;
    private final Collection<DropTarget> dropTargets;
    private DropTarget activeDropTarget;
    private int supportedOperations = 0;
    private final Set<Transfer> supportedTransfers = new HashSet<Transfer>();
    private int currentUserOperation = 16;
    private int lastEventDetail;
    private TransferData lastEventCurrentDataType;
    private int lastEventFeeback;

    public DataViewDropTargetListener(Control control, DropTarget[] dropTargets) {
        this.control = control;
        this.dropTargets = Arrays.asList(dropTargets);
        DropTarget[] dropTargetArray = dropTargets;
        int n = dropTargets.length;
        int n2 = 0;
        while (n2 < n) {
            DropTarget dropTarget = dropTargetArray[n2];
            this.supportedOperations |= dropTarget.getOperations();
            this.supportedTransfers.addAll(dropTarget.getTransferTypes());
            ++n2;
        }
    }

    protected int determineLocation(DropTargetEvent event) {
        if (!(event.item instanceof Item)) {
            return 4;
        }
        Item item = (Item)event.item;
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        if (item != null) {
            Rectangle bounds = this.getBounds(item);
            if (bounds == null) {
                return 4;
            }
            if (coordinates.y - bounds.y < 5) {
                return 1;
            }
            if (bounds.y + bounds.height - coordinates.y < 5) {
                return 2;
            }
        }
        return 3;
    }

    protected Object determineTarget(DropTargetEvent event) {
        return event.item == null ? null : event.item.getData();
    }

    private void doDropValidation(DropTargetEvent event) {
        for (DropTarget dropTarget : this.dropTargets) {
            DropTargetParameters chosenParameters;
            if (!dropTarget.isDropPossible(event, this.currentLocation, this.control, chosenParameters = new DropTargetParameters())) continue;
            this.activeDropTarget = dropTarget;
            event.detail = chosenParameters.requestedOperation;
            event.currentDataType = chosenParameters.requestedTransferType;
            this.setFeedback(event, this.currentLocation, chosenParameters.requestedFeedbackTypes);
            return;
        }
        event.detail = 0;
        event.feedback = 24;
    }

    public void dragEnter(DropTargetEvent event) {
        this.currentUserOperation = event.detail;
        this.currentTarget = this.determineTarget(event);
        this.doDropValidation(event);
        this.lastEventDetail = event.detail;
        this.lastEventCurrentDataType = event.currentDataType;
        this.lastEventFeeback = event.feedback;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.currentUserOperation = event.detail;
        this.currentTarget = this.determineTarget(event);
        this.doDropValidation(event);
        this.lastEventDetail = event.detail;
        this.lastEventCurrentDataType = event.currentDataType;
        this.lastEventFeeback = event.feedback;
    }

    public void dragOver(DropTargetEvent event) {
        Object target = this.determineTarget(event);
        int oldLocation = this.currentLocation;
        this.currentLocation = this.determineLocation(event);
        if (target != this.currentTarget || this.currentLocation != oldLocation) {
            event.detail = this.currentUserOperation;
            this.currentTarget = target;
            this.doDropValidation(event);
            this.lastEventDetail = event.detail;
            this.lastEventCurrentDataType = event.currentDataType;
            this.lastEventFeeback = event.feedback;
        } else {
            event.detail = this.lastEventDetail;
            event.currentDataType = this.lastEventCurrentDataType;
            event.feedback = this.lastEventFeeback;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (this.activeDropTarget == null || !this.activeDropTarget.isDropPossible(event, this.currentLocation, this.control, new DropTargetParameters())) {
            event.detail = 0;
        }
    }

    public void drop(DropTargetEvent event) {
        this.currentLocation = this.determineLocation(event);
        if (!this.activeDropTarget.performDrop(event, this.currentLocation, this.control)) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
        event.detail = 16;
        this.currentUserOperation = 16;
    }

    private Rectangle getBounds(Item item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBounds();
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(0);
        }
        return null;
    }

    public void setViewer(Control viewer) {
        this.control = viewer;
    }

    private void setFeedback(DropTargetEvent event, int location, int supportedFeedbackTypes) {
        switch (location) {
            case 1: {
                if ((supportedFeedbackTypes & 2) != 0) {
                    event.feedback = 2;
                    break;
                }
                if ((supportedFeedbackTypes & 1) != 0) {
                    event.feedback = 1;
                    break;
                }
                event.feedback = 0;
                break;
            }
            case 2: {
                if ((supportedFeedbackTypes & 4) != 0) {
                    event.feedback = 4;
                    break;
                }
                if ((supportedFeedbackTypes & 1) != 0) {
                    event.feedback = 1;
                    break;
                }
                event.feedback = 0;
                break;
            }
            default: {
                event.feedback = (supportedFeedbackTypes & 1) != 0 ? 1 : 0;
            }
        }
        if ((supportedFeedbackTypes & 0x10) != 0) {
            event.feedback |= 0x10;
        }
        if ((supportedFeedbackTypes & 8) != 0) {
            event.feedback |= 8;
        }
    }

    public int getSupportedOperations() {
        return this.supportedOperations;
    }

    public Transfer[] getSupportedTransfers() {
        Transfer[] transfers = new Transfer[this.supportedTransfers.size()];
        this.supportedTransfers.toArray(transfers);
        return transfers;
    }
}

