/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.license;

import com.arcway.cockpit.frame.client.global.license.ClientModuleLicense;
import com.arcway.cockpit.frame.client.global.license.ClientProductLicense;
import com.arcway.cockpit.frame.client.global.license.IClientModuleLicense;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicense;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseManager;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseType;
import com.arcway.cockpit.frame.client.global.license.ILicenseChangeListener;
import com.arcway.lib.java.tuples.Tuple;
import de.plans.lib.lic.ModuleLicense;
import de.plans.lib.lic.UserLicense;
import de.plans.lib.lic.ValidityHelper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractClientProductLicenseManager
implements IClientProductLicenseManager {
    private final Collection<ILicenseChangeListener> licenseChangeListeners = new HashSet<ILicenseChangeListener>();
    private Map<IClientProductLicenseType, IClientProductLicense> productLicenses;
    private Collection<IClientModuleLicense> moduleLicenses;

    protected boolean hasAnyProductLicense() {
        return !this.productLicenses.isEmpty();
    }

    @Override
    public boolean hasProductLicense(IClientProductLicenseType productLicenseType) {
        return this.productLicenses.containsKey(productLicenseType);
    }

    @Override
    public IClientProductLicense getProductLicense(IClientProductLicenseType productLicenseType) {
        return this.productLicenses.get(productLicenseType);
    }

    @Override
    public Collection<IClientProductLicense> getProductLicenses() {
        return this.productLicenses.values();
    }

    @Override
    public Collection<IClientModuleLicense> getModuleLicenses() {
        return this.moduleLicenses;
    }

    protected final void clearProductAndModuleLicenses() {
        this.productLicenses = new HashMap<IClientProductLicenseType, IClientProductLicense>();
        this.moduleLicenses = new ArrayList<IClientModuleLicense>();
    }

    @Override
    public final void addLicenseChangeListener(ILicenseChangeListener listener) {
        this.licenseChangeListeners.add(listener);
    }

    @Override
    public final void removeLicenseChangeListener(ILicenseChangeListener listener) {
        this.licenseChangeListeners.remove(listener);
    }

    protected final void notifyLicenseChangeListeners() {
        for (ILicenseChangeListener listener : this.licenseChangeListeners) {
            listener.productOrModuleLicensesChanged();
        }
    }

    protected final void activateProductLicense(IClientProductLicense productLicense) {
        this.productLicenses.put(productLicense.getType(), productLicense);
    }

    protected final void activateProductAndModuleLicenses(AbstractClientProductLicenseManager productLicenseManager) {
        this.productLicenses.putAll(productLicenseManager.productLicenses);
        this.moduleLicenses.addAll(productLicenseManager.moduleLicenses);
    }

    protected final void activateProductLicense(IClientProductLicenseType productLicenseType, UserLicense userLicense, String providerDescription) {
        Timestamp startDate = userLicense.getValidFromDateForSingleLicense();
        Timestamp endDate = userLicense.getExpiryDateForSingleLicense();
        ClientProductLicense newLicense = new ClientProductLicense(productLicenseType, startDate != ValidityHelper.VALID_SINCE_EVER_TIMESTAMP ? startDate : null, endDate != ValidityHelper.EXPIRES_NEVER_TIMESTAMP ? endDate : null, providerDescription);
        this.productLicenses.put(productLicenseType, newLicense);
    }

    protected final void activateModuleLicenses(UserLicense userLicense, Collection<ModuleLicense> moduleLicenses_, String providerDescription) {
        for (ModuleLicense moduleLicense : moduleLicenses_) {
            Timestamp ownStartDate = moduleLicense.getValidFromDate();
            Timestamp ownEndDate = moduleLicense.getExpiryDate();
            Tuple longestCommonValidityPeriod = userLicense != null ? ValidityHelper.getLongestCommonValidityPeriod((Timestamp)ownStartDate, (Timestamp)ownEndDate, (Timestamp)userLicense.getValidFromDateForSingleLicense(), (Timestamp)userLicense.getExpiryDateForSingleLicense()) : new Tuple((Object)ownStartDate, (Object)ownEndDate);
            if (longestCommonValidityPeriod == null) continue;
            this.moduleLicenses.add(new ClientModuleLicense(moduleLicense.moduleName, longestCommonValidityPeriod.getT1() != ValidityHelper.VALID_SINCE_EVER_TIMESTAMP ? (Timestamp)longestCommonValidityPeriod.getT1() : null, longestCommonValidityPeriod.getT2() != ValidityHelper.EXPIRES_NEVER_TIMESTAMP ? (Timestamp)longestCommonValidityPeriod.getT2() : null, ownStartDate != ValidityHelper.VALID_SINCE_EVER_TIMESTAMP ? ownStartDate : null, ownEndDate != ValidityHelper.EXPIRES_NEVER_TIMESTAMP ? ownEndDate : null, providerDescription));
        }
    }
}

