/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.uniqueelementrelationview;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelementrelationview.Messages;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelementrelationview.UniqueElementRelationGraphDependencyModel;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelementrelationview.UniqueElementRelationGraphLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.AbstractRelationView;
import com.arcway.cockpit.frame.client.lib.relationviews.Draw2DTextExtendCalculator;
import com.arcway.cockpit.frame.client.lib.relationviews.GraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.dependencynet.DependencyNetGraphBuilder;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipProviderManager;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class UniqueElementRelationView
extends AbstractRelationView {
    private DependencyNetGraphBuilder graphBuilder;
    private ShowContainmentAction showContainmentAction;
    private ShowCausalityAction showCausalityAction;
    private ShowAccessAction showAccessAction;
    private LevelCombo levelCombo;

    @Override
    public void handleDispose() {
    }

    public void handleModelRefresh(IPropertyChanges changes, Class clazz, String projectUID) {
        if (IUniqueElement.class.isAssignableFrom(clazz)) {
            if (changes.getDeletedElements() != null) {
                for (Object o : changes.getDeletedElements()) {
                    IUniqueElement uniqueElement;
                    if (!(o instanceof IUniqueElement) || (uniqueElement = (IUniqueElement)o) != this.getCurrentItem()) continue;
                    this.clearCurrentItem();
                    return;
                }
            }
            if (changes.getModifiedElements() != null) {
                for (IUniqueElement uniqueElement : changes.getModifiedElements()) {
                    if (uniqueElement != this.getCurrentItem()) continue;
                    this.refreshCurrentItem();
                    return;
                }
            }
        } else if (IUniqueElementOccurrence.class.isAssignableFrom(clazz) || EOUniqueElementRelationship.class.isAssignableFrom(clazz)) {
            if (changes.getDeletedElements() != null && changes.getDeletedElements().size() > 0) {
                this.refreshCurrentItem();
                return;
            }
            if (changes.getCreatedElements() != null && changes.getCreatedElements().size() > 0) {
                this.refreshCurrentItem();
                return;
            }
        } else if (ObjectTypeCategory.class.isAssignableFrom(clazz)) {
            for (Object modifiedObject : changes.getModifiedElements()) {
                ObjectTypeCategory modifiedCategory = (ObjectTypeCategory)modifiedObject;
                if (!modifiedCategory.getCockpitDataTypeID().equals("com.arcway.cockpit.uniqueelement")) continue;
                this.refreshCurrentItem();
            }
        } else assert (false) : "Unexpected type";
    }

    @Override
    protected ICockpitProjectData translateItem(ICockpitProjectData data) {
        if (data instanceof IUniqueElement) {
            return data;
        }
        return null;
    }

    @Override
    protected String getEmptyViewMessage() {
        return Messages.getString("UniqueElementRelationView.ErrorMsg.NoUniqueElementSelected");
    }

    @Override
    protected void handleProjectSwitch_Before(String newProjectUID) {
    }

    @Override
    protected void handleProjectSwitch_After(String newProjectUID) {
    }

    @Override
    public void createToolbar() {
        super.createToolbar();
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.showContainmentAction = new ShowContainmentAction();
        this.showContainmentAction.setEnabled(false);
        this.showContainmentAction.setChecked(false);
        toolbarManager.add((IAction)this.showContainmentAction);
        this.showCausalityAction = new ShowCausalityAction();
        this.showCausalityAction.setEnabled(false);
        toolbarManager.add((IAction)this.showCausalityAction);
        this.showAccessAction = new ShowAccessAction();
        this.showAccessAction.setEnabled(false);
        toolbarManager.add((IAction)this.showAccessAction);
        this.levelCombo = new LevelCombo();
        this.levelCombo.setVisible(true);
        this.levelCombo.setEnabled(false);
        toolbarManager.add((IContributionItem)this.levelCombo);
        toolbarManager.update(true);
    }

    @Override
    protected Collection<Class<?>> getDataTypesWhichCauseRefresh() {
        return Arrays.asList(IUniqueElement.class, IUniqueElementOccurrence.class, EOUniqueElementRelationship.class, ObjectTypeCategory.class);
    }

    @Override
    protected boolean validateItem(ICockpitProjectData data) {
        return true;
    }

    @Override
    protected String getHelpContextID() {
        return "com.arcway.cockpit.frame.help.unique_element_relations_view_index";
    }

    @Override
    protected IRelationViewGraphBuilder getGraphBuilder(LabelCreator labelCreator) {
        if (this.graphBuilder == null) {
            this.graphBuilder = new DependencyNetGraphBuilder(new UniqueElementRelationGraphDependencyModel(){

                @Override
                protected IUniqueElementRelationshipProvider fetchRelationshipProvider(UniqueElementRelationshipProviderManager relationshipProviderManager) {
                    return relationshipProviderManager.getContainmentRelationshipProvider();
                }
            }, labelCreator);
            if (this.showContainmentAction != null) {
                this.showContainmentAction.setEnabled(true);
                this.showContainmentAction.setChecked(true);
            }
            if (this.showCausalityAction != null) {
                this.showCausalityAction.setEnabled(true);
                this.showCausalityAction.setChecked(false);
            }
            if (this.showAccessAction != null) {
                this.showAccessAction.setEnabled(true);
                this.showAccessAction.setChecked(false);
            }
            if (this.levelCombo != null) {
                this.levelCombo.setEnabled(true);
                this.levelCombo.select(0);
            }
        }
        return this.graphBuilder;
    }

    @Override
    protected IGraphNodeLayoutProvider createFigureLayoutProvider() {
        Draw2DTextExtendCalculator textExtendCalculator = new Draw2DTextExtendCalculator();
        UniqueElementRelationGraphLayoutProvider relationGraphProvider = new UniqueElementRelationGraphLayoutProvider();
        return new GraphNodeLayoutProvider(textExtendCalculator, relationGraphProvider);
    }

    private void refreshActionCheckState(boolean isAccessActionChecked, boolean isContainmentActionChecked, boolean isCausalityActionChecked) {
        this.showAccessAction.setChecked(isAccessActionChecked);
        this.showContainmentAction.setChecked(isContainmentActionChecked);
        this.showCausalityAction.setChecked(isCausalityActionChecked);
    }

    private class LevelCombo
    extends ControlContribution {
        static final int INDEX_OF_UNLIMITED = 4;
        boolean enabled;
        Combo combo;

        public LevelCombo() {
            super("Ebenen");
            this.enabled = false;
        }

        protected Control createControl(Composite parent) {
            this.combo = new Combo(parent, 12);
            this.combo.add(Messages.getString("UniqueElementRelationView.1Step"));
            this.combo.add(Messages.getString("UniqueElementRelationView.2Steps"));
            this.combo.add(Messages.getString("UniqueElementRelationView.3Steps"));
            this.combo.add(Messages.getString("UniqueElementRelationView.4Steps"));
            this.combo.add(Messages.getString("UniqueElementRelationView.UnlimitedStep"));
            this.combo.select(0);
            this.combo.setEnabled(this.enabled);
            this.combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LevelCombo.this.updateSelection();
                }
            });
            return this.combo;
        }

        protected void updateSelection() {
            if (UniqueElementRelationView.this.graphBuilder != null) {
                int index = this.combo.getSelectionIndex();
                if (index == 4) {
                    UniqueElementRelationView.this.graphBuilder.setMaxLevelsDown(-1);
                    UniqueElementRelationView.this.graphBuilder.setMaxLevelsUp(-1);
                } else {
                    UniqueElementRelationView.this.graphBuilder.setMaxLevelsDown(index + 1);
                    UniqueElementRelationView.this.graphBuilder.setMaxLevelsUp(index + 1);
                }
                UniqueElementRelationView.this.refreshCurrentItem();
            }
        }

        protected void select(int index) {
            if (this.combo != null) {
                this.combo.select(index);
                this.updateSelection();
            }
        }

        protected void setEnabled(boolean enabled) {
            this.enabled = enabled;
            if (this.combo != null) {
                this.combo.setEnabled(this.enabled);
            }
        }
    }

    private class ShowAccessAction
    extends Action {
        public ShowAccessAction() {
            super(null, 2);
            this.setImageDescriptor(FramePlugin.getImageDescriptor("access.png"));
            this.setToolTipText(Messages.getString("UniqueElementRelationView.ShowAccess"));
        }

        public void run() {
            if (UniqueElementRelationView.this.graphBuilder != null) {
                UniqueElementRelationView.this.graphBuilder.changeDependencyModel(new UniqueElementRelationGraphDependencyModel(){

                    @Override
                    protected IUniqueElementRelationshipProvider fetchRelationshipProvider(UniqueElementRelationshipProviderManager relationshipProviderManager) {
                        return relationshipProviderManager.getAccessRelationshipProvider();
                    }
                });
                UniqueElementRelationView.this.refreshCurrentItem();
                UniqueElementRelationView.this.refreshActionCheckState(true, false, false);
            }
        }
    }

    private class ShowCausalityAction
    extends Action {
        public ShowCausalityAction() {
            super(null, 2);
            this.setImageDescriptor(FramePlugin.getImageDescriptor("causality.png"));
            this.setToolTipText(Messages.getString("UniqueElementRelationView.ShowCausality"));
        }

        public void run() {
            if (UniqueElementRelationView.this.graphBuilder != null) {
                UniqueElementRelationView.this.graphBuilder.changeDependencyModel(new UniqueElementRelationGraphDependencyModel(){

                    @Override
                    protected IUniqueElementRelationshipProvider fetchRelationshipProvider(UniqueElementRelationshipProviderManager relationshipProviderManager) {
                        return relationshipProviderManager.getCausalityRelationshipProvider();
                    }
                });
                UniqueElementRelationView.this.refreshCurrentItem();
                UniqueElementRelationView.this.refreshActionCheckState(false, false, true);
            }
        }
    }

    private class ShowContainmentAction
    extends Action {
        public ShowContainmentAction() {
            super(null, 2);
            this.setImageDescriptor(FramePlugin.getImageDescriptor("containment.png"));
            this.setToolTipText(Messages.getString("UniqueElementRelationView.ShowContainment"));
        }

        public void run() {
            if (UniqueElementRelationView.this.graphBuilder != null) {
                UniqueElementRelationView.this.graphBuilder.changeDependencyModel(new UniqueElementRelationGraphDependencyModel(){

                    @Override
                    protected IUniqueElementRelationshipProvider fetchRelationshipProvider(UniqueElementRelationshipProviderManager relationshipProviderManager) {
                        return relationshipProviderManager.getContainmentRelationshipProvider();
                    }
                });
                UniqueElementRelationView.this.refreshCurrentItem();
                UniqueElementRelationView.this.refreshActionCheckState(false, true, false);
            }
        }
    }
}

