/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dnd.IFileDropListener;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectView;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewTransfer;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.FrameDataTransactionListener;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.sequences.ISequencer;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class ProjectViewDropAgent
extends ViewerDropAdapter {
    private static final ILogger logger = Logger.getLogger(ProjectViewDropAgent.class);
    private static final String[] supportedTypes = new String[]{"com.arcway.cockpit.plan", "com.arcway.cockpit.section"};
    private final Collection<IFileDropListener> fileDropListeners = new ArrayList<IFileDropListener>();

    public ProjectViewDropAgent(ProjectView projectView) {
        super((Viewer)projectView.getTreeViewer());
        this.setFeedbackEnabled(true);
        this.setScrollExpandEnabled(false);
        projectView.getTreeViewer().addDropSupport(23, new Transfer[]{FileTransfer.getInstance(), ProjectViewTransfer.getInstance()}, (DropTargetListener)this);
    }

    public boolean performDrop(Object data) {
        IFrameDataRW sendedData;
        Object oSended;
        Collection sendedDatas;
        boolean performed = false;
        int location = this.getCurrentLocation();
        if (data instanceof String[]) {
            String[] fileNames;
            if (location == 3 && (fileNames = (String[])data).length == 1) {
                File file = new File(fileNames[0]);
                for (IFileDropListener fileDropListener : this.fileDropListeners) {
                    boolean bl = performed = fileDropListener.fileDropped(file, this.getCurrentTarget()) || performed;
                }
            }
        } else if (data instanceof Collection && (sendedDatas = (Collection)data).size() == 1 && (oSended = sendedDatas.iterator().next()) instanceof IFrameDataRW && this.isOfSupportedType((ICockpitProjectData)(sendedData = (IFrameDataRW)oSended))) {
            IAttributeOwner target;
            final ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(sendedData.getProjectUID());
            final IFrameDataManager sendedDataManager = projectAgent.getDataManager(sendedData.getTypeID());
            Object o = this.getCurrentTarget();
            if (o.equals(projectAgent)) {
                o = projectAgent.getFrameSectionManager().getRootSection();
            }
            if (o instanceof IAttributeOwner && (target = (IAttributeOwner)o).getProjectUID().equals(sendedData.getProjectUID()) && !target.equals(sendedData)) {
                final int currentLocation = this.getCurrentLocation();
                final HashMap grantedMovePermissions = new HashMap();
                final HashMap grantedInsertBeforePermissions = new HashMap();
                final HashMap grantedInsertAfterPermissions = new HashMap();
                projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

                    @Override
                    public void run() {
                        Collection<IModificationProblem> problems;
                        IAttributeOwner oldParent;
                        Object newParent;
                        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(projectAgent);
                        if (currentLocation == 3) {
                            newParent = target;
                            if (sendedDataManager.managesChildrenForType(newParent.getTypeID()) && !(oldParent = sendedDataManager.getParent(sendedData)).equals(newParent)) {
                                sendedDataManager.requestMovePermission(sendedData, (IAttributeOwner)newParent, transactionController);
                                new FrameDataTransactionListener(sendedData, Collections.singletonMap("unspecified", newParent), grantedMovePermissions, transactionController);
                                ProjectViewDropAgent.this.requestSortPermission(sendedData, (IAttributeOwner)newParent, projectAgent, transactionController);
                                new FrameDataTransactionListener(sendedData, null, grantedInsertAfterPermissions, transactionController);
                            }
                        } else if (currentLocation == 1) {
                            if (sendedData.getTypeID().equals(target.getTypeID())) {
                                newParent = sendedDataManager.getParent(target);
                                oldParent = sendedDataManager.getParent(sendedData);
                                IAttributeOwner newSuccessor = target;
                                if (newParent instanceof ICockpitProject) {
                                    newParent = projectAgent.getFrameSectionManager().getRootSection();
                                }
                                if (!newParent.equals(oldParent)) {
                                    sendedDataManager.requestMovePermission(sendedData, (IAttributeOwner)newParent, transactionController);
                                    new FrameDataTransactionListener(sendedData, Collections.singletonMap("unspecified", newParent), grantedMovePermissions, transactionController);
                                }
                                ProjectViewDropAgent.this.requestSortPermission(sendedData, (IAttributeOwner)newParent, projectAgent, transactionController);
                                new FrameDataTransactionListener(sendedData, Collections.singletonMap("unspecified", newSuccessor), grantedInsertBeforePermissions, transactionController);
                            }
                        } else if (currentLocation == 2) {
                            if (sendedData.getTypeID().equals(target.getTypeID())) {
                                newParent = sendedDataManager.getParent(target);
                                oldParent = sendedDataManager.getParent(sendedData);
                                IAttributeOwner newPredecessor = target;
                                if (newParent instanceof ICockpitProject) {
                                    newParent = projectAgent.getFrameSectionManager().getRootSection();
                                }
                                if (!newParent.equals(oldParent)) {
                                    sendedDataManager.requestMovePermission(sendedData, (IAttributeOwner)newParent, transactionController);
                                    new FrameDataTransactionListener(sendedData, Collections.singletonMap("unspecified", newParent), grantedMovePermissions, transactionController);
                                }
                                ProjectViewDropAgent.this.requestSortPermission(sendedData, (IAttributeOwner)newParent, projectAgent, transactionController);
                                new FrameDataTransactionListener(sendedData, Collections.singletonMap("unspecified", newPredecessor), grantedInsertAfterPermissions, transactionController);
                            } else if (sendedDataManager.managesChildrenForType(target.getTypeID())) {
                                newParent = target;
                                oldParent = sendedDataManager.getParent(sendedData);
                                if (!newParent.equals(oldParent)) {
                                    sendedDataManager.requestMovePermission(sendedData, (IAttributeOwner)newParent, transactionController);
                                    new FrameDataTransactionListener(sendedData, Collections.singletonMap("unspecified", newParent), grantedMovePermissions, transactionController);
                                }
                                ProjectViewDropAgent.this.requestSortPermission(sendedData, (IAttributeOwner)newParent, projectAgent, transactionController);
                                new FrameDataTransactionListener(sendedData, null, grantedInsertAfterPermissions, transactionController);
                            }
                        }
                        if (!(problems = transactionController.execute()).isEmpty()) {
                            ModificationProblemsDialog dialog = new ModificationProblemsDialog(problems, Messages.getString("ProjectViewDropAgent.cannot_move"), ProjectViewDropAgent.this.getViewer().getControl().getShell());
                            dialog.open();
                        } else {
                            try {
                                ArrayList beforeSortings;
                                ArrayList afterSortings;
                                Collection movePermissions = (Collection)grantedMovePermissions.get(transactionController);
                                if (movePermissions != null) {
                                    sendedDataManager.moveData(transactionController);
                                }
                                if ((afterSortings = (ArrayList)grantedInsertAfterPermissions.get(transactionController)) != null) {
                                    afterSortings = new ArrayList(afterSortings);
                                    for (FrameDataTransactionListener listener : afterSortings) {
                                        IFrameDataRW dataToSort = listener.getData();
                                        IAttributeOwner parent = sendedDataManager.getParent(dataToSort);
                                        IAttributeOwner newPredecessor = listener.getAdditionalData("unspecified");
                                        if (newPredecessor != null && newPredecessor.equals(projectAgent.getFrameSectionManager().getRootSection())) {
                                            newPredecessor = null;
                                        }
                                        ISequencer sequencer = projectAgent.getFrameSequencerManager().getSequencer(parent, "add", FrameDataTypes.getDataType(dataToSort.getTypeID()));
                                        if (newPredecessor == null) {
                                            sequencer.setFirstElement((ICockpitProjectData)dataToSort);
                                            continue;
                                        }
                                        ProjectViewDropAgent.this.insertNotInsertElements(parent, sendedData.getTypeID(), projectAgent, sequencer);
                                        sequencer.insertElement((ICockpitProjectData)dataToSort, (ICockpitProjectData)newPredecessor);
                                    }
                                }
                                if ((beforeSortings = (ArrayList)grantedInsertBeforePermissions.get(transactionController)) != null) {
                                    beforeSortings = new ArrayList(beforeSortings);
                                    for (FrameDataTransactionListener listener : beforeSortings) {
                                        IFrameDataRW dataToSort = listener.getData();
                                        IAttributeOwner parent = sendedDataManager.getParent(dataToSort);
                                        IAttributeOwner newSuccessor = listener.getAdditionalData("unspecified");
                                        ISequencer sequencer = projectAgent.getFrameSequencerManager().getSequencer(parent, "add", FrameDataTypes.getDataType(dataToSort.getTypeID()));
                                        ProjectViewDropAgent.this.insertNotInsertElements(parent, sendedData.getTypeID(), projectAgent, sequencer);
                                        IAttributeOwner newPredecessor = (IAttributeOwner)sequencer.getPredecessor((ICockpitProjectData)newSuccessor);
                                        if (newPredecessor != null && newPredecessor.equals(dataToSort)) continue;
                                        if (newPredecessor == null) {
                                            sequencer.setFirstElement((ICockpitProjectData)dataToSort);
                                            continue;
                                        }
                                        sequencer.insertElement((ICockpitProjectData)dataToSort, (ICockpitProjectData)newPredecessor);
                                    }
                                }
                            }
                            catch (EXNoPermission e) {
                                logger.error("can not execute", (Throwable)e);
                            }
                            catch (EXNoLock e) {
                                logger.error("could not execute", (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
        return performed;
    }

    private void insertNotInsertElements(IAttributeOwner parent, String childTypeID, IFrameProjectAgent projectAgent, ISequencer sequencer) {
        IFrameDataManager parentDataManager = projectAgent.getDataManager(parent.getTypeID());
        ArrayList<? extends IAttributeOwner> children = new ArrayList<IAttributeOwner>(parentDataManager.getChildren(parent));
        Collections.sort(children, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ProjectViewSorter.getSingleton().compare(null, arg0, arg1);
            }
        });
        boolean isFirst = true;
        IAttributeOwner lastChild = null;
        int i = 0;
        while (i < children.size()) {
            IAttributeOwner childToInsert = (IAttributeOwner)children.get(i);
            if (childToInsert.getTypeID().equals(childTypeID)) {
                if (isFirst) {
                    sequencer.setFirstElement((ICockpitProjectData)childToInsert);
                    isFirst = false;
                } else {
                    sequencer.insertElement((ICockpitProjectData)childToInsert, (ICockpitProjectData)lastChild);
                }
                lastChild = childToInsert;
            }
            ++i;
        }
    }

    private boolean isOfSupportedType(ICockpitProjectData data) {
        String[] stringArray = supportedTypes;
        int n = supportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.equals(data.getTypeID())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void requestSortPermission(IAttributeOwner child, IAttributeOwner parent, IFrameProjectAgent projectAgent, ILocksAndPermissionsTransactionController transactionController) {
        ISequencer sequencer = projectAgent.getFrameSequencerManager().getSequencer(parent, "add", FrameDataTypes.getDataType(child.getTypeID()));
        sequencer.requestSequenceChangePermission(transactionController);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        boolean isValid = false;
        if (FileTransfer.getInstance().isSupportedType(transferType)) {
            if (this.getCurrentLocation() == 3) {
                for (IFileDropListener fileDropListener : this.fileDropListeners) {
                    if (!fileDropListener.supportsDropOnTarget(target)) continue;
                    isValid = true;
                    break;
                }
            }
        } else if (ProjectViewTransfer.getInstance().isSupportedType(transferType) && target instanceof ICockpitProjectData) {
            ICockpitProjectData sendedData;
            Object s;
            Collection sendedObjects;
            IFrameProjectAgent projectAgent;
            Object targetData = (ICockpitProjectData)target;
            if (targetData instanceof IFrameProjectAgent && (projectAgent = (IFrameProjectAgent)targetData).isOpened()) {
                targetData = projectAgent.getFrameSectionManager().getRootSection();
            }
            if ((sendedObjects = ProjectViewTransfer.getInstance().getSendedObjects()) != null && sendedObjects.size() == 1 && (s = sendedObjects.iterator().next()) instanceof ICockpitProjectData && (sendedData = (ICockpitProjectData)s).getProjectUID().equals(targetData.getProjectUID())) {
                boolean targetCanBeParent = this.targetIsParentForSendedData((ICockpitProjectData)targetData, sendedData);
                boolean targetIsParent = this.targetIsParent((ICockpitProjectData)targetData, sendedData);
                this.setScrollExpandEnabled(targetCanBeParent);
                if (this.getCurrentLocation() == 3) {
                    if (targetCanBeParent && !targetIsParent) {
                        isValid = true;
                    }
                } else if (this.getCurrentLocation() == 2) {
                    if (targetCanBeParent || sendedData.getTypeID().equals(targetData.getTypeID())) {
                        isValid = true;
                    }
                } else if (this.getCurrentLocation() == 1 && sendedData.getTypeID().equals(targetData.getTypeID())) {
                    isValid = true;
                }
            }
        }
        return isValid;
    }

    private boolean targetIsParent(ICockpitProjectData target, ICockpitProjectData sendedData) {
        if (sendedData instanceof IAttributeOwner) {
            IAttributeOwner sendedAttributeOwner = (IAttributeOwner)sendedData;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(target.getProjectUID());
            if (projectAgent.isOpened()) {
                IFrameDataManager dataManager = projectAgent.getDataManager(sendedData.getTypeID());
                IAttributeOwner parent = dataManager.getParent(sendedAttributeOwner);
                return parent.equals(target);
            }
        }
        return false;
    }

    private boolean targetIsParentForSendedData(ICockpitProjectData target, ICockpitProjectData sendedData) {
        IFrameDataManager dataManager;
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(target.getProjectUID());
        return projectAgent.isOpened() && (dataManager = projectAgent.getDataManager(sendedData.getTypeID())).managesChildrenForType(target.getTypeID());
    }

    protected void addFileDropListener(IFileDropListener fileDropListener) {
        if (!this.fileDropListeners.contains(fileDropListener)) {
            this.fileDropListeners.add(fileDropListener);
        }
    }
}

