/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTitle;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.AbstractDetailsProvider2;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTitle;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeOwnerHelper;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;

public class FrameDetailsProvider
extends AbstractDetailsProvider2
implements IExecutableExtension {
    private String id;
    private final ProjectTreeContentProvider frameLabelProvider = new ProjectTreeContentProvider(null);

    public FrameDetailsProvider() {
        this.id = UUIDGenerator.getUniqueID();
    }

    public FrameDetailsProvider(String id_) {
        this.id = id_;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null) {
            this.id = data.toString();
        }
    }

    @Override
    protected IAttributeOwner getAttributeOwner(ICockpitProjectData itemToShow) {
        if (itemToShow instanceof IAttributeOwner) {
            return (IAttributeOwner)itemToShow;
        }
        return null;
    }

    @Override
    protected List<DetailsElement> getTitleDetailsElements(ICockpitProjectData itemToShow) {
        IAttributeOwner attributeOwner = this.getAttributeOwner(itemToShow);
        if (attributeOwner != null) {
            DetailsElementTitle detailsElement = null;
            Locale projectLanguage = new Locale(ProjectMgr.getProjectMgr().getProjectAgent(itemToShow.getProjectUID()).getLanguage());
            List<IAttribute> sortedAttributes = AttributeOwnerHelper.getSortedAttributes(attributeOwner, attributeOwner.getAllAttributes());
            for (IAttribute attribute : sortedAttributes) {
                IAttributeType attributeType = attributeOwner.getAttributeType(attribute.getAttributeTypeID());
                if (attributeType.isUserDefined() || !attributeType.displayToUser()) continue;
                detailsElement = new DetailsElementTitle(null, new DetailsValueTitle(attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), ",", projectLanguage), this.getTitleImage(itemToShow)));
                break;
            }
            return detailsElement != null ? Collections.singletonList(detailsElement) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    protected List<DetailsElement> getFixAttributeDetailsElements(ICockpitProjectData itemToShow) {
        IAttributeOwner attributeOwner = this.getAttributeOwner(itemToShow);
        if (attributeOwner != null) {
            ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
            Locale projectLanguage = new Locale(ProjectMgr.getProjectMgr().getProjectAgent(itemToShow.getProjectUID()).getLanguage());
            List<IAttribute> sortedAttributes = AttributeOwnerHelper.getSortedAttributes(attributeOwner, attributeOwner.getAllAttributes());
            boolean isFirst = true;
            for (IAttribute attribute : sortedAttributes) {
                IAttributeType attributeType = attributeOwner.getAttributeType(attribute.getAttributeTypeID());
                if (attributeType.isMetaAttribute() || attributeType.isUserDefined() || !attributeType.displayToUser()) continue;
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                detailsElements.add(attributeType.getDataType().getDetailsElement(attributeType, attribute.getAttributeValue(), projectLanguage, this.getContainingShell(), this.getContainingDetailsView().getSite().getPage()));
            }
            return detailsElements;
        }
        return Collections.emptyList();
    }

    @Override
    protected final List<DetailsElement> getCustomPropertyDetailsElements(ICockpitProjectData itemToShow) {
        if (this.showCustomProperties(itemToShow)) {
            return super.getDefaultCustomPropertyDetailsElements(itemToShow);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<DetailsElement> getFooterDetailsElements(ICockpitProjectData itemToShow) {
        DetailsElement lastEditDate;
        DetailsElement lastEditor;
        DetailsElement creationDate;
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        DetailsElement creator = this.getDetailsElementForAttribute(itemToShow, AbstractAttributeTypesProvider.ATTRID_CREATOR);
        if (creator != null) {
            detailsElements.add(creator);
        }
        if ((creationDate = this.getDetailsElementForAttribute(itemToShow, AbstractAttributeTypesProvider.ATTRID_CREATION_DATE)) != null) {
            detailsElements.add(creationDate);
        }
        if ((lastEditor = this.getDetailsElementForAttribute(itemToShow, AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR)) != null) {
            detailsElements.add(lastEditor);
        }
        if ((lastEditDate = this.getDetailsElementForAttribute(itemToShow, AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE)) != null) {
            detailsElements.add(lastEditDate);
        }
        return detailsElements;
    }

    protected boolean showCustomProperties(ICockpitProjectData itemToShow) {
        return true;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Image getImage(ICockpitProjectData itemToBeDisplayed) {
        return this.frameLabelProvider.getImage(itemToBeDisplayed);
    }

    @Override
    public String getTypeName(ICockpitProjectData itemToBeDisplayed) {
        return FrameDataTypes.getDataType(itemToBeDisplayed.getTypeID()).getDisplayName();
    }

    protected final Image getTitleImage(ICockpitProjectData itemToBeDisplayed) {
        return this.getImage(itemToBeDisplayed);
    }

    @Override
    public IAction[] getToolbarActions() {
        return null;
    }

    @Override
    public boolean canBeDisplayed(ICockpitProjectData item) {
        return ProjectMgr.getProjectMgr().getProjectAgent(item.getProjectUID()).getDataManager(item.getTypeID()).getCockpitProjectData(item.getUID()) != null;
    }

    @Override
    protected void disposeResources() {
        this.frameLabelProvider.dispose();
    }
}

