/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.element;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IDetailsResourceProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValue;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSingle;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;

public class DetailsElementSingle
extends DetailsElement {
    private final String label;
    private final DetailsValue detailsValue;
    private IDetailsResourceProvider currentRessourceProvider;
    private Composite detailsLine;
    private StyledText labelWidget;
    private StyledText valueWidget;

    public DetailsElementSingle(String id, String label, DetailsValueSingle detailsValue) {
        super(id);
        this.label = label;
        this.detailsValue = detailsValue;
    }

    public Control createWidget(Composite parent_, IWorkbenchPartSite site, IDetailsResourceProvider resourceProvider) {
        this.detailsLine = new Composite(parent_, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 10;
        layout.marginTop = 4;
        layout.marginBottom = 4;
        layout.horizontalSpacing = 14;
        this.detailsLine.setLayout((Layout)layout);
        this.labelWidget = new StyledText(this.detailsLine, 8);
        this.labelWidget.setText(this.label != null ? this.label : "");
        this.labelWidget.setFont(resourceProvider.getLabelFont());
        this.labelWidget.setAlignment(131072);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = this.label != null ? this.label.length() : 0;
        styleRange.fontStyle = 1;
        this.labelWidget.setStyleRange(styleRange);
        GridData gridData = new GridData(131072, 128, false, false);
        if (this.label == null) {
            gridData.widthHint = 1;
        }
        this.labelWidget.setLayoutData((Object)gridData);
        this.valueWidget = new StyledText(this.detailsLine, 16456);
        this.valueWidget.setFont(resourceProvider.getValueFont());
        gridData = new GridData(4, 128, true, false);
        this.valueWidget.setLayoutData((Object)gridData);
        return this.detailsLine;
    }

    public void fillWidget(IDetailsResourceProvider resourceProvider) {
        this.currentRessourceProvider = resourceProvider;
        String value = this.detailsValue.getDisplayText();
        Color foregroundColour = resourceProvider.getColour(this.detailsValue.getForegroundType());
        Color backgroundColour = resourceProvider.getColour(this.detailsValue.getBackgroundType());
        if (value == null || value.equals("")) {
            value = "-";
        }
        this.valueWidget.setText(value);
        StyleRange styleRange = new StyleRange();
        styleRange.fontStyle = 0;
        styleRange.foreground = foregroundColour;
        styleRange.start = 0;
        styleRange.length = value.length();
        this.valueWidget.setStyleRange(styleRange);
        this.labelWidget.setBackground(backgroundColour);
        this.valueWidget.setBackground(backgroundColour);
        this.detailsLine.setBackground(backgroundColour);
    }

    public int getMinimumWidth() {
        return this.labelWidget.computeSize((int)-1, (int)-1).x + ((GridLayout)this.detailsLine.getLayout()).marginWidth * 2 + ((GridLayout)this.detailsLine.getLayout()).marginLeft + ((GridLayout)this.detailsLine.getLayout()).marginRight + 100;
    }

    public void setHighlighted(boolean highlighted) {
        if (this.detailsValue != null) {
            Color background = highlighted ? this.currentRessourceProvider.getColour(101) : this.currentRessourceProvider.getColour(100);
            this.labelWidget.setBackground(background);
            this.valueWidget.setBackground(background);
            this.detailsLine.setBackground(background);
        }
    }

    public void setGrayed(boolean grayed) {
        if (this.detailsValue != null) {
            Color background = grayed ? this.currentRessourceProvider.getColour(102) : this.currentRessourceProvider.getColour(100);
            this.labelWidget.setBackground(background);
            this.valueWidget.setBackground(background);
            this.detailsLine.setBackground(background);
        }
    }

    public boolean showsEqualValues(DetailsElement detailsElement) {
        if (!(detailsElement instanceof DetailsElementSingle)) {
            return false;
        }
        DetailsElementSingle elementToCompare = (DetailsElementSingle)detailsElement;
        if (this.detailsValue == null || elementToCompare.detailsValue == null) {
            return false;
        }
        return this.detailsValue.getDisplayText().equals(elementToCompare.detailsValue.getDisplayText());
    }
}

