/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.validators;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import org.eclipse.jface.dialogs.IInputValidator;

public class RenameSectionValidator
implements IInputValidator {
    private final ISection parentSection;
    private final ISection originalSection;
    private final IFrameProjectAgent projectAgent;

    public RenameSectionValidator(IFrameProjectAgent projectAgent, ISection parentSection) {
        assert (parentSection != null);
        this.parentSection = parentSection;
        this.originalSection = null;
        this.projectAgent = projectAgent;
    }

    public RenameSectionValidator(IFrameProjectAgent projectAgent, ISection parentSection, ISection sectionToRename) {
        assert (parentSection != null);
        assert (sectionToRename != null);
        this.parentSection = parentSection;
        this.originalSection = sectionToRename;
        this.projectAgent = projectAgent;
    }

    public String isValid(String newText) {
        if (newText.trim().equals("")) {
            return Messages.getString("RenameSectionValidator.The_name_of_a_section_can__t_be_empty_!_3");
        }
        if (newText.length() > 255) {
            return String.valueOf(Messages.getString("RenameSectionValidator.0")) + 255 + Messages.getString("RenameSectionValidator.1");
        }
        if (this.sectionAlreadyExistsWithinParent(newText.trim())) {
            return Messages.getString("RenameSectionValidator.The_parent_folder_already_contains_a_folder_with_that_name_!_5");
        }
        return null;
    }

    private boolean sectionAlreadyExistsWithinParent(String sectionName) {
        for (ISection iSection : this.projectAgent.getFrameSectionManager().getChildSections(this.parentSection)) {
            if (!iSection.getSectionName().equalsIgnoreCase(sectionName) || this.originalSection != null && iSection.getUID().equals(this.originalSection.getUID())) continue;
            return true;
        }
        return false;
    }
}

