/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.cockpitadapter.EOCommitCountAndCommitInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyProjectHistory
implements IPropertiesListEntry,
ISelectionChangedListener {
    private List<EOCommitCountAndCommitInformation> projectHistory;
    private List<EOCommitCountAndCommitInformation> projectHistory_entriesWithCommentOnly;
    private IFrameProjectAgent project;
    private IPropertiesDialog dialog;
    private TableViewer tableViewer;
    private Text description;

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.project = (IFrameProjectAgent)elements[0];
        this.dialog = newDialog;
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1 && elements[0] instanceof IFrameProjectAgent) {
            IFrameProjectAgent projectAgent = (IFrameProjectAgent)elements[0];
            return projectAgent.isOpened() && (projectAgent.getFrameServerProxy().supportsVersioning() || projectAgent.getOfflineModeManager().isInOfflineMode());
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyProjectHistory.Name");
    }

    @Override
    public Image getPropertyImage() {
        return null;
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        Composite child = new Composite(parent, 0);
        child.setLayoutData((Object)new GridData(1808));
        child.setLayout((Layout)new GridLayout());
        final Button emptyCommentFilterCheckbox = new Button(child, 32);
        emptyCommentFilterCheckbox.setText(Messages.getString("PropertyProjectHistory.EmptyCommentFilterCheckbox.Label"));
        GridDataFactory.fillDefaults().align(1, 2).grab(true, false).applyTo((Control)emptyCommentFilterCheckbox);
        emptyCommentFilterCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (emptyCommentFilterCheckbox.getSelection()) {
                    PropertyProjectHistory.this.tableViewer.setInput((Object)PropertyProjectHistory.this.projectHistory_entriesWithCommentOnly);
                } else {
                    PropertyProjectHistory.this.tableViewer.setInput((Object)PropertyProjectHistory.this.projectHistory);
                }
                PropertyProjectHistory.this.tableViewer.refresh();
            }
        });
        this.tableViewer = new TableViewer(child, 68356);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        TableColumn versionColumn = new TableColumn(this.tableViewer.getTable(), 0);
        versionColumn.setText(Messages.getString("PropertyProjectHistory.Version"));
        versionColumn.pack();
        TableColumn dateColumn = new TableColumn(this.tableViewer.getTable(), 0);
        dateColumn.setText(Messages.getString("PropertyProjectHistory.CommitDate"));
        dateColumn.setWidth(130);
        TableColumn userColumn = new TableColumn(this.tableViewer.getTable(), 0);
        userColumn.setText(Messages.getString("PropertyProjectHistory.CommitUser"));
        userColumn.setWidth(120);
        TableColumn commentColumn2 = new TableColumn(this.tableViewer.getTable(), 0);
        commentColumn2.setText(Messages.getString("PropertyProjectHistory.CommitComment"));
        commentColumn2.setWidth(240);
        GridData tableGridData = new GridData(1808);
        tableGridData.horizontalSpan = 2;
        this.tableViewer.getTable().setLayoutData((Object)tableGridData);
        this.tableViewer.setContentProvider((IContentProvider)new HistoryTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HistoryTableLabelProvider());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.projectHistory = this.project.getCockpitController().getCommitInformations();
        Collections.reverse(this.projectHistory);
        this.projectHistory_entriesWithCommentOnly = new ArrayList<EOCommitCountAndCommitInformation>(this.projectHistory.size());
        for (EOCommitCountAndCommitInformation historyEntry : this.projectHistory) {
            if (historyEntry.getCommitInformation().getCommitComment().trim().length() == 0) continue;
            this.projectHistory_entriesWithCommentOnly.add(historyEntry);
        }
        this.tableViewer.setInput(this.projectHistory);
        this.description = new Text(child, 2114);
        this.description.setText("\n\n\n\n\n");
        this.description.setEditable(false);
        GridData descriptionGridData = new GridData(1808);
        descriptionGridData.horizontalSpan = 1;
        this.description.setLayoutData((Object)descriptionGridData);
        this.dialog.setTitle(Messages.getString("PropertyProjectHistory.Title"), this);
        this.dialog.setMessage(Messages.getString("PropertyProjectHistory.Message"), 0, this);
        return child;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        EOCommitCountAndCommitInformation selectedHistoryItem = (EOCommitCountAndCommitInformation)selection.getFirstElement();
        if (selectedHistoryItem != null) {
            this.description.setText(selectedHistoryItem.getCommitInformation().getCommitComment());
        } else {
            this.description.setText("");
        }
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return false;
    }

    @Override
    public void commitPropertyChanges1() {
    }

    public Collection<IModificationProblem> requestCommit() {
        return Collections.emptyList();
    }

    @Override
    public void rollbackCommitRequest() {
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
    }

    @Override
    public int getTypeOfPage() {
        return 40;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        return Collections.emptyList();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return null;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }

    private class HistoryTableContentProvider
    implements IStructuredContentProvider {
        private HistoryTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List history = (List)inputElement;
            return history.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class HistoryTableLabelProvider
    implements ITableLabelProvider {
        private HistoryTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                EOCommitCountAndCommitInformation item = (EOCommitCountAndCommitInformation)element;
                return Integer.toString(item.getCommitCount());
            }
            if (columnIndex == 1) {
                EOCommitCountAndCommitInformation item = (EOCommitCountAndCommitInformation)element;
                PresentationContext context = PresentationContext.getVirtualMachineUserLocaleForNow();
                String date = context.convertDateAndTimeWithoutSecondsToString(item.getCommitInformation().getCommitDate(), new Locale(PropertyProjectHistory.this.project.getLanguage()));
                return date;
            }
            if (columnIndex == 2) {
                EOCommitCountAndCommitInformation item = (EOCommitCountAndCommitInformation)element;
                String realName = item.getCommitInformation().getCommitingUserInformation().getRealName();
                if (realName == null) {
                    realName = "";
                }
                return item.getCommitInformation().getCommitingUserInformation().getRealName();
            }
            if (columnIndex == 3) {
                EOCommitCountAndCommitInformation item = (EOCommitCountAndCommitInformation)element;
                return item.getCommitInformation().getCommitComment();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

