/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.ModificationRootItem;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import de.plans.lib.util.gui.DecoratingLabelProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PlanChooserDialog
extends TitleAreaDialog {
    private final IFrameProjectAgent projectAgent;
    private final Collection<? extends IPlan> plans;
    private final Collection<? extends IPlan> refiningPlans;
    private IPlan selectedPlan;
    private final String message;
    private boolean firstTimeSelection = true;
    private ProjectTreeContentProvider contentProvider;
    private static Map<String, Image> plansDecoratedWithRefiningDecore = new HashMap<String, Image>();

    public PlanChooserDialog(Collection<? extends IPlan> plans, Collection<? extends IPlan> refiningPlans, String message, IProjectAgent projectAgent, Shell parentShell) {
        super(parentShell);
        assert (plans != null);
        assert (refiningPlans != null);
        assert (projectAgent != null);
        this.message = message == null ? "" : message;
        this.plans = plans;
        this.refiningPlans = refiningPlans;
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectAgent.getProjectUID());
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("PlanChooserDialog.choose_plan"));
        this.setMessage(this.message);
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        TreeViewer treeViewer = new TreeViewer(base, 4);
        treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new ProjectTreeContentProvider(null);
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)this.contentProvider);
        labelProvider.addLabelDecorator(new ILabelDecorator(){

            public Image decorateImage(Image image, Object element) {
                if (element instanceof IPlan) {
                    IPlan plan = (IPlan)element;
                    if (PlanChooserDialog.this.refiningPlans.contains(plan)) {
                        String plantypeUID = plan.getPlantypeUID();
                        if (!plansDecoratedWithRefiningDecore.containsKey(plantypeUID)) {
                            DecoratedImageDescriptor dd = new DecoratedImageDescriptor(image);
                            ImageDescriptor refineSymbol = Icons.getImageDescriptorRefinementDecorator();
                            dd.addDecorator(refineSymbol, 3);
                            plansDecoratedWithRefiningDecore.put(plantypeUID, dd.createImage());
                        }
                        return (Image)plansDecoratedWithRefiningDecore.get(plantypeUID);
                    }
                }
                return image;
            }

            public String decorateText(String text, Object element) {
                return text;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        treeViewer.setSorter((ViewerSorter)ProjectViewSorter.getSingleton());
        treeViewer.addFilter((ViewerFilter)new TreeFilter());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PlanChooserDialog.this.setSelectedPlan(event.getSelection());
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PlanChooserDialog.this.setSelectedPlan(event.getSelection());
                if (PlanChooserDialog.this.selectedPlan != null) {
                    PlanChooserDialog.this.okPressed();
                }
            }
        });
        treeViewer.setInput((Object)this.projectAgent);
        treeViewer.expandAll();
        return base;
    }

    private void setSelectedPlan(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectedPlan = null;
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object o = sel.getFirstElement();
            if (o instanceof IPlan) {
                this.selectedPlan = (IPlan)o;
            }
            this.refresh();
        }
    }

    private void refresh() {
        if (this.selectedPlan == null) {
            this.getButton(0).setEnabled(false);
            if (!this.firstTimeSelection) {
                this.setErrorMessage(Messages.getString("PlanChooserDialog.choose_plan"));
            } else {
                this.firstTimeSelection = false;
            }
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }

    protected void cancelPressed() {
        this.selectedPlan = null;
        super.cancelPressed();
    }

    public IPlan getSelectedPlan() {
        return this.selectedPlan;
    }

    private class TreeFilter
    extends ViewerFilter {
        private TreeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IPlan) {
                return this.isWantedPlan((IPlan)element);
            }
            return this.hasWantedPlanAsChild(element);
        }

        private boolean hasWantedPlanAsChild(Object element) {
            if (!(element instanceof ModificationRootItem) && PlanChooserDialog.this.contentProvider.hasChildren(element)) {
                Object[] children;
                Object[] objectArray = children = PlanChooserDialog.this.contentProvider.getChildren(element);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (child instanceof IPlan ? this.isWantedPlan((IPlan)child) : this.hasWantedPlanAsChild(child)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        private boolean isWantedPlan(IPlan plan) {
            for (IPlan wPlan : PlanChooserDialog.this.plans) {
                if (!wPlan.getUID().equals(plan.getUID())) continue;
                return true;
            }
            return false;
        }
    }
}

