/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.PermissionsAdminDialog;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.FramePermissionDefinitions;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

public class ProjectPermissionsManageAction
extends Action
implements ILabelProvider {
    private static final ILogger logger = Logger.getLogger(ProjectPermissionsManageAction.class);
    private final IWorkbenchPage workbenchPage;
    private final ISelection selection;

    public ProjectPermissionsManageAction(ISelection selection, IWorkbenchPage page) {
        this.selection = selection;
        this.workbenchPage = page;
        this.setText(Messages.getString("ProjectPermissionsManageAction.Manage_Permissions_1"));
    }

    private IFrameProjectAgent getSelectedProjectAgent() {
        if (this.selection.isEmpty()) {
            return null;
        }
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.selection;
            if (sel.size() != 1) {
                return null;
            }
            if (sel.getFirstElement() instanceof IFrameProjectAgent) {
                return (IFrameProjectAgent)sel.getFirstElement();
            }
        }
        return null;
    }

    public void update() {
        IFrameProjectAgent projectAgent = this.getSelectedProjectAgent();
        if (projectAgent != null && projectAgent.isOpened() && ProjectMgr.getProjectMgr().getProjectManagerServerProxy(projectAgent.getServerID()).arePermissionsNeeded() && projectAgent.getFramePermissionChecker().hasPermission(FramePermissionDefinitions.ADMIN_PERMISSIONS_TEMPLATE, projectAgent)) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        IFrameProjectAgent projectAgent = this.getSelectedProjectAgent();
        if (projectAgent != null && projectAgent.isOpened()) {
            try {
                projectAgent.getFrameServerProxy().refreshProject();
            }
            catch (ServerNotAvailableException e) {
                logger.warn("No refresh possible before open permission admin dialog.", (Throwable)e);
            }
            catch (EXServerException e) {
                logger.warn("No refresh possible before open permission admin dialog.", (Throwable)e);
            }
            catch (LoginCanceledException e) {
                logger.warn("No refresh possible before open permission admin dialog.", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.warn("No refresh possible before open permission admin dialog.", (Throwable)e);
            }
            PermissionsAdminDialog dialog = new PermissionsAdminDialog(projectAgent, this.workbenchPage);
            dialog.open();
        }
    }

    public void dispose() {
    }

    public String getText(Object element) {
        assert (element instanceof CockpitPermissionTemplate) : "invalid element type " + element.getClass();
        CockpitPermissionTemplate p = (CockpitPermissionTemplate)((Object)element);
        return p.getPermissionName();
    }

    public Image getImage(Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

