/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderManager;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.stakeholders.RoleList;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderList;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorControllerExtension;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorPlan;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorPlanElement;
import de.plans.psc.client.communication.ServerConnection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ProjectSelectionAnalyser {
    public static String extractProjectUID(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        String projectUID = null;
        for (Object selectedItem : ((IStructuredSelection)selection).toList()) {
            String projectUIDOfCurrentElement = ProjectSelectionAnalyser.getProjectUIDOf(selectedItem);
            if (projectUIDOfCurrentElement != null) {
                if (projectUID == null) {
                    projectUID = projectUIDOfCurrentElement;
                    continue;
                }
                if (projectUID.equals(projectUIDOfCurrentElement)) continue;
                return null;
            }
            return null;
        }
        return projectUID;
    }

    public static String extractServerID(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        String serverID = null;
        for (Object selectedItem : ((IStructuredSelection)selection).toList()) {
            String serverIDOfCurrentElement = null;
            if (selectedItem instanceof ServerConnection) {
                serverIDOfCurrentElement = ((ServerConnection)selectedItem).getServerID();
            } else {
                ProjectAgent projectAgent;
                String projectUIDOfCurrentElement = ProjectSelectionAnalyser.getProjectUIDOf(selectedItem);
                if (projectUIDOfCurrentElement != null && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUIDOfCurrentElement)) != null) {
                    serverIDOfCurrentElement = projectAgent.getServerID();
                }
            }
            if (serverIDOfCurrentElement != null) {
                if (serverID == null) {
                    serverID = serverIDOfCurrentElement;
                    continue;
                }
                if (serverID.equals(serverIDOfCurrentElement)) continue;
                return null;
            }
            return null;
        }
        return serverID;
    }

    private static String getProjectUIDOf(Object element) {
        String projectUIDOfCurrentElement = null;
        if (element instanceof ICockpitProjectData) {
            projectUIDOfCurrentElement = ((ICockpitProjectData)element).getProjectUID();
        } else if (element instanceof IPlanEditorPlanElement) {
            IPlanEditorPlanElement planElement = (IPlanEditorPlanElement)element;
            if (ProjectSelectionAnalyser.isPlanElementAssociatedWithUniqueElement(planElement)) {
                projectUIDOfCurrentElement = ProjectSelectionAnalyser.getProjectForPlanElement(planElement);
            } else {
                PlanEditorControllerExtension planEditorControllerExtension = ProjectSelectionAnalyser.getPlanEditorControllerExtension(planElement);
                if (planEditorControllerExtension != null) {
                    projectUIDOfCurrentElement = planEditorControllerExtension.getProjectAgent().getProjectUID();
                }
            }
        } else if (element instanceof IPlanEditorPlan) {
            IPlanEditorPlan plan = (IPlanEditorPlan)element;
            projectUIDOfCurrentElement = ProjectSelectionAnalyser.getProjectForPlan(plan);
        } else if (element instanceof IStakeholderManager) {
            projectUIDOfCurrentElement = ((IStakeholderManager)element).getProjectUID();
        } else if (element instanceof StakeholderList) {
            projectUIDOfCurrentElement = ((StakeholderList)element).getProjectUID();
        } else if (element instanceof RoleList) {
            projectUIDOfCurrentElement = ((RoleList)element).getProjectUID();
        }
        return projectUIDOfCurrentElement;
    }

    public static boolean isPlanElementAssociatedWithUniqueElement(IPlanEditorPlanElement planElement) {
        return ProjectSelectionAnalyser.getAssociatedUniqueElementForPlanElement(planElement) != null;
    }

    public static IUniqueElement getAssociatedUniqueElementForPlanElement(IPlanEditorPlanElement planElement) {
        PlanEditorControllerExtension controllerExtension = ProjectSelectionAnalyser.getPlanEditorControllerExtension(planElement);
        if (controllerExtension != null) {
            return controllerExtension.findUniqueElement((IPlanAgentPlanElement)planElement);
        }
        return null;
    }

    public static String getProjectForPlanElement(IPlanEditorPlanElement planElement) {
        PlanEditorControllerExtension controllerExtension = ProjectSelectionAnalyser.getPlanEditorControllerExtension(planElement);
        if (controllerExtension != null) {
            return controllerExtension.getProjectAgent().getProjectUID();
        }
        return null;
    }

    public static String getProjectForPlan(IPlanEditorPlan plan) {
        PlanEditorControllerExtension controllerExtension = ProjectSelectionAnalyser.getPlanEditorControllerExtension(plan);
        if (controllerExtension != null) {
            return controllerExtension.getProjectAgent().getProjectUID();
        }
        return null;
    }

    private static PlanEditorControllerExtension getPlanEditorControllerExtension(IPlanEditorPlanElement planElement) {
        IPlanEditorControllerExtension controllerExtension = planElement.getPlanEditorControllerExtension();
        if (controllerExtension instanceof PlanEditorControllerExtension) {
            return (PlanEditorControllerExtension)controllerExtension;
        }
        return null;
    }

    private static PlanEditorControllerExtension getPlanEditorControllerExtension(IPlanEditorPlan plan) {
        IPlanEditorControllerExtension controllerExtension = plan.getPlanEditorControllerExtension();
        if (controllerExtension instanceof PlanEditorControllerExtension) {
            return (PlanEditorControllerExtension)controllerExtension;
        }
        return null;
    }
}

