/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class CockpitProjectDataChoicePage<T extends ICockpitProjectData> {
    private ListViewer proposedList;
    private ListViewer selectedList;
    private Button btnAddSelected;
    private Button btnRemoveSelected;

    protected CockpitProjectDataChoicePage() {
    }

    protected Composite createPage(Composite parent, final Set<T> proposeInput, final Set<T> selectedInput, final Set<T> dataToAdd, final Set<T> dataToRemove) {
        final HashSet<T> originalSelectedInput = new HashSet<T>(selectedInput);
        final HashSet<T> originalProposedInput = new HashSet<T>(proposeInput);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        Group g1 = new Group(composite, 0);
        g1.setText(this.getSelectedGroupLabel());
        g1.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        g1.setLayoutData((Object)gridData);
        this.selectedList = new ListViewer((Composite)g1, 2);
        gridData = new GridData(4, 4, true, true);
        this.selectedList.getList().setLayoutData((Object)gridData);
        this.selectedList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CockpitProjectDataChoicePage.this.refreshButtonStates();
            }
        });
        this.selectedList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectedList.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.selectedList.setSorter(new ViewerSorter());
        this.selectedList.setInput(selectedInput);
        Composite buttonBar = new Composite(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 1;
        buttonBar.setLayout((Layout)gl);
        gridData = new GridData();
        gridData.verticalAlignment = 2;
        buttonBar.setLayoutData((Object)gridData);
        this.btnAddSelected = new Button(buttonBar, 8);
        this.btnAddSelected.setText("<");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnAddSelected.setLayoutData((Object)gridData);
        this.btnAddSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CockpitProjectDataChoicePage.this.proposedList.getSelection();
                for (Object element : selection) {
                    ICockpitProjectData data = (ICockpitProjectData)element;
                    selectedInput.add(data);
                    if (!originalSelectedInput.contains(data)) {
                        dataToAdd.add(data);
                    }
                    proposeInput.remove(data);
                    dataToRemove.remove(data);
                }
                CockpitProjectDataChoicePage.this.proposedList.refresh();
                CockpitProjectDataChoicePage.this.selectedList.refresh();
                CockpitProjectDataChoicePage.this.refreshButtonStates();
            }
        });
        this.btnRemoveSelected = new Button(buttonBar, 8);
        this.btnRemoveSelected.setText(">");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnRemoveSelected.setLayoutData((Object)gridData);
        this.btnRemoveSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CockpitProjectDataChoicePage.this.selectedList.getSelection();
                for (Object element : selection) {
                    ICockpitProjectData data = (ICockpitProjectData)element;
                    proposeInput.add(data);
                    if (!originalProposedInput.contains(data)) {
                        dataToRemove.add(data);
                    }
                    selectedInput.remove(data);
                    dataToAdd.remove(data);
                }
                CockpitProjectDataChoicePage.this.selectedList.refresh();
                CockpitProjectDataChoicePage.this.proposedList.refresh();
                CockpitProjectDataChoicePage.this.refreshButtonStates();
            }
        });
        Group g2 = new Group(composite, 0);
        g2.setText(this.getProposeGroupLabel());
        g2.setLayout((Layout)new GridLayout());
        gridData = new GridData(4, 4, true, true);
        g2.setLayoutData((Object)gridData);
        this.proposedList = new ListViewer((Composite)g2, 2);
        gridData = new GridData(4, 4, true, true);
        this.proposedList.getList().setLayoutData((Object)gridData);
        this.proposedList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CockpitProjectDataChoicePage.this.refreshButtonStates();
            }
        });
        this.proposedList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.proposedList.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.proposedList.setSorter(new ViewerSorter());
        this.proposedList.setInput(proposeInput);
        this.refreshButtonStates();
        return composite;
    }

    private void refreshButtonStates() {
        if (this.proposedList.getList().getItemCount() > 0) {
            if (this.proposedList.getList().getSelectionCount() > 0) {
                this.btnAddSelected.setEnabled(true);
            } else {
                this.btnAddSelected.setEnabled(false);
            }
        } else {
            this.btnAddSelected.setEnabled(false);
        }
        if (this.selectedList.getList().getItemCount() > 0) {
            if (this.selectedList.getList().getSelectionCount() > 0) {
                this.btnRemoveSelected.setEnabled(true);
            } else {
                this.btnRemoveSelected.setEnabled(false);
            }
        } else {
            this.btnRemoveSelected.setEnabled(false);
        }
    }

    protected abstract ILabelProvider getLabelProvider();

    protected abstract String getProposeGroupLabel();

    protected abstract String getSelectedGroupLabel();
}

