/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.messages;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.ManagePathPrefixesDialog;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.PathPrefixMapping;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.documentmodule.client.messages.description.RLFileSystemLinkDescription;
import com.arcway.cockpit.documentmodule.shared.ModuleIdentification;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.ModuleLabelProvider;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.resources.ModuleIconResource;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import de.plans.lib.localisation.ILabelProvider;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class RLFileSystemLink
extends ResourceLocator {
    public static final String DATA_TYPE_UID = "dcm.filesystemlink";
    public static final String MODULE_DATA_NAME_KEY = "RLFileSystemLink.ModuleDataName";
    public static final String MODULE_DATA_NAME = Messages.getString("RLFileSystemLink.ModuleDataName");
    public static final String IMAGE_NAME = "filesystemlink.gif";
    public static final int ALL_URLS = 0;
    public static final int ONLY_LOCAL_URLS = 1;
    public static final int ONLY_PREMAPPED_URLS = 2;
    public static final String LINK_STATE_NAME = Messages.getString("RLFileSystemLink.LinkStateName");
    private static final DiscreteValue[] LINK_STATES = new DiscreteValue[]{new DiscreteValue((ILabelProvider)new ModuleLabelProvider("RLFileSystemLink.linkStateUnknown", Messages.class)), new DiscreteValue((ILabelProvider)new ModuleLabelProvider("RLFileSystemLink.linkStateNotChecked", Messages.class), (IIconResource)new ModuleIconResource((AbstractModulePlugin)DocumentModulePlugin.getDefault(), "link_unknown.gif")), new DiscreteValue((ILabelProvider)new ModuleLabelProvider("RLFileSystemLink.linkStateOK", Messages.class), (IIconResource)new ModuleIconResource((AbstractModulePlugin)DocumentModulePlugin.getDefault(), "link_ok.gif")), new DiscreteValue((ILabelProvider)new ModuleLabelProvider("RLFileSystemLink.linkStateDoesNotExist", Messages.class), (IIconResource)new ModuleIconResource((AbstractModulePlugin)DocumentModulePlugin.getDefault(), "link_broken.gif"))};
    public static final int LINK_STATE_UNKNOWN = 0;
    public static final int LINK_STATE_NOT_CHECKED = 1;
    public static final int LINK_STATE_OK = 2;
    public static final int LINK_STATE_DOES_NOT_EXIST = 3;
    public static final String PREDEFINED_MAPPING = "com.arcway.cockpit.documentmodule.PREDEFINED_MAPPING";
    public static IModuleDataTypeDescription DATA_TYPE_DESCRIPTION = new RLFileSystemLinkDescription();
    private final ModuleDataAttributeDiscrete linkState = new ModuleDataAttributeDiscrete(RLFileSystemLink.getLinkStateKeys(), 1);
    private String localURL;
    private ModuleDataAttributeString preMappedURL = new ModuleDataAttributeString(1);

    public static DiscreteValue[] getLinkStateKeys() {
        return LINK_STATES;
    }

    public RLFileSystemLink() {
    }

    public Image getIconForFile() {
        ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.getPreMappedURL().getValue());
        return DocumentModulePlugin.getDefault().getImageDescriptorRegistry().get(desc);
    }

    public RLFileSystemLink(EOModuleData eo) {
        this();
        assert (eo != null && this.getTypeID().equals(eo.getTypeID()));
        this.fillWithEncodableObject(eo);
        this.linkState.setValue(1);
        this.preMappedURL = new ModuleDataAttributeString(1);
    }

    public ModuleDataAttributeDiscrete getLinkState() {
        return this.linkState;
    }

    public boolean calculateLinkState() {
        int currentLinkState = this.getLinkState().getValue();
        File file = new File(this.getLocalURL());
        try {
            if (file.exists()) {
                this.linkState.setValue(2);
            } else {
                this.linkState.setValue(3);
            }
        }
        catch (SecurityException e) {
            this.linkState.setValue(0);
        }
        return currentLinkState != this.getLinkState().getValue();
    }

    @Deprecated
    public void resetLinkState() {
        this.linkState.setValue(1);
    }

    public void calculateLocalURLs(int url, IProjectAgent projectAgent) {
        if (url == 2) {
            RLFileSystemLink.recalculatePreMappedURL(this);
        } else if (url == 1) {
            RLFileSystemLink.recalculateLocalURL(this, projectAgent);
        } else {
            RLFileSystemLink.recalculatePreMappedURL(this);
            RLFileSystemLink.recalculateLocalURL(this, projectAgent);
        }
    }

    public String getTypeID() {
        return DATA_TYPE_UID;
    }

    public String getDisplayRepresentation() {
        return this.getLocalURL();
    }

    public void setDisplayRepresentation(String displayRepresentation) {
    }

    public String getLocalURL() {
        return this.localURL != null && !this.localURL.equals("") ? this.localURL : this.getPreMappedURL().getDisplayStringRepresentation();
    }

    private void setLocalURL(String newURL) {
        assert (newURL != null);
        this.localURL = newURL;
    }

    public ModuleDataAttributeString getPreMappedURL() {
        return this.preMappedURL;
    }

    private void setPreMappedURL(ModuleDataAttributeString newURL) {
        assert (newURL != null);
        this.preMappedURL = newURL;
    }

    public String getShortenedURL() {
        File file = new File(this.getLocalURL());
        return file.getName();
    }

    private static void recalculateLocalURL(RLFileSystemLink link, IProjectAgent projectAgent) {
        link.setLocalURL("");
        String serverURL = link.getPreMappedURL().getDisplayStringRepresentation();
        if (serverURL.length() > 0) {
            String firstOfServer = serverURL.substring(0, 1);
            String compareOfServer = serverURL.substring(1);
            String projectMappingsString = projectAgent.getLocalSettings(ModuleIdentification.getModuleID()).getString("project_path_alignment");
            if (projectMappingsString == null) {
                projectMappingsString = "";
            }
            ArrayList<PathPrefixMapping> projectMappings = ManagePathPrefixesDialog.decodeAlignmentStrings(projectMappingsString, false);
            ArrayList<PathPrefixMapping> globalMappings = ManagePathPrefixesDialog.decodeAlignmentStrings(DocumentModulePlugin.getDefault().getPreferenceStore().getString("global_path_alignment"), true);
            for (PathPrefixMapping mapping : globalMappings) {
                projectMappings.add(ManagePathPrefixesDialog.getInsertIndex(projectMappings, mapping), mapping);
            }
            for (PathPrefixMapping mapping : projectMappings) {
                String sourcePrefix = mapping.getSubPathToReplace().getValue();
                if (!mapping.isActive()) continue;
                if (sourcePrefix.length() > 2 && serverURL.length() > 2 && sourcePrefix.substring(1, 3).equals(":\\") && serverURL.substring(1, 3).equals(":\\")) {
                    String firstOfMapping = sourcePrefix.substring(0, 1);
                    String compareOfMapping = sourcePrefix.substring(1);
                    if (!firstOfServer.equalsIgnoreCase(firstOfMapping) || !compareOfServer.startsWith(compareOfMapping)) continue;
                    link.setLocalURL(serverURL.substring(sourcePrefix.length()));
                    link.setLocalURL(mapping.getReplacePath().getValue().concat(link.getLocalURL()));
                    break;
                }
                if (!serverURL.startsWith(sourcePrefix)) continue;
                link.setLocalURL(serverURL.substring(sourcePrefix.length()));
                link.setLocalURL(mapping.getReplacePath().getValue().concat(link.getLocalURL()));
            }
        }
        if (link.getLocalURL().equals("")) {
            link.setLocalURL(link.getPreMappedURL().getDisplayStringRepresentation());
        }
    }

    private static void recalculatePreMappedURL(RLFileSystemLink link) {
        ModuleDataAttributeString preMappedURLAttribute = link.getPreMappedURL();
        String serverURL = link.getURL().getDisplayStringRepresentation();
        if (serverURL.startsWith(PREDEFINED_MAPPING)) {
            String eclipseInstallPath = System.getProperty("osgi.install.area").substring(6);
            File file = new File(eclipseInstallPath);
            try {
                eclipseInstallPath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String newURL = serverURL.substring(PREDEFINED_MAPPING.length());
            newURL = eclipseInstallPath.concat(newURL);
            preMappedURLAttribute.setValue(newURL);
        } else {
            preMappedURLAttribute.setValue(serverURL);
        }
        link.setPreMappedURL(preMappedURLAttribute);
    }

    protected final IModuleDataTypeDescription getTypeDescription_internal() {
        return DATA_TYPE_DESCRIPTION;
    }
}

