/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.menu.handlers;

import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.eclipse.file.UrlLauncher;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHOpenLink
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IModelController modelController;
        IStructuredSelection currentSelection = CommandHandlerHelper.getRelevantSelection((ExecutionEvent)event);
        String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)currentSelection);
        if (projectUID != null && (modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUID)) != null) {
            ArrayList<IModuleData> toBeOpened = new ArrayList<IModuleData>();
            for (Object o : currentSelection.toList()) {
                if (!(o instanceof IModuleData)) continue;
                toBeOpened.add((IModuleData)o);
            }
            for (IModuleData selectedObject : toBeOpened) {
                CHOpenLink.openSelectedObject(selectedObject, HandlerUtil.getActiveSite((ExecutionEvent)event).getPage());
            }
        }
        return null;
    }

    public static void openSelectedObject(Object selectedObject, IWorkbenchPage workbenchPage) {
        if (selectedObject instanceof ResourceLocator) {
            CHOpenLink.openResourceLocator((ResourceLocator)((Object)selectedObject), workbenchPage);
        }
    }

    public static void openResourceLocator(ResourceLocator resourceLocator, IWorkbenchPage workbenchPage) {
        if (resourceLocator instanceof RLFileSystemLink) {
            CHOpenLink.openFile((RLFileSystemLink)resourceLocator, workbenchPage);
        } else if (resourceLocator instanceof RLWebLink) {
            String url = ((RLWebLink)resourceLocator).getURL().getValue();
            UrlLauncher.launchUrl_noEx((String)url, (IWorkbenchPage)workbenchPage);
        } else assert (false) : "Unknown ResourceLocator Subtype";
    }

    public static void openFile(RLFileSystemLink link, IWorkbenchPage workbenchPage) {
        boolean stateChanged = link.calculateLinkState();
        IModelController modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(link.getProjectUID());
        if (stateChanged) {
            modelController.getPropertyChangesManager().signalPropertyChanges(null, (Object)link, null, RLFileSystemLink.class);
        }
        if (link.getLinkState().getValue() != 2) {
            CHOpenLink.showErrorMsg();
            return;
        }
        Path location = new Path(link.getLocalURL());
        UrlLauncher.launchFile_noEx((File)location.toFile(), (IWorkbenchPage)workbenchPage);
    }

    private static void showErrorMsg() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog mDialog = new MessageDialog(shell, Messages.getString("ActionDelegateOpenFile.OpenFileErrorHead"), null, Messages.getString("ActionDelegateOpenFile.OpenFileErrorMsg"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        mDialog.open();
    }
}

