/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.linkviewcontribution;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesProviderManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMLinkItems;
import com.arcway.cockpit.documentmodule.client.gui.linkviewcontribution.DocumentLinks;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.IDocumentContainer;
import com.arcway.cockpit.documentmodule.shared.messages.DCMLinkTypeHelper_Shared;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IndirectLinksContainer;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractLinkContentProvider;
import com.arcway.cockpit.modulelib2.client.gui.IUserInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class LinkContentProvider
extends AbstractLinkContentProvider
implements IPropertyChangeListener {
    private IPropertyChangesProviderManager currentPropertyChangesProviderManager = null;
    private DocumentLinks currentLinkViewContent = null;

    public LinkContentProvider(IUserInterface UI) {
        super(UI);
        DocumentModulePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean hasLinks(IUniqueElement element, Collection<IUniqueElement> containedElements, Collection<IUniqueElement> containerElements) {
        return LinkContentProvider.hasLinkedInformation((IUniqueElement)element, containedElements, containerElements, (IModelController)DocumentModulePlugin.getDefault().getProjectManager().getModelController(element.getProjectUID()), Arrays.asList("DocumentContainerUE"));
    }

    public boolean hasChildren(Object element) {
        if (element instanceof DocumentLinks) {
            return true;
        }
        if (element instanceof IDocumentContainer) {
            DocumentContainer container = ((IDocumentContainer)element).getDocumentContainer();
            IModelController modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(container.getProjectUID());
            Collection resourceLinks = modelController.getModuleData(container.getUID(), "FilelinkDocumentContainer");
            resourceLinks.addAll(modelController.getModuleData(container.getUID(), "WeblinkDocumentContainer"));
            if (resourceLinks.size() > 1) {
                return true;
            }
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DocumentLinks) {
            return ((Collection)parentElement).toArray();
        }
        if (parentElement instanceof IDocumentContainer) {
            DocumentContainer container = ((IDocumentContainer)parentElement).getDocumentContainer();
            IModelController modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(container.getProjectUID());
            Collection resourceLinks = modelController.getModuleData(container.getUID(), "FilelinkDocumentContainer");
            resourceLinks.addAll(modelController.getModuleData(container.getUID(), "WeblinkDocumentContainer"));
            if (resourceLinks.size() > 1) {
                return resourceLinks.toArray();
            }
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("dcm.prefs.PrefShowUrlForFilelink") || property.equals("dcm.prefs.PrefShowUrlForWeblink")) {
            this.triggerLinkViewRefresh();
        }
    }

    private void triggerLinkViewRefresh() {
        if (this.currentLinkViewContent != null) {
            ArrayList<DocumentLinks> modifiedElements = new ArrayList<DocumentLinks>();
            modifiedElements.add(this.currentLinkViewContent);
            PropertyChanges changes = new PropertyChanges(null, modifiedElements, null);
            this.currentPropertyChangesProviderManager.modelRefreshed((IPropertyChanges)changes, DocumentLinks.class);
        }
    }

    public String getTypeName() {
        return Messages.getString("LinkViewContribution.RootLabel");
    }

    public ImageDescriptor getIcon() {
        return DocumentModulePlugin.getImageDescriptor("documents.gif");
    }

    public boolean mayHaveLinksToConstructionElements(ICockpitProjectData data) {
        return data instanceof IDocumentContainer;
    }

    public boolean isLinkedModuleDataLinkType(String linkTypeID) {
        return DCMLinkTypeHelper_Shared.getDefault().isUELinkType(linkTypeID);
    }

    public List doGetLinkedModuleData(IUniqueElement element, Collection containedElements, Collection containerElements) {
        IModuleProjectAgent projectAgent = DocumentModulePlugin.getDefault().getProjectManager().getProjectAgent(element.getProjectUID());
        this.currentPropertyChangesProviderManager = projectAgent.getPropertyChangesProviderManager();
        String projectUID = element.getProjectUID();
        IModelController modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        IndirectLinksContainer indirectLinksContainerComponents = new IndirectLinksContainer(true);
        IndirectLinksContainer indirectLinksContainerStructure = new IndirectLinksContainer(false);
        DocumentLinks documentLinks = new DocumentLinks((ICockpitProjectData)element, modelController.getModuleData(element.getUID(), "DocumentContainerUE"), projectUID);
        HashSet containedLinks = new HashSet();
        for (IUniqueElement ue : containedElements) {
            Collection links = modelController.getModuleData(ue.getUID(), "DocumentContainerUE");
            containedLinks.addAll(links);
        }
        if (!containedLinks.isEmpty()) {
            indirectLinksContainerComponents.setLinkedModuleData(new ArrayList(containedLinks));
            documentLinks.add(indirectLinksContainerComponents);
        }
        HashSet containerLinks = new HashSet();
        for (IUniqueElement ue : containerElements) {
            Collection links = modelController.getModuleData(ue.getUID(), "DocumentContainerUE");
            containerLinks.addAll(links);
        }
        if (!containerLinks.isEmpty()) {
            indirectLinksContainerStructure.setLinkedModuleData(new ArrayList(containerLinks));
            documentLinks.add(indirectLinksContainerStructure);
        }
        ArrayList<DocumentLinks> linkList = new ArrayList<DocumentLinks>();
        if (!documentLinks.isEmpty()) {
            linkList.add(documentLinks);
        }
        this.currentLinkViewContent = documentLinks;
        return linkList;
    }

    public boolean canDeleteInfoLink(ICockpitProjectData uniqueElement, ICockpitProjectData moduleDataItem) {
        String projectUID = uniqueElement.getProjectUID();
        IModelController modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        if (moduleDataItem instanceof DocumentContainer) {
            return modelController.getModuleData(uniqueElement.getUID(), "DocumentContainerUE").contains(moduleDataItem);
        }
        return false;
    }

    public void deleteInfoLink(final ICockpitProjectData uniqueElement, final ICockpitProjectData moduleDataItem) {
        String projectUID = uniqueElement.getProjectUID();
        final IModelController modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        if (!(moduleDataItem instanceof DocumentContainer)) {
            return;
        }
        final String linkTypeID = "DocumentContainerUE";
        modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                modelController.deleteLink(uniqueElement.getUID(), moduleDataItem.getUID(), linkTypeID);
            }
        });
    }

    public Collection getUIDsOfLinkedUniqueElement(ICockpitProjectData data) {
        return null;
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForUnlinking() {
        return ClientFunctionLicenseTypeDCMLinkItems.getInstance();
    }
}

