/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dialogs;

import com.arcway.cockpit.documentmodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.documentmodule.client.gui.actions.ActionDelegateNewContainerViaUniqueElement;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class SelectionStatusValidator
implements ISelectionStatusValidator {
    private LockAccess lock = null;
    private final ModuleLockManager lockMgr;
    private final PermissionMgr permissionMgr;

    public SelectionStatusValidator(ModuleLockManager lockManager, PermissionMgr permissionMgr) {
        this.lockMgr = lockManager;
        this.permissionMgr = permissionMgr;
    }

    public IStatus validate(Object[] selection) {
        if (this.lock != null) {
            this.lock.releaseLocks();
            this.lock = null;
        }
        int state = 2;
        if (selection.length == 0) {
            state = 1;
        } else {
            Category set = (Category)((Object)selection[0]);
            if (!this.permissionMgr.mayEditCategory(set)) {
                state = 4;
            } else {
                this.lock = this.lockMgr.acquireInsertLock((ICockpitProjectData)set);
                if (!this.lock.hasLock()) {
                    state = 3;
                    this.lock = null;
                } else {
                    state = 0;
                }
            }
        }
        return new Status(ActionDelegateNewContainerViaUniqueElement.SEVERITIES[state], ActionDelegateNewContainerViaUniqueElement.moduleID, state, ActionDelegateNewContainerViaUniqueElement.STATUS_MESSAGES[state], null);
    }

    public LockAccess getLock() {
        return this.lock;
    }
}

