/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dialogs;

import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.Collection;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NewCategoryDialog
extends TitleAreaDialog
implements ModifyListener {
    private final Collection existingCategories;
    private Category category = null;
    private final UIETextField name;

    public NewCategoryDialog(Shell parentShell, IModelController modelCtrl, Collection existingCategories) {
        super(parentShell);
        this.existingCategories = existingCategories;
        this.category = new Category();
        this.category.setProjectUID(modelCtrl.getProjectUID());
        this.name = new UIETextField(Messages.getString("DocumentContainer.CATEGORY_NAME"), this.category.getName().getValueRangeHelper());
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.getString("NewCategoryDialog.Title"));
        this.setTitle(Messages.getString("NewCategoryDialog.Title"));
        this.setMessage(Messages.getString("NewCategoryDialog.Message"));
        Composite editArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        editArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        editArea.setLayoutData((Object)gridData);
        Label labelURL = new Label(editArea, 0);
        labelURL.setText(String.valueOf(Messages.getString("DocumentContainer.CATEGORY_NAME")) + ":");
        Control widget = this.name.getControl(editArea);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        widget.setLayoutData((Object)gridData);
        this.setValues();
        this.name.addModifyListener((ModifyListener)this);
        return editArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.handleModifications(null, false);
    }

    private void setValues() {
        this.name.setValue();
    }

    private void getValues() {
        this.name.getValue();
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications(e, true);
    }

    private void handleModifications(ModifyEvent e, boolean showErrorMessage) {
        String currentCategory;
        String checkResult = "";
        String nameCheckResult = this.name.checkCurrentValue();
        if (nameCheckResult != null) {
            checkResult = String.valueOf(checkResult) + nameCheckResult;
        }
        if (this.existingCategories.contains(currentCategory = this.name.getCurrentValue().trim())) {
            checkResult = String.valueOf(checkResult) + Messages.getString("NewCategory.CategoryAlreadyExists");
        }
        if (checkResult.equals("")) {
            if (showErrorMessage) {
                this.setMessage(Messages.getString("NewCategoryDialog.Message"));
            }
            this.getButton(0).setEnabled(true);
        } else {
            if (showErrorMessage) {
                this.setMessage(checkResult, 3);
            }
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        this.getValues();
        super.okPressed();
    }

    public Category getCategory() {
        return this.category;
    }
}

