/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dialogs;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.EditPathPrefixDialog;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.PathPrefixMapping;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RefreshDataViewRunnable;
import com.arcway.cockpit.documentmodule.client.messages.RefreshFileLinkThread;
import com.arcway.cockpit.documentmodule.shared.ModuleIdentification;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.lib.memento.IArcwayMemento;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ManagePathPrefixesDialog
extends TitleAreaDialog {
    public static final String PROJECT_PATH_ALIGNMENTS = "project_path_alignment";
    public static final String GLOBAL_PATH_ALIGNMENTS = "global_path_alignment";
    private final Shell parentShell;
    private final IModelController modelController;
    private final IArcwayMemento projectPreferenceStore;
    private final IPreferenceStore globalPreferenceStore;
    private ArrayList toBeDeleted;
    private Hashtable toBeEdited;
    private ArrayList toBeAdded;
    private final ArrayList projectMappingsList;
    private final ArrayList globalMappingsList;
    private ArrayList shownMappingsList;
    private Table mappingTable;
    private Button deleteButton;
    private Button editButton;

    public ManagePathPrefixesDialog(Shell parentShell, IModelController modelController) {
        super(parentShell);
        this.parentShell = parentShell;
        this.modelController = modelController;
        this.projectPreferenceStore = DocumentModulePlugin.getDefault().getProjectManager().getProjectAgent(modelController.getProjectUID()).getLocalSettings(ModuleIdentification.getModuleID());
        this.globalPreferenceStore = DocumentModulePlugin.getDefault().getPreferenceStore();
        String projectMappingsString = this.projectPreferenceStore.getString(PROJECT_PATH_ALIGNMENTS);
        if (projectMappingsString == null) {
            projectMappingsString = "";
        }
        this.projectMappingsList = ManagePathPrefixesDialog.decodeAlignmentStrings(projectMappingsString, false);
        String globalMappingsString = this.globalPreferenceStore.getString(GLOBAL_PATH_ALIGNMENTS);
        if (globalMappingsString == null) {
            globalMappingsString = "";
        }
        this.globalMappingsList = ManagePathPrefixesDialog.decodeAlignmentStrings(globalMappingsString, true);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.getString("ManagePathPrefixesDialog.Title"));
        this.setTitle(Messages.getString("ManagePathPrefixesDialog.Title"));
        this.setMessage(Messages.getString("ManagePathPrefixesDialog.Description"));
        Composite baseArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        baseArea.setLayout((Layout)gridLayout);
        Label label = new Label(baseArea, 0);
        label.setText(Messages.getString("ManagePathPrefixesDialog.Mappings"));
        Composite mappingsArea = new Composite(baseArea, 0);
        RowLayout rowLayout = new RowLayout();
        mappingsArea.setLayout((Layout)rowLayout);
        GridData gridData = new GridData(1808);
        mappingsArea.setLayoutData((Object)gridData);
        this.mappingTable = new Table(mappingsArea, 67616);
        this.mappingTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagePathPrefixesDialog.this.deleteButton.setEnabled(true);
                if (ManagePathPrefixesDialog.this.mappingTable.getSelectionIndices().length == 1) {
                    ManagePathPrefixesDialog.this.editButton.setEnabled(true);
                } else {
                    ManagePathPrefixesDialog.this.editButton.setEnabled(false);
                }
                int index = ((Table)e.getSource()).indexOf((TableItem)e.item);
                PathPrefixMapping mapping = (PathPrefixMapping)ManagePathPrefixesDialog.this.shownMappingsList.get(index);
                mapping.setActive(((TableItem)e.item).getChecked());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        RowData rowData = new RowData(500, 300);
        this.mappingTable.setLayoutData((Object)rowData);
        TableColumn col1 = new TableColumn(this.mappingTable, 16384);
        col1.setText(Messages.getString("ManagePathPrefixesDialog.toBeReplacedMsg"));
        col1.setWidth(220);
        TableColumn col2 = new TableColumn(this.mappingTable, 16384);
        col2.setText(Messages.getString("ManagePathPrefixesDialog.LocalPrefixMsg"));
        col2.setWidth(220);
        TableColumn col3 = new TableColumn(this.mappingTable, 16384);
        col3.setText(Messages.getString("ManagePathPrefixesDialog.ProjectSpanning"));
        col3.setWidth(76);
        this.mappingTable.setHeaderVisible(true);
        this.mappingTable.setLinesVisible(true);
        Composite buttonArea = new Composite(mappingsArea, 0);
        rowLayout = new RowLayout(512);
        buttonArea.setLayout((Layout)rowLayout);
        rowData = new RowData();
        rowData.width = 100;
        buttonArea.setLayoutData((Object)rowData);
        this.deleteButton = new Button(buttonArea, 0x1000008);
        this.deleteButton.setText(Messages.getString("ManagePathPrefixesDialog.Delete"));
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ManagePathPrefixesDialog.this.deleteSelection();
                ManagePathPrefixesDialog.this.deleteButton.setEnabled(false);
                ManagePathPrefixesDialog.this.editButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        rowData = new RowData();
        rowData.width = 85;
        this.deleteButton.setLayoutData((Object)rowData);
        this.editButton = new Button(buttonArea, 0x1000008);
        this.editButton.setText(Messages.getString("ManagePathPrefixesDialog.Edit"));
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ManagePathPrefixesDialog.this.editMapping();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        rowData = new RowData();
        rowData.width = 85;
        this.editButton.setLayoutData((Object)rowData);
        Button addButton = new Button(buttonArea, 0x1000008);
        addButton.setText(Messages.getString("ManagePathPrefixesDialog.Add"));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ManagePathPrefixesDialog.this.addMapping();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        rowData = new RowData();
        rowData.width = 85;
        addButton.setLayoutData((Object)rowData);
        this.deleteButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.fillLists();
        return baseArea;
    }

    private void fillLists() {
        Iterator iterator = this.projectMappingsList.iterator();
        this.shownMappingsList = new ArrayList();
        this.toBeDeleted = new ArrayList();
        this.toBeAdded = new ArrayList();
        this.toBeEdited = new Hashtable();
        while (iterator.hasNext()) {
            PathPrefixMapping mapping = (PathPrefixMapping)iterator.next();
            this.shownMappingsList.add(mapping);
            TableItem item = new TableItem(this.mappingTable, 0);
            item.setText(new String[]{mapping.getSubPathToReplace().getValue(), mapping.getReplacePath().getValue(), this.showDisplayString(mapping.getProjectSpannning())});
            item.setChecked(mapping.isActive());
        }
        for (PathPrefixMapping mapping : this.globalMappingsList) {
            int index = ManagePathPrefixesDialog.getInsertIndex(this.shownMappingsList, mapping);
            this.shownMappingsList.add(index, mapping);
            TableItem item = new TableItem(this.mappingTable, 0, index);
            item.setText(new String[]{mapping.getSubPathToReplace().getValue(), mapping.getReplacePath().getValue(), this.showDisplayString(mapping.getProjectSpannning())});
            item.setChecked(mapping.isActive());
        }
    }

    private String showDisplayString(boolean flag) {
        String displayString = flag ? Messages.getString("ManagePathPrefixesDialog.Yes") : Messages.getString("ManagePathPrefixesDialog.No");
        return displayString;
    }

    private void deleteSelection() {
        int[] selection = this.mappingTable.getSelectionIndices();
        int c = selection.length - 1;
        while (c >= 0) {
            this.toBeDeleted.add(this.shownMappingsList.get(selection[c]));
            this.shownMappingsList.remove(this.shownMappingsList.get(selection[c]));
            --c;
        }
        this.mappingTable.remove(selection);
    }

    private void addMapping() {
        EditPathPrefixDialog dialog = new EditPathPrefixDialog(this.parentShell, this.modelController, this.shownMappingsList);
        if (dialog.open() == 0) {
            PathPrefixMapping mapping = dialog.getMapping();
            this.toBeAdded.add(mapping);
            int index = ManagePathPrefixesDialog.getInsertIndex(this.shownMappingsList, mapping);
            this.shownMappingsList.add(index, mapping);
            TableItem item = new TableItem(this.mappingTable, 0, index);
            item.setChecked(mapping.isActive());
            item.setText(new String[]{mapping.getSubPathToReplace().getValue(), mapping.getReplacePath().getValue(), this.showDisplayString(mapping.getProjectSpannning())});
        }
    }

    public static int getInsertIndex(ArrayList existingList, PathPrefixMapping newEntry) {
        int index = 0;
        String headOfMapping = newEntry.getSubPathToReplace().getValue().substring(0, 1);
        String tailOfMapping = newEntry.getSubPathToReplace().getValue().substring(1);
        Iterator iterator = existingList.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            PathPrefixMapping currentMapping = (PathPrefixMapping)iterator.next();
            String headOfCurrent = currentMapping.getSubPathToReplace().getValue().substring(0, 1);
            String tailOfCurrent = currentMapping.getSubPathToReplace().getValue().substring(1);
            if (tailOfMapping.compareTo(tailOfCurrent) < 0 && !tailOfCurrent.startsWith(tailOfMapping) && headOfMapping.equalsIgnoreCase(headOfCurrent) || headOfMapping.compareToIgnoreCase(headOfCurrent) < 0) {
                index = i;
                break;
            }
            if (tailOfMapping.startsWith(tailOfCurrent) && headOfMapping.equalsIgnoreCase(headOfCurrent)) {
                if (newEntry.getProjectSpannning()) {
                    if (tailOfMapping.compareTo(tailOfCurrent) == 0) {
                        index = i + 1;
                        break;
                    }
                    index = i;
                    break;
                }
                index = i;
                break;
            }
            index = i + 1;
            ++i;
        }
        return index;
    }

    private void editMapping() {
        EditPathPrefixDialog dialog;
        int[] selection = this.mappingTable.getSelectionIndices();
        if (selection.length == 1 && (dialog = new EditPathPrefixDialog(this.parentShell, this.modelController, this.shownMappingsList, (PathPrefixMapping)this.shownMappingsList.get(selection[0]))).open() == 0) {
            PathPrefixMapping mapping = dialog.getMapping();
            this.toBeEdited.put(new Integer(selection[0]), mapping);
            this.shownMappingsList.remove(selection[0]);
            this.mappingTable.remove(selection[0]);
            int index = ManagePathPrefixesDialog.getInsertIndex(this.shownMappingsList, mapping);
            this.shownMappingsList.add(index, mapping);
            TableItem item = new TableItem(this.mappingTable, 0, index);
            item.setText(new String[]{mapping.getSubPathToReplace().getValue(), mapping.getReplacePath().getValue(), this.showDisplayString(mapping.getProjectSpannning())});
            item.setChecked(mapping.isActive());
        }
    }

    public void okPressed() {
        if (this.toBeDeleted.size() > 0) {
            MessageDialog mDialog = new MessageDialog(this.parentShell, Messages.getString("ManagePathPrefixesDialog.delete.title"), null, String.valueOf(Messages.getString("ManagePathPrefixesDialog.delete.message1")) + this.toBeDeleted.size() + Messages.getString("ManagePathPrefixesDialog.delete.message2"), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            if (mDialog.open() == 0) {
                this.manifestChanges();
            }
            super.okPressed();
        } else {
            this.manifestChanges();
            super.okPressed();
        }
    }

    private void manifestChanges() {
        this.projectPreferenceStore.putString(PROJECT_PATH_ALIGNMENTS, ManagePathPrefixesDialog.encodeAlignmentStrings(this.extractProjectMappings(this.shownMappingsList)));
        this.globalPreferenceStore.setValue(GLOBAL_PATH_ALIGNMENTS, ManagePathPrefixesDialog.encodeAlignmentStrings(this.extractSpanningMappings(this.shownMappingsList)));
        Collection projectAgents = DocumentModulePlugin.getDefault().getProjectManager().getProjectAgentsOfAllOpenProjects();
        for (IProjectAgent projectAgent : projectAgents) {
            IModelController currentModelCtrl = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectAgent.getProjectUID());
            Collection fileSystemLinks = currentModelCtrl.getAllItems("dcm.filesystemlink");
            for (RLFileSystemLink fileLink : fileSystemLinks) {
                String oldURL = fileLink.getLocalURL();
                fileLink.calculateLocalURLs(1, (com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent)this.modelController.getProjectAgent());
                if (oldURL.equals(fileLink.getLocalURL())) continue;
                new RefreshFileLinkThread(fileSystemLinks, new RefreshDataViewRunnable(Display.getCurrent(), fileSystemLinks, projectAgent.getPropertyChangesProviderManager())).start();
            }
            PropertyChanges changes = new PropertyChanges(null, fileSystemLinks, null);
            projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, RLFileSystemLink.class);
        }
    }

    public static String encodeAlignmentStrings(Collection mappings) {
        StringBuffer encodedString = new StringBuffer();
        Iterator iterator = mappings.iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            PathPrefixMapping mapping = (PathPrefixMapping)iterator.next();
            encodedString.append(mapping.getSubPathToReplace().getValue());
            encodedString.append("<>");
            encodedString.append(mapping.getReplacePath().getValue());
            encodedString.append("<>");
            encodedString.append(mapping.isActive());
            if (++counter >= mappings.size()) continue;
            encodedString.append("<#>");
        }
        return encodedString.toString();
    }

    public static ArrayList<PathPrefixMapping> decodeAlignmentStrings(String encodedMappings, boolean projectSpanning) {
        ArrayList<PathPrefixMapping> mappings;
        if (encodedMappings.length() > 0) {
            String[] stringPairs = encodedMappings.split("<#>", 0);
            mappings = new ArrayList(stringPairs.length);
            if (stringPairs.length > 0) {
                Pattern pairSepPattern = Pattern.compile("<>");
                String[] stringArray = stringPairs;
                int n = stringPairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String stringPair = stringArray[n2];
                    String[] triple = pairSepPattern.split(stringPair, 0);
                    if (triple.length > 2) {
                        mappings.add(new PathPrefixMapping(triple[0], triple[1], projectSpanning, Boolean.parseBoolean(triple[2])));
                    }
                    ++n2;
                }
            }
        } else {
            mappings = new ArrayList<PathPrefixMapping>(0);
        }
        return mappings;
    }

    private Collection extractProjectMappings(Collection allMappings) {
        ArrayList<PathPrefixMapping> projectMappings = new ArrayList<PathPrefixMapping>();
        for (PathPrefixMapping mapping : allMappings) {
            if (mapping.getProjectSpannning()) continue;
            projectMappings.add(mapping);
        }
        return projectMappings;
    }

    private Collection extractSpanningMappings(Collection allMappings) {
        ArrayList<PathPrefixMapping> spanningMappings = new ArrayList<PathPrefixMapping>();
        for (PathPrefixMapping mapping : allMappings) {
            if (!mapping.getProjectSpannning()) continue;
            spanningMappings.add(mapping);
        }
        return spanningMappings;
    }
}

