/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dialogs;

import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.PathPrefixMapping;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditPathPrefixDialog
extends TitleAreaDialog
implements ModifyListener,
SelectionListener {
    private final Collection existingMappings;
    private PathPrefixMapping mapping = null;
    private PathPrefixMapping dummyMapping = null;
    private Text sourcePrefix;
    private Text targetPrefix;
    private Button projectSpanning;
    private final boolean editMode;

    public EditPathPrefixDialog(Shell parentShell, IModelController modelCtrl, Collection existingMappings) {
        super(parentShell);
        this.existingMappings = existingMappings;
        this.mapping = new PathPrefixMapping();
        this.dummyMapping = new PathPrefixMapping();
        this.editMode = false;
    }

    public EditPathPrefixDialog(Shell parentShell, IModelController modelCtrl, Collection existingMappings, PathPrefixMapping editMapping) {
        super(parentShell);
        this.existingMappings = existingMappings;
        this.mapping = new PathPrefixMapping();
        this.dummyMapping = editMapping;
        this.editMode = true;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.editMode) {
            parent.getShell().setText(Messages.getString("EditPathPrefixDialog.Edit_Title"));
            this.setTitle(Messages.getString("EditPathPrefixDialog.Edit_Title"));
            this.setMessage(Messages.getString("EditPathPrefixDialog.Edit_Description"));
        } else {
            parent.getShell().setText(Messages.getString("EditPathPrefixDialog.New_Title"));
            this.setTitle(Messages.getString("EditPathPrefixDialog.New_Title"));
            this.setMessage(Messages.getString("EditPathPrefixDialog.New_Description"));
        }
        Composite editArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        editArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        editArea.setLayoutData((Object)gridData);
        Label labelURL = new Label(editArea, 0);
        labelURL.setText(Messages.getString("EditPathPrefixDialog.Global_Prefix"));
        this.sourcePrefix = new Text(editArea, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.sourcePrefix.setLayoutData((Object)gridData);
        Label labelURL2 = new Label(editArea, 0);
        labelURL2.setText(Messages.getString("EditPathPrefixDialog.Local_Prefix"));
        this.targetPrefix = new Text(editArea, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.targetPrefix.setLayoutData((Object)gridData);
        Label labelProjectwide = new Label(editArea, 0);
        labelProjectwide.setText(Messages.getString("EditPathPrefixDialog.Projectspanning"));
        this.projectSpanning = new Button(editArea, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.targetPrefix.setLayoutData((Object)gridData);
        this.setValues();
        this.sourcePrefix.addModifyListener((ModifyListener)this);
        this.targetPrefix.addModifyListener((ModifyListener)this);
        this.projectSpanning.addSelectionListener((SelectionListener)this);
        return editArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.handleModifications(null, false);
    }

    private void setValues() {
        this.sourcePrefix.setText(this.dummyMapping.getSubPathToReplace().getValue());
        this.targetPrefix.setText(this.dummyMapping.getReplacePath().getValue());
        this.projectSpanning.setSelection(this.dummyMapping.getProjectSpannning());
    }

    private void getValues() {
        this.dummyMapping.setSubPathToReplace(this.sourcePrefix.getText());
        this.dummyMapping.setReplacePath(this.targetPrefix.getText());
        this.dummyMapping.setProjectSpanning(this.projectSpanning.getSelection());
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications((TypedEvent)e, true);
    }

    public void widgetSelected(SelectionEvent e) {
        this.handleModifications((TypedEvent)e, true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.handleModifications((TypedEvent)e, true);
    }

    private void handleModifications(TypedEvent e, boolean showErrorMessage) {
        String checkResult = "";
        this.dummyMapping.setSubPathToReplace(this.sourcePrefix.getText());
        this.dummyMapping.setReplacePath(this.targetPrefix.getText());
        this.dummyMapping.setProjectSpanning(this.projectSpanning.getSelection());
        if (this.existingMappings.contains(this.dummyMapping)) {
            ArrayList mappings = new ArrayList(this.existingMappings);
            if (this.editMode) {
                mappings.remove(this.dummyMapping);
                if (mappings.contains(this.dummyMapping)) {
                    checkResult = String.valueOf(checkResult) + Messages.getString("EditPathPrefixDialog.Mapping_Exists_Error");
                }
            } else {
                checkResult = String.valueOf(checkResult) + Messages.getString("EditPathPrefixDialog.Mapping_Exists_Error");
            }
        }
        this.mapping = this.dummyMapping;
        if (checkResult.equals("")) {
            if (!this.editMode && showErrorMessage) {
                this.setMessage(Messages.getString("EditPathPrefixDialog.New_Description"));
            } else if (this.editMode && showErrorMessage) {
                this.setMessage(Messages.getString("EditPathPrefixDialog.Edit_Description"));
            }
            this.getButton(0).setEnabled(true);
        } else {
            if (showErrorMessage) {
                this.setMessage(checkResult, 3);
            }
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        this.getValues();
        super.okPressed();
    }

    public PathPrefixMapping getMapping() {
        return this.mapping;
    }
}

