/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.core.project;

import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.project.DataMgr;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractModuleDataLabelProvider;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class DataLabelProvider
extends AbstractModuleDataLabelProvider {
    private static final ILogger logger = Logger.getLogger(DataLabelProvider.class);
    private static Map typeImages;
    private static Map typeDisplayNames;
    private final ImageDescriptorRegistry imageDescriptorRegistry;

    public DataLabelProvider(DataMgr dataManager) {
        super((AbstractDataMgr)dataManager);
        if (typeImages == null) {
            typeImages = new HashMap();
            typeImages.put("dcm.category", DocumentModulePlugin.getImageDescriptor("Category.gif").createImage());
            typeImages.put("dcm.documentcontainer", DocumentModulePlugin.getImageDescriptor("container.gif").createImage());
            typeImages.put("dcm.weblink", DocumentModulePlugin.getImageDescriptor("weblink.gif").createImage());
        }
        if (typeDisplayNames == null) {
            typeDisplayNames = new HashMap();
            typeDisplayNames.put("dcm.category", Messages.getString("Category.ModuleDataName"));
            typeDisplayNames.put("dcm.documentcontainer", Messages.getString("DocumentContainer.ModuleDataName"));
            typeDisplayNames.put("dcm.weblink", Messages.getString("RLWebLink.ModuleDataName"));
            typeDisplayNames.put("dcm.filesystemlink", Messages.getString("RLFileSystemLink.ModuleDataName"));
        }
        this.imageDescriptorRegistry = DocumentModulePlugin.getDefault().getImageDescriptorRegistry();
    }

    public Image getImageForType(String dataTypeID) {
        return (Image)typeImages.get(dataTypeID);
    }

    public String getDisplayNameForType(String dataTypeID) {
        return (String)typeDisplayNames.get(dataTypeID);
    }

    public Image getImageForItem_internal(IModuleData element) {
        if (element instanceof RLFileSystemLink) {
            RLFileSystemLink fileLink = (RLFileSystemLink)element;
            ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileLink.getPreMappedURL().getValue());
            return this.imageDescriptorRegistry.get(desc);
        }
        return this.getImageForType(element.getTypeID());
    }

    public String getLabelForItem_internal(IModuleData md) {
        return md.getDisplayRepresentation();
    }
}

