/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.core;

import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.ModulePermissionTemplate;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.PermissionOperationDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ModulePermissionConstants {
    public static final String OPERAND_TYPE_CATEGORY = "dcm.category";
    public static final String OPERATION_CREATE_CATEGORIES = "dcm.createCategories";
    public static final String OPERATION_EDIT_CATEGORY = "dcm.editCategory";
    public static final CockpitPermissionTemplate CREATE_CATEGORIES = new ModulePermissionTemplate("dcm.createCategories", Arrays.asList(new PermissionOperationDescription("Create", "dcm.category")), "project");
    public static final CockpitPermissionTemplate EDIT_CATEGORY = new ModulePermissionTemplate("dcm.editCategory", Arrays.asList(new PermissionOperationDescription("Modify", "dcm.category"), new PermissionOperationDescription("Delete", "dcm.category"), new PermissionOperationDescription("Create", "dcm.documentcontainer"), new PermissionOperationDescription("Modify", "dcm.documentcontainer"), new PermissionOperationDescription("Delete", "dcm.documentcontainer"), new PermissionOperationDescription("Create", "dcm.filesystemlink"), new PermissionOperationDescription("Modify", "dcm.filesystemlink"), new PermissionOperationDescription("Delete", "dcm.filesystemlink"), new PermissionOperationDescription("Create", "dcm.weblink"), new PermissionOperationDescription("Modify", "dcm.weblink"), new PermissionOperationDescription("Delete", "dcm.weblink")), "dcm.category");
    private static List allTemplates = null;

    public static List getTemplates() {
        if (allTemplates == null) {
            allTemplates = new ArrayList();
            allTemplates.add(EDIT_CATEGORY);
            allTemplates.add(CREATE_CATEGORIES);
        }
        return allTemplates;
    }

    public static List getTemplates(String operandType) {
        assert (operandType != null);
        ArrayList<CockpitPermissionTemplate> result = new ArrayList<CockpitPermissionTemplate>();
        for (CockpitPermissionTemplate permission : ModulePermissionConstants.getTemplates()) {
            if (!permission.getOperandType().equals(operandType)) continue;
            result.add(permission);
        }
        return result;
    }

    public static String getName(CockpitPermissionTemplate template) {
        assert (template != null);
        if (template.getOperation().equals(OPERATION_CREATE_CATEGORIES)) {
            return Messages.getString("Permissions.CreateContainerCategories");
        }
        if (template.getOperation().equals(OPERATION_EDIT_CATEGORY)) {
            return Messages.getString("Permissions.EditAndDeleteContainersofCategory");
        }
        return null;
    }
}

