/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.docgen.provider;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.interfaces.IHistoryEntry;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExCategory;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExDocumentContainer;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExResourceLocator;
import com.arcway.cockpit.documentmodule.docgen.provider.DocumentContainerComparator;
import com.arcway.cockpit.documentmodule.docgen.provider.DocumentContainerDocGenProxy;
import com.arcway.cockpit.documentmodule.docgen.provider.DocumentContainerSetComparator;
import com.arcway.cockpit.documentmodule.docgen.provider.DocumentContainerSetDocGenProxy;
import com.arcway.cockpit.documentmodule.docgen.provider.ResourceLocatorDocGenProxy;
import com.arcway.cockpit.documentmodule.docgen.provider.interfaces.IDocumentContainer;
import com.arcway.cockpit.documentmodule.docgen.provider.interfaces.IDocumentContainerSet;
import com.arcway.cockpit.documentmodule.docgen.provider.interfaces.IDocumentDataProvider;
import com.arcway.cockpit.documentmodule.docgen.provider.interfaces.IResourceLocator;
import com.arcway.cockpit.documentmodule.shared.ModuleIdentification;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleReportDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ReportDataProvider
implements IProjectRelatedReportProvider,
IModuleReportDataProvider,
IDocumentDataProvider {
    public static final int SORT_DOCUMENTCONTAINER_BY_NAME = 0;
    public static final int SORT_DOCUMENTCONTAINER_BY_CATEGORY = 1;
    public static final int SORT_RESOURCELOCATOR_BY_URL = 2;
    public static final int SORT_CATEGORY_BY_NAME = 3;
    public static final int SORT_DOCUMENTCONTAINERSET_BY_NAME = 3;
    private DataFacade dataFacade = null;
    private Collection<AbstractFilter> filters = null;
    private IGraphicsAndFilesHelper graphicsProvider = null;
    private Locale locale = null;

    public void setup(IProjectRelatedReportContext reportContext) {
        IDocGeneratorProjectAgent projectAgent = reportContext.getProjectAgent();
        IFMCAModule module = projectAgent.getModule(ModuleIdentification.getModuleID());
        this.dataFacade = (DataFacade)module.getModuleDataFacade();
        this.graphicsProvider = reportContext.getGraphicsProvider();
        this.locale = new Locale(projectAgent.getLanguageID());
        this.filters = reportContext.getFilterCollection();
    }

    @Override
    public List<? extends IDocumentContainerSet> getAllDocumentContainerSets() {
        List<ImExCategory> documentContainerSets = this.getAllCategories_Internal();
        return DocumentContainerSetDocGenProxy.transformDocumentContainerSetList(documentContainerSets, this.dataFacade, this.filters, this.graphicsProvider, this.locale);
    }

    @Override
    public List<? extends IDocumentContainerSet> getAllDocumentContainerSets(int sortingCriterion) {
        List<ImExCategory> documentContainerSets = this.getAllCategories_Internal();
        Collections.sort(documentContainerSets, new DocumentContainerSetComparator(sortingCriterion));
        return DocumentContainerSetDocGenProxy.transformDocumentContainerSetList(documentContainerSets, this.dataFacade, this.filters, this.graphicsProvider, this.locale);
    }

    @Override
    public List<? extends IDocumentContainerSet> getAllCategories() {
        return this.getAllDocumentContainerSets();
    }

    @Override
    public List<? extends IDocumentContainerSet> getAllCategories(int sortingCriterion) {
        return this.getAllDocumentContainerSets(sortingCriterion);
    }

    private List<ImExCategory> getAllCategories_Internal() {
        return new ArrayList<ImExCategory>(this.dataFacade.getAllCategories(this.locale));
    }

    @Override
    public boolean hasDocumentContainersForUniqueElement(String uniqueElementUID) {
        boolean result = false;
        Collection containers = this.dataFacade.getDocumentContainersLinkedWithUE(uniqueElementUID, this.locale);
        result = containers.size() > 0;
        return result;
    }

    @Override
    public List<? extends IDocumentContainer> getDocumentContainersForUniqueElement(String uniqueElementUID) {
        return this.getDocumentContainersForUniqueElement(uniqueElementUID, 0);
    }

    @Override
    public List<? extends IDocumentContainer> getDocumentContainersForUniqueElement(String uniqueElementUID, int sortingCriterion) {
        List<ImExDocumentContainer> containers = this.getDocumentContainersForUniqueElement_Internal(uniqueElementUID);
        Collections.sort(containers, new DocumentContainerComparator(sortingCriterion));
        return DocumentContainerDocGenProxy.transformDocumentContainerList(containers, this.dataFacade, this.filters, this.graphicsProvider, this.locale);
    }

    private List<ImExDocumentContainer> getDocumentContainersForUniqueElement_Internal(String uniqueElementUID) {
        return new ArrayList<ImExDocumentContainer>(this.dataFacade.getDocumentContainersLinkedWithUE(uniqueElementUID, this.locale));
    }

    @Override
    public int getSORT_DOCUMENTCONTAINER_BY_NAME() {
        return 0;
    }

    @Override
    public int getSORT_DOCUMENTCONTAINER_BY_CATEGORY() {
        return 1;
    }

    @Override
    public int getSORT_RESOURCELOCATOR_BY_URL() {
        return 2;
    }

    @Override
    public int getSORT_CATEGORY_BY_NAME() {
        return 3;
    }

    @Override
    public int getSORT_DOCUMENTCONTAINERSET_BY_NAME() {
        return 3;
    }

    public boolean isResponsibleFor(AbstractImExModuleData exportableItem) {
        return exportableItem instanceof ImExCategory || exportableItem instanceof ImExDocumentContainer || exportableItem instanceof ImExResourceLocator;
    }

    public IModuleDataDocGenProxy getDocGenProxy(AbstractImExModuleData exportableItem) {
        if (exportableItem instanceof ImExCategory) {
            return new DocumentContainerSetDocGenProxy((ImExCategory)exportableItem, this.dataFacade, this.graphicsProvider, this.filters, this.locale);
        }
        if (exportableItem instanceof ImExDocumentContainer) {
            return new DocumentContainerDocGenProxy((ImExDocumentContainer)exportableItem, this.dataFacade, this.graphicsProvider, this.filters, this.locale);
        }
        if (exportableItem instanceof ImExResourceLocator) {
            return new ResourceLocatorDocGenProxy((ImExResourceLocator)exportableItem, this.dataFacade, this.graphicsProvider, this.locale);
        }
        return null;
    }

    @Override
    public List<? extends IDocumentContainerSet> getAllDocumentContainerSetsForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IDocumentContainerSet> documentContainerSetsForHistoryItem = new ArrayList<IDocumentContainerSet>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<? extends IDocumentContainerSet> documentContainerSets = this.getAllDocumentContainerSets();
            for (IDocumentContainerSet iDocumentContainerSet : documentContainerSets) {
                if (!commitVersion.equals(iDocumentContainerSet.getCommitVersion())) continue;
                documentContainerSetsForHistoryItem.add(iDocumentContainerSet);
            }
        }
        return documentContainerSetsForHistoryItem;
    }

    @Override
    public List<? extends IDocumentContainer> getAllDocumentContainersForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IDocumentContainer> documentContainersForHistoryItem = new ArrayList<IDocumentContainer>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<? extends IDocumentContainerSet> documentContainerSets = this.getAllDocumentContainerSets();
            for (IDocumentContainerSet iDocumentContainerSet : documentContainerSets) {
                List<? extends IDocumentContainer> documentContainers = iDocumentContainerSet.getDocumentContainers();
                for (IDocumentContainer iDocumentContainer : documentContainers) {
                    if (!commitVersion.equals(iDocumentContainer.getCommitVersion())) continue;
                    documentContainersForHistoryItem.add(iDocumentContainer);
                }
            }
        }
        return documentContainersForHistoryItem;
    }

    @Override
    public List<? extends IResourceLocator> getAllResourceLocatorsForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IResourceLocator> resourceLocatorsForHistoryItem = new ArrayList<IResourceLocator>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<? extends IDocumentContainerSet> documentContainerSets = this.getAllDocumentContainerSets();
            for (IDocumentContainerSet iDocumentContainerSet : documentContainerSets) {
                List<? extends IDocumentContainer> documentContainers = iDocumentContainerSet.getDocumentContainers();
                for (IDocumentContainer iDocumentContainer : documentContainers) {
                    List<? extends IResourceLocator> resourceLocators = iDocumentContainer.getResourceLocators();
                    for (IResourceLocator iResourceLocator : resourceLocators) {
                        if (!commitVersion.equals(iResourceLocator.getCommitVersion())) continue;
                        resourceLocatorsForHistoryItem.add(iResourceLocator);
                    }
                }
            }
        }
        return resourceLocatorsForHistoryItem;
    }
}

