/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider.planagent;

import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.provider.planagent.AbstractGraphicAdapter;
import com.arcway.cockpit.docgen.provider.planagent.ForcedViewRectangle;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverMetafile;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.IVariablePageSizeDeviceDriver;
import com.arcway.lib.graphics.print.PageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.graphics.print.VariablePageSizePrinter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import de.plans.lib.svg.ILink;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractMetafileGraphicsAdapter
extends AbstractGraphicAdapter {
    private static final ILogger logger = Logger.getLogger(AbstractMetafileGraphicsAdapter.class);
    private VariablePageSizePrinter printer = null;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    protected abstract IDeviceDriverMetafile createDeviceDriver();

    @Override
    public Dimension export(PlanImageSizeHint preferredSize, IGraphicProvider graphicProvider, Map<String, String> roleMap, String styleSheetFilename, Map<String, ILink> linkMap, ForcedViewRectangle forcedViewRectangle) throws PrintingFailure, EXEmptyResult {
        PageSetup pageSetup;
        boolean proceedIfPlanIsEmpty = false;
        Dimension planSizeInMM = AbstractMetafileGraphicsAdapter.getPlanSizeInMM(graphicProvider, forcedViewRectangle, proceedIfPlanIsEmpty);
        Dimension limitedPlanSizeInMM = AbstractMetafileGraphicsAdapter.calculateLimitedPlanSize(planSizeInMM, preferredSize);
        double inset = 0.2;
        limitedPlanSizeInMM = new Rectangle(Point.ORIGIN, limitedPlanSizeInMM).expand(inset).getDimension();
        IPageDescription printInfo = PageDescription.createPrintInfoInMM((double)limitedPlanSizeInMM.width, (double)limitedPlanSizeInMM.height, (double)inset);
        this.outputStream.reset();
        IDeviceDriverMetafile deviceDriver = this.createDeviceDriver();
        this.printer = new VariablePageSizePrinter((IVariablePageSizeDeviceDriver)deviceDriver, printInfo);
        int pageCountX = 1;
        int pageCountY = 1;
        Insets insets = new Insets(inset);
        if (forcedViewRectangle == null || forcedViewRectangle.getZoom() == null) {
            Alignment alignment = new Alignment();
            double zoom = 1.0;
            boolean fitHorizontal = true;
            boolean fitVertical = true;
            pageSetup = new PageSetup(pageCountX, pageCountY, alignment, zoom, fitHorizontal, fitVertical, insets);
        } else {
            Alignment alignment = new Alignment(1, 8);
            double zoom = forcedViewRectangle.getZoom();
            boolean fitHorizontal = false;
            boolean fitVertical = false;
            double offsetX = forcedViewRectangle.getOffsetX();
            double offsetY = forcedViewRectangle.getOffsetY();
            pageSetup = new PageSetup(pageCountX, pageCountY, alignment, zoom, fitHorizontal, fitVertical, insets, offsetX, offsetY);
        }
        graphicProvider.export((IPrinter)this.printer, pageSetup);
        deviceDriver.saveImageDirectly((OutputStream)this.outputStream);
        return limitedPlanSizeInMM;
    }

    @Override
    public void save(File imageFile) throws PrintingFailure {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(imageFile);
            boolean noWriteErrorOccured = false;
            try {
                this.outputStream.writeTo(fileOutputStream);
                noWriteErrorOccured = true;
            }
            finally {
                if (noWriteErrorOccured) {
                    fileOutputStream.close();
                } else {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception e) {
                        logger.debug("Problem wile closing WMF Image File stream (probably caused by a previous error)", (Throwable)e);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new PrintingFailure((Throwable)e);
        }
        catch (IOException e) {
            throw new PrintingFailure((Throwable)e);
        }
    }

    @Override
    public void disposeImages() {
        this.printer.dispose();
    }
}

