/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractCustomPropertiesAccessDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.StakeholderRoleDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.interfaces.IStakeholder;
import com.arcway.cockpit.docgen.provider.interfaces.IStakeholderRole;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.docgen.provider.utils.StakeholderRoleComparator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataTypeDescription;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class StakeholderDocGenProxy
extends AbstractCustomPropertiesAccessDocGenProxy
implements IStakeholder {
    private IDocGeneratorProjectAgent projectAgent = null;
    private com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder stakeholder = null;
    private Collection<AbstractFilter> filters = null;
    private final Locale locale;

    public StakeholderDocGenProxy(com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder stakeholder, IDocGeneratorProjectAgent projectAgent, IGraphicsAndFilesHelper fileAttributeProvider, Collection<AbstractFilter> filters, Locale locale) {
        super((IAttributeOwner)stakeholder, fileAttributeProvider, (IFrameProjectAgent)projectAgent.getProjectAgent(), locale);
        this.stakeholder = stakeholder;
        this.projectAgent = projectAgent;
        this.filters = filters;
        this.locale = locale;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.stakeholder.getUID();
    }

    @Override
    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.stakeholder.getStakeholderName());
    }

    @Override
    public String getTypeID() {
        return "stakeholder";
    }

    @Override
    public String getTypeName() {
        return ((IFrameDataTypeDescription)FrameDataTypes.getDataType((String)"com.arcway.cockpit.stakeholder")).getDisplayName(this.locale);
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.stakeholder.getStakeholderName());
    }

    @Override
    public String getCompany() {
        return HTMLEncoder.encode((String)this.stakeholder.getStakeholderCompany());
    }

    @Override
    public boolean hasEmail() {
        String email = this.stakeholder.getStakeholderEMail();
        return email != null && email.length() > 0;
    }

    @Override
    public String getEmail() {
        return HTMLEncoder.encode((String)this.stakeholder.getStakeholderEMail());
    }

    @Override
    public String getPhone() {
        return HTMLEncoder.encode((String)this.stakeholder.getStakeholderTelephone());
    }

    @Override
    public String getFax() {
        return HTMLEncoder.encode((String)this.stakeholder.getStakeholderFax());
    }

    @Override
    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.stakeholder.getStakeholderDescription());
        List<String> resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(descriptionList);
        return resultAsList;
    }

    @Override
    public List<String> getAddress() {
        List addressList = StringUtil.splitTextLines((String)this.stakeholder.getStakeholderAddress());
        List<String> resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(addressList);
        return resultAsList;
    }

    @Override
    public List<? extends IStakeholderRole> getRoles() {
        ArrayList stakeholderRoles = new ArrayList(this.projectAgent.getRolesOfStakeholder(this.stakeholder));
        Collections.sort(stakeholderRoles, new StakeholderRoleComparator());
        ArrayList<StakeholderRoleDocGenProxy> result = new ArrayList<StakeholderRoleDocGenProxy>(stakeholderRoles.size());
        for (com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole stakeholderRole : stakeholderRoles) {
            StakeholderRoleDocGenProxy stakeholderRoleProxy = new StakeholderRoleDocGenProxy(stakeholderRole, this.projectAgent, this.getGraphicsAndFilesHelper(), this.filters, this.locale);
            result.add(stakeholderRoleProxy);
        }
        return result;
    }

    @Override
    public String getCommitVersion() {
        int commitCount = this.stakeholder.getCommitCount();
        return HistoryEntry.getVersionForCommitCount(commitCount);
    }

    @Override
    public String getDateOfLastModification() {
        String lastModDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        return lastModDateHTML;
    }

    @Override
    public Long getDateOfLastModification_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("lastEditDate");
    }

    @Override
    public String getLastModifier() {
        String lastModifierHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        return lastModifierHTML;
    }

    @Override
    public String getCreationDate() {
        String creationDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        return creationDateHTML;
    }

    @Override
    public Long getCreationDate_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("creationDate");
    }

    @Override
    public String getCreator() {
        String creatorHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATOR);
        return creatorHTML;
    }

    private String getHTMLEncodeSingleLineAttributeValue(IAttributeTypeID attrType) {
        IAttributeType attributeType;
        String htmlString = "-";
        IAttribute attribute = this.stakeholder.getAttribute(attrType);
        if (attribute != null && (attributeType = this.stakeholder.getAttributeType(attrType)) != null) {
            htmlString = HTMLEncoder.encode((String)attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), null, this.locale));
        }
        return htmlString;
    }

    @Override
    public String getModificationCount() {
        return String.valueOf(this.stakeholder.getModificationCount());
    }

    @Override
    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", this.getName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

