/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.IProjectRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.interfaces.IDateTimeProvider;
import de.plans.lib.util.HTMLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateTimeProvider
implements IProjectRelatedReportProvider,
IDateTimeProvider {
    private DateFormat dateFormat;
    private DateFormat dateTimeFormat;
    private DateFormat timeFormat;
    private SimpleDateFormat patternDrivenDateFormat;
    private Locale projectLocale;

    @Override
    public void setup(IProjectRelatedReportContext reportContext) {
        this.projectLocale = new Locale(reportContext.getProjectAgent().getLanguageID());
        this.dateFormat = DateFormat.getDateInstance(2, this.projectLocale);
        this.dateTimeFormat = DateFormat.getDateTimeInstance();
        this.timeFormat = DateFormat.getTimeInstance();
        String defaultPattern = new SimpleDateFormat().toPattern();
        this.patternDrivenDateFormat = new SimpleDateFormat(defaultPattern, this.projectLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentDate() {
        Class<DateTimeProvider> clazz = DateTimeProvider.class;
        synchronized (DateTimeProvider.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return HTMLEncoder.encode((String)this.dateFormat.format(new Date(System.currentTimeMillis())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentDateTime() {
        Class<DateTimeProvider> clazz = DateTimeProvider.class;
        synchronized (DateTimeProvider.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return HTMLEncoder.encode((String)this.dateTimeFormat.format(new Date(System.currentTimeMillis())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getCurrentDateTime_MilliSecondsSince_01_01_1970() {
        Class<DateTimeProvider> clazz = DateTimeProvider.class;
        synchronized (DateTimeProvider.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Long(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentTime() {
        Class<DateTimeProvider> clazz = DateTimeProvider.class;
        synchronized (DateTimeProvider.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return HTMLEncoder.encode((String)this.timeFormat.format(new Date(System.currentTimeMillis())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String printTimestampInCustomFormat(Long milliSecondSince_01_01_1970, String pattern) {
        Class<DateTimeProvider> clazz = DateTimeProvider.class;
        synchronized (DateTimeProvider.class) {
            block4: {
                if (milliSecondSince_01_01_1970 != null) break block4;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "-";
            }
            this.patternDrivenDateFormat.applyPattern(pattern);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.patternDrivenDateFormat.format(new Date(milliSecondSince_01_01_1970));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String printTimestampInISO8601Format(Long milliSecondSince_01_01_1970, boolean includingTime) {
        Class<DateTimeProvider> clazz = DateTimeProvider.class;
        synchronized (DateTimeProvider.class) {
            block6: {
                if (milliSecondSince_01_01_1970 != null) break block6;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "-";
            }
            String pattern = "yyyy-MM-dd";
            if (includingTime) {
                pattern = String.valueOf(pattern) + "'T'HH:mm";
            }
            this.patternDrivenDateFormat.applyPattern(pattern);
            String dateAndTime = this.patternDrivenDateFormat.format(new Date(milliSecondSince_01_01_1970));
            String timezone = "";
            if (includingTime) {
                this.patternDrivenDateFormat.applyPattern("Z");
                timezone = this.patternDrivenDateFormat.format(new Date(milliSecondSince_01_01_1970));
                timezone = timezone.equals("-0000") || timezone.equals("+0000") ? "Z" : String.valueOf(timezone.substring(0, 3)) + ":" + timezone.substring(3);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return String.valueOf(dateAndTime) + timezone;
        }
    }
}

