/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.ProjectOnServer;
import com.arcway.cockpit.docgen.provider.RootDataProvider;
import com.arcway.cockpit.docgen.provider.interfaces.IConfiguredProject;
import com.arcway.cockpit.docgen.provider.interfaces.IConfiguredServerConnection;
import com.arcway.cockpit.docgen.provider.interfaces.ILockOnServer;
import com.arcway.cockpit.docgen.provider.interfaces.IPermission;
import com.arcway.cockpit.docgen.provider.interfaces.IProjectOnServer;
import com.arcway.cockpit.docgen.provider.interfaces.IServerGroup;
import com.arcway.cockpit.docgen.provider.interfaces.IServerUser;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.model.GroupListModel;
import de.plans.psc.client.model.GroupWithUsers;
import de.plans.psc.client.model.PermissionListModel;
import de.plans.psc.client.model.User;
import de.plans.psc.client.model.UserGroup;
import de.plans.psc.client.model.UserListModel;
import de.plans.psc.client.model.UserWithGroups;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ConfiguredServerConnection
implements IConfiguredServerConnection {
    private static final ILogger LOGGER = Logger.getLogger(ConfiguredServerConnection.class);
    private final RootDataProvider rootDataProvider;
    private final ServerConnection serverConnection;
    private final IWorkbenchPage currentPage;

    public ConfiguredServerConnection(RootDataProvider rootDataProvider, ServerConnection serverConnection, IWorkbenchPage currentPage) {
        this.rootDataProvider = rootDataProvider;
        this.serverConnection = serverConnection;
        this.currentPage = currentPage;
    }

    @Override
    public boolean isSingleUserEnvironment() {
        return "Single-User".equals(this.serverConnection.getDirectoryType());
    }

    @Override
    public boolean isConnected() {
        return this.serverConnection.isConnected();
    }

    @Override
    public String getServerID() {
        return this.serverConnection.getServerID();
    }

    @Override
    public String getServerName() {
        return this.serverConnection.getServerName();
    }

    @Override
    public String getServerURL() {
        return this.serverConnection.getURL();
    }

    @Override
    public String getUserDistinguishedName() {
        return this.serverConnection.getDistinguishedName();
    }

    @Override
    public String getUserLoginID() {
        return this.serverConnection.getLoginID();
    }

    @Override
    public String getUserRealName() {
        return this.serverConnection.getRealName();
    }

    @Override
    public Map<String, IConfiguredProject> getConfiguredProjects() {
        Map<String, IConfiguredProject> configuredProjects = this.rootDataProvider.getConfiguredProjects();
        ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
        List projectsOfServer = projectMgr.getConfiguredProjectsOfServer(this.serverConnection.getServerID());
        HashMap<String, IConfiguredProject> configuredProjectsOfServer = new HashMap<String, IConfiguredProject>();
        for (ProjectAgent projectOfServer : projectsOfServer) {
            String projectUID = projectOfServer.getProjectUID();
            IConfiguredProject configuredProject = configuredProjects.get(projectUID);
            configuredProjectsOfServer.put(projectUID, configuredProject);
        }
        return configuredProjectsOfServer;
    }

    @Override
    public Map<String, IProjectOnServer> getProjectsOnServer() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        String serverID = this.serverConnection.getServerID();
        ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
        IProjectManagerServerProxy projectManagerServerProxy = projectMgr.getProjectManagerServerProxy(serverID);
        EOProject[] projects = projectManagerServerProxy.getAllProjectsOfServer();
        HashMap<String, IProjectOnServer> projectsOnServer = new HashMap<String, IProjectOnServer>();
        EOProject[] eOProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            EOProject project = eOProjectArray[n2];
            String uid = project.getProjectUID();
            projectsOnServer.put(uid, new ProjectOnServer(this, project, this.currentPage));
            ++n2;
        }
        return projectsOnServer;
    }

    @Override
    public Map<String, IServerUser> getUsers() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        String serverID = this.serverConnection.getServerID();
        UserListModel userListModel = new UserListModel();
        userListModel.loadUsersWithGroupsFromServer(serverID);
        final PermissionListModel permissionListModel = new PermissionListModel();
        permissionListModel.loadPermissionsFromServer(serverID);
        TreeMap<String, IServerUser> allServerUsers = new TreeMap<String, IServerUser>();
        int i = 0;
        while (i < userListModel.getSize()) {
            final UserWithGroups userWithGroups = (UserWithGroups)userListModel.getElement(i);
            final String userName = userWithGroups.getUserName();
            allServerUsers.put(userName, new IServerUser(){

                @Override
                public String getUserName() {
                    return userName;
                }

                @Override
                public String getDisplayName() {
                    return userWithGroups.getDisplayName();
                }

                @Override
                public String getEMail() {
                    return userWithGroups.getEMail();
                }

                @Override
                public String getDescription() {
                    return userWithGroups.getDescription();
                }

                @Override
                public Set<String> getGroupNames() {
                    List userGroups = userWithGroups.getGroups();
                    HashSet<String> groupNames = new HashSet<String>(2 * userGroups.size());
                    for (UserGroup userGroup : userGroups) {
                        String groupName = userGroup.getGroupName();
                        groupNames.add(groupName);
                    }
                    return groupNames;
                }

                @Override
                public Collection<IPermission> getServerPermissions() {
                    List eoPermissions = permissionListModel.getPermissionsOfUser(userName);
                    Collection<IPermission> permissions = ConfiguredServerConnection.convertPermissions(eoPermissions);
                    return permissions;
                }
            });
            ++i;
        }
        return allServerUsers;
    }

    @Override
    public Map<String, IServerGroup> getGroups() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        String serverID = this.serverConnection.getServerID();
        GroupListModel groupListModel = new GroupListModel();
        groupListModel.loadGroupsWithUsersAndPrivilegesFromServer(serverID);
        final PermissionListModel permissionListModel = new PermissionListModel();
        permissionListModel.loadPermissionsFromServer(serverID);
        TreeMap<String, IServerGroup> allServerUsers = new TreeMap<String, IServerGroup>();
        int i = 0;
        while (i < groupListModel.getSize()) {
            final GroupWithUsers groupWithUsers = (GroupWithUsers)groupListModel.getElement(i);
            final String groupName = groupWithUsers.getGroupName();
            allServerUsers.put(groupName, new IServerGroup(){

                @Override
                public String getGroupName() {
                    return groupName;
                }

                @Override
                public String getDisplayName() {
                    return groupWithUsers.getDisplayName();
                }

                @Override
                public String getDescription() {
                    return groupWithUsers.getDescription();
                }

                @Override
                public Set<String> getUserNames() {
                    List users = groupWithUsers.getUsers();
                    HashSet<String> userNames = new HashSet<String>(2 * users.size());
                    for (User user : users) {
                        String userName = user.getUserName();
                        userNames.add(userName);
                    }
                    return userNames;
                }

                @Override
                public Collection<IPermission> getServerPermissions() {
                    List eoPermissions = permissionListModel.getPermissionsOfGroup(groupName);
                    Collection<IPermission> permissions = ConfiguredServerConnection.convertPermissions(eoPermissions);
                    return permissions;
                }
            });
            ++i;
        }
        return allServerUsers;
    }

    public static Collection<IPermission> convertPermissions(List<EOPermission> eoPermissions) {
        ArrayList<IPermission> permissions = new ArrayList<IPermission>(eoPermissions.size());
        for (final EOPermission eoPermission : eoPermissions) {
            permissions.add(new IPermission(){

                @Override
                public String getOperandType() {
                    return eoPermission.getOperandType();
                }

                @Override
                public String getOperandUID() {
                    return eoPermission.getOperandUID();
                }

                @Override
                public String getOperation() {
                    return eoPermission.getOperation();
                }

                @Override
                public String getOperation2() {
                    return eoPermission.getOperation2();
                }

                @Override
                public boolean isOwnerTypeUser() {
                    return eoPermission.isOwnerTypeUser();
                }

                @Override
                public boolean isOwnerTypeGroup() {
                    return eoPermission.isOwnerTypeGroup();
                }

                @Override
                public String getOwnerID() {
                    return eoPermission.getOwnerID();
                }

                @Override
                public int getOwnerType() {
                    return eoPermission.getOwnerType();
                }

                @Override
                public String getPermissionUID() {
                    return eoPermission.getPermissionUID();
                }

                @Override
                public String getSubSetType() {
                    return eoPermission.getSubSetType();
                }

                @Override
                public String getSubSetUID() {
                    return eoPermission.getSubSetUID();
                }
            });
        }
        return permissions;
    }

    @Override
    public String getServerDumpAsFileName(String fileNamePrefix, Collection<? extends String> projectUIDsToExclude) {
        String serverID = this.serverConnection.getServerID();
        ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
        IProjectManagerServerProxy projectManagerServerProxy = projectMgr.getProjectManagerServerProxy(serverID);
        try {
            File tempFile = SessionTempDirectoryManager.createSessionTempFile((String)fileNamePrefix, (String)"zip");
            IWorkbenchWindow workbenchWindow = this.currentPage == null ? null : this.currentPage.getWorkbenchWindow();
            Shell shell = workbenchWindow == null ? null : workbenchWindow.getShell();
            projectManagerServerProxy.dumpServer(tempFile, projectUIDsToExclude == null ? Collections.emptySet() : projectUIDsToExclude, shell);
            tempFile.deleteOnExit();
            return AbstractAttributeOwnerDocGenProxy.getFileName(tempFile);
        }
        catch (Exception e) {
            LOGGER.error("Error while dumping the server " + serverID + " / " + this.serverConnection.getServerName(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Collection<? extends ILockOnServer> getAllLocksOnServer() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        String serverID = this.serverConnection.getServerID();
        ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
        IProjectManagerServerProxy projectManagerServerProxy = projectMgr.getProjectManagerServerProxy(serverID);
        Collection allEOLocksOnServer = projectManagerServerProxy.getAllLocksOnServer();
        Collection<? extends ILockOnServer> allLocksOnServer = ConfiguredServerConnection.convertLocks(allEOLocksOnServer);
        return allLocksOnServer;
    }

    private static Collection<? extends ILockOnServer> convertLocks(Collection<EOLock> allEOLocksOnServer) {
        ArrayList<4> allLocksOnServer = new ArrayList<4>(allEOLocksOnServer.size());
        for (final EOLock eoLock : allEOLocksOnServer) {
            allLocksOnServer.add(new ILockOnServer(){

                @Override
                public String getUserName() {
                    return eoLock.getUserName();
                }

                @Override
                public String getUID() {
                    return eoLock.getUID();
                }

                @Override
                public String getProjectUID() {
                    return eoLock.getProjectUID();
                }

                @Override
                public String getLockedItemUID() {
                    return eoLock.getLockedItemUID();
                }

                @Override
                public String getLockedItemType() {
                    return eoLock.getLockedItemType();
                }

                @Override
                public String getLockTypeID() {
                    return eoLock.getLockTypeID();
                }

                @Override
                public Long getCreationTime() {
                    return eoLock.getCreationTime().getTime();
                }

                @Override
                public String getClientName() {
                    return eoLock.getClientName();
                }
            });
        }
        return allLocksOnServer;
    }
}

