/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.ascii;

import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.writer.AbstractDocumentationWriterWithProgress;
import com.arcway.cockpit.docgen.writer.ExtensionBasedReportOutputFormat;
import com.arcway.cockpit.docgen.writer.ascii.ClientFunctionLicenseTypeReportsASCII;
import com.arcway.cockpit.docgen.writer.ascii.Messages;
import com.arcway.cockpit.docgen.writer.reporttypesandtemplates.VelocityReportTemplateTypes;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorManager;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.DynamicReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;

public class ASCIIDocumentationWriter
extends AbstractDocumentationWriterWithProgress {
    private static final ILogger logger = Logger.getLogger(ASCIIDocumentationWriter.class);
    private static final String REPORT_TYPE_ID = "ASCII_DOCUMENT";
    private static final String FILES_AND_IMAGES_DIRECTORY_NAME = "files_and_images";
    private static final double PREFERRED_IMAGE_RESOLUTION = 192.0;
    private static final int PREFERRED_IMAGE_SIZE = 2400;
    private static final Set<String> applicableReportTemplateTypes = new HashSet<String>(2);

    static {
        applicableReportTemplateTypes.add("velocity.non-docbook");
        applicableReportTemplateTypes.add("velocity.unspecified");
    }

    public ASCIIDocumentationWriter() {
        super(true, false);
    }

    public String getID() {
        return REPORT_TYPE_ID;
    }

    public String getDisplayName() {
        return Messages.getString("DocumentationWriter.ASCII");
    }

    public String getDescription() {
        return "";
    }

    public Set<String> getApplicableReportTemplateTypes() {
        return applicableReportTemplateTypes;
    }

    public String getRequiredOutputTemplateTypeID() {
        return null;
    }

    public String getOutputFormat(IReportTemplate reportTemplate) {
        File reportTemplateFile = reportTemplate.getReportFile();
        String targetType = VelocityReportTemplateTypes.getReportTemplateTargetType((File)reportTemplateFile);
        try {
            FileHelper.deleteExistingFileOrDirectory((File)reportTemplateFile);
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.warn("Could not delete report template file.", (Throwable)e);
        }
        ExtensionBasedReportOutputFormat reportOutputFormat = targetType == null ? new ExtensionBasedReportOutputFormat("txt") : new ExtensionBasedReportOutputFormat(targetType);
        DocGeneratorManager.registerReportOutputFormat((DynamicReportOutputFormat)reportOutputFormat);
        return reportOutputFormat.getID();
    }

    public PlanImageSizeHint getPreferredImageSize() {
        return PlanImageSizeHint.getSizeHintInPixel((Dimension)new Dimension(2400.0, 2400.0), (double)192.0);
    }

    public String getPreferredImageType() {
        return ".svg";
    }

    public String getSnippetForFileInRawReportFormat(String fileName, String displayName, String format, double width_mm, double height_mm) {
        return FILES_AND_IMAGES_DIRECTORY_NAME + File.separator + fileName;
    }

    protected void postProcessWithProgress(VelocityReportJob reportJob, IWorkbenchPage workbenchPage, IProgressMonitor progressMonitor) throws ReportGenerationException {
        if (progressMonitor != null) {
            progressMonitor.beginTask(Messages.getString("DocumentationWriter.0"), -1);
            progressMonitor.subTask(Messages.getString("DocumentationWriter.2"));
        }
        this.copyRawReportToTargetLocation(reportJob);
        this.copyGraphicsAndFilesToTargetLocation(reportJob, FILES_AND_IMAGES_DIRECTORY_NAME);
    }

    protected void postprocessingInterrupted(VelocityReportJob reportJob) {
        this.cleanUpReportFile(reportJob);
        this.cleanUpAdditionalDirectory(reportJob, FILES_AND_IMAGES_DIRECTORY_NAME);
    }

    public IClientFunctionLicenseType getNeededLicenseType() {
        return ClientFunctionLicenseTypeReportsASCII.getInstance();
    }
}

