/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.DocBookPostProcessingProgress;
import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSection;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSubtitle;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTitle;
import com.arcway.cockpit.docgen.writer.wordML.StyleMap;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.AnchorWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.MediaObjectWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.SubTitleWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.TableWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.TitleWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.ISectionParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.SectionWrapper;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import java.util.List;

public class SectionWriter {
    private static SectionWriter writer;

    public static SectionWriter getInstance() {
        if (writer == null) {
            writer = new SectionWriter();
        }
        return writer;
    }

    private SectionWriter() {
    }

    public void write(EOSection section, ISectionParent parent, int level, StyleMap styleMap, DocBook2WordMLGenerationContext context, DocBookPostProcessingProgress progress) throws ReportGenerationException, ReportGenerationCanceledException {
        EOSubtitle subtitle;
        progress.incrementSectionProgress();
        SectionWrapper s = parent.addSection();
        EOTitle title = section.getTitle();
        if (title != null) {
            String style = styleMap.findStyle("heading " + level);
            TitleWriter.getInstance().write(title, s.addParagraph(style), context);
        }
        if ((subtitle = section.getSubtitle()) != null) {
            String style = styleMap.findStyle("heading " + (level + 1));
            SubTitleWriter.getInstance().write(subtitle, s.addParagraph(style), context);
        }
        List contentList = section.getContent();
        for (Object obj : contentList) {
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, s, context);
            } else if (obj instanceof EOMediaObject) {
                MediaObjectWriter.getInstance().write((EOMediaObject)obj, s, context);
            } else if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, s, context);
            } else if (obj instanceof EOSection) {
                this.write((EOSection)obj, s, level + 1, styleMap, context, progress);
            } else if (obj instanceof EOTable) {
                TableWriter.getInstance().write((EOTable)obj, s, context);
            } else if (obj instanceof EOSimpleList) {
                SimpleListWriter.getInstance().write((EOSimpleList)obj, s, context);
            }
            progress.checkCancelState();
        }
    }
}

